/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.simulink.model.element;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.stream.Collectors;
import org.eclipse.epsilon.emc.simulink.engine.MatlabEngine;
import org.eclipse.epsilon.emc.simulink.exception.MatlabException;
import org.eclipse.epsilon.emc.simulink.model.IGenericSimulinkModel;
import org.eclipse.epsilon.emc.simulink.model.SimulinkModel;
import org.eclipse.epsilon.emc.simulink.model.TypeHelper;
import org.eclipse.epsilon.emc.simulink.model.element.ISimulinkModelElement;
import org.eclipse.epsilon.emc.simulink.model.element.SimulinkBlock;
import org.eclipse.epsilon.emc.simulink.model.element.SimulinkModelElement;
import org.eclipse.epsilon.emc.simulink.util.SimulinkUtil;
import org.eclipse.epsilon.emc.simulink.util.StateflowUtil;
import org.eclipse.epsilon.emc.simulink.util.collection.StateflowBlockCollection;
import org.eclipse.epsilon.eol.exceptions.EolIllegalPropertyException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;

public class StateflowBlock
extends SimulinkModelElement {
    private static final String SIMPLE_TYPE = "?.classhandle.get('Name');";
    private static final String DELETE_SF = "?.delete;";
    private Double id;
    private HashMap<String, Object> properties = new HashMap();

    public StateflowBlock(SimulinkModel model, MatlabEngine engine, String type, StateflowBlock parent) throws MatlabException, EolRuntimeException {
        super((IGenericSimulinkModel)model, engine);
        this.setType(type);
        this.buildFromStateflow(parent);
    }

    public StateflowBlock(SimulinkModel model, MatlabEngine engine, String type) throws MatlabException {
        super((IGenericSimulinkModel)model, engine);
        this.setType(type);
    }

    public StateflowBlock(SimulinkModel model, MatlabEngine engine, Double stateflowId) throws MatlabException {
        super((IGenericSimulinkModel)model, engine);
        this.id = stateflowId;
        this.setType();
    }

    public StateflowBlock(SimulinkModel model, MatlabEngine engine, Integer stateflowId) throws MatlabException {
        this(model, engine, stateflowId.doubleValue());
    }

    public StateflowBlock(SimulinkModel model, MatlabEngine engine, String type, Double stateflowId) throws MatlabException {
        super((IGenericSimulinkModel)model, engine);
        this.id = stateflowId;
        this.setType();
    }

    public StateflowBlock(SimulinkModel model, MatlabEngine engine, String type, Integer stateflowId) throws MatlabException {
        this(model, engine, type, stateflowId.doubleValue());
    }

    private void setType(String type) throws MatlabException {
        if (type != null && type.startsWith("Stateflow")) {
            this.type = type;
        } else {
            this.setType();
        }
    }

    private void setType() throws MatlabException {
        if (this.id != null) {
            String handle = StateflowUtil.getBlockHandleFromId((SimulinkModel)this.model, this.engine, this.id);
            this.type = "Stateflow." + (String)this.engine.evalWithResult(SIMPLE_TYPE, new Object[]{handle});
        }
    }

    public String getType() {
        return this.type;
    }

    private boolean isUnset() {
        return this.id == null;
    }

    public Object getProperty(String property) throws EolIllegalPropertyException {
        if (this.isUnset()) {
            return this.properties.get(property.toLowerCase());
        }
        if (property.equalsIgnoreCase("parent") || property.equalsIgnoreCase("up")) {
            try {
                return this.getParent();
            }
            catch (EolRuntimeException eolRuntimeException) {
                throw new EolIllegalPropertyException((Object)this, property, null, null);
            }
        }
        try {
            String h = StateflowUtil.getBlockHandle(this);
            return this.engine.evalWithResult("?.?;", new Object[]{h, property});
        }
        catch (MatlabException matlabException) {
            throw new EolIllegalPropertyException((Object)this, property, null, null);
        }
    }

    public void setProperty(String property, Object value) throws EolIllegalPropertyException {
        block11: {
            try {
                if (property.equalsIgnoreCase("parent") || property.equalsIgnoreCase("up")) {
                    if (value instanceof StateflowBlock) {
                        try {
                            this.setParent((StateflowBlock)((Object)value));
                            break block11;
                        }
                        catch (EolRuntimeException eolRuntimeException) {
                            throw new EolIllegalPropertyException((Object)this, property, null, null);
                        }
                    }
                    throw new EolIllegalPropertyException((Object)this, property, null, null);
                }
                if (this.isUnset()) {
                    this.properties.put(property.toLowerCase(), value);
                } else {
                    String valueStr;
                    String escaped = "?";
                    String randomHandle = "";
                    if (value instanceof StateflowBlock) {
                        randomHandle = StateflowUtil.getBlockHandle((StateflowBlock)((Object)value));
                        value = randomHandle;
                    }
                    if (!(!(value instanceof String) || value.equals(randomHandle) || (valueStr = (String)value).startsWith("'") && valueStr.endsWith("'") || valueStr.startsWith("[") && valueStr.endsWith("]"))) {
                        escaped = "'" + escaped + "'";
                    }
                    if (value instanceof Collection) {
                        value = "[" + ((Collection)value).stream().map(String::valueOf).collect(Collectors.joining(",")) + "]";
                    }
                    escaped = escaped.replace("?", String.valueOf(value));
                    String cmd = "?.? = " + escaped + ";";
                    String h = StateflowUtil.getBlockHandle(this);
                    this.engine.eval(cmd, new Object[]{h, property});
                }
            }
            catch (MatlabException matlabException) {
                throw new EolIllegalPropertyException((Object)this, property, null, null);
            }
        }
    }

    public Double getId() {
        return this.id;
    }

    public String getPath() {
        if (this.id != null) {
            try {
                String handle = StateflowUtil.getBlockHandleFromId((SimulinkModel)this.model, this.engine, this.id);
                return (String)this.engine.evalWithResult("?.path;", new Object[]{handle});
            }
            catch (MatlabException matlabException) {}
        }
        return null;
    }

    public ISimulinkModelElement getParent() throws EolRuntimeException {
        try {
            String h = StateflowUtil.getBlockHandle(this);
            try {
                Double parentId = (Double)this.engine.evalWithResult("?.up.id;", new Object[]{h});
                return new StateflowBlock((SimulinkModel)this.model, this.engine, parentId);
            }
            catch (MatlabException matlabException) {
                String path = (String)this.engine.evalWithResult("?.path;", new Object[]{h});
                return new SimulinkBlock(path, (SimulinkModel)this.model, this.engine);
            }
        }
        catch (MatlabException e1) {
            throw new EolRuntimeException(e1.getMessage());
        }
    }

    public void setParent(StateflowBlock parent) throws EolRuntimeException, MatlabException {
        if (!this.isUnset()) {
            this.changeParent(parent);
        } else {
            this.buildFromStateflow(parent);
            this.applyProperties();
        }
    }

    private void applyProperties() throws EolIllegalPropertyException {
        for (String key : this.properties.keySet()) {
            this.setProperty(key, this.properties.get(key));
        }
        this.properties.clear();
    }

    private void changeParent(StateflowBlock parent) throws EolRuntimeException {
        throw new EolRuntimeException("Changing parent is not yet implemented");
    }

    private void buildFromStateflow(StateflowBlock parent) throws EolRuntimeException {
        if (!parent.isUnset()) {
            try {
                String parentHandle = StateflowUtil.getBlockHandle(parent);
                this.engine.eval("block = ?(?);", new Object[]{this.getType(), parentHandle});
                this.id = (Double)this.engine.evalWithResult("block.id;");
            }
            catch (MatlabException e) {
                throw new EolRuntimeException(e.getMessage());
            }
        } else {
            throw new EolRuntimeException("Parent was not a valid entity");
        }
    }

    public StateflowBlockCollection getChildren() {
        try {
            String handle = StateflowUtil.getBlockHandle(this);
            Object children = this.engine.evalWithSetupAndResult("list = ?.find('-depth',1); list = setdiff(list, ?);", "get(list,'Id');", new Object[]{handle, handle});
            return new StateflowBlockCollection(children, (SimulinkModel)this.model);
        }
        catch (MatlabException matlabException) {
            return new StateflowBlockCollection(null, (SimulinkModel)this.model);
        }
    }

    public StateflowBlock inspect() {
        try {
            String h = StateflowUtil.getBlockHandle(this);
            this.engine.eval("get(?);", new Object[]{h});
        }
        catch (MatlabException matlabException) {}
        return this;
    }

    public boolean equals(Object other) {
        return other instanceof StateflowBlock && ((StateflowBlock)((Object)other)).getId().equals(this.getId());
    }

    public String toString() {
        return String.valueOf(this.getType()) + "[ id = " + this.getId() + ", path = " + this.getPath() + " ]";
    }

    public Collection<String> getAllTypeNamesOf() {
        return Arrays.asList(TypeHelper.Kind.STATEFLOW.getKind(), this.getType());
    }

    public boolean deleteElementInModel() throws EolRuntimeException {
        try {
            this.engine.eval(DELETE_SF, new Object[]{StateflowUtil.getBlockHandle(this)});
            this.engine.flush();
            return true;
        }
        catch (MatlabException matlabException) {
            return false;
        }
    }

    public StateflowBlock add(StateflowBlock block) throws EolRuntimeException {
        try {
            block.setParent(this);
        }
        catch (MatlabException e) {
            e.printStackTrace();
        }
        return this;
    }

    public SimulinkBlock asSimulink() throws EolRuntimeException {
        Double h = SimulinkUtil.getHandle(this.getPath(), this.engine);
        if (h >= 0.0) {
            return new SimulinkBlock((SimulinkModel)this.model, this.engine, h);
        }
        throw new EolRuntimeException("This block does not have a simulink Nature");
    }

    public Double getHandle() {
        return this.getId();
    }

    public Boolean isCommented() throws EolRuntimeException {
        try {
            String handle = StateflowUtil.getBlockHandleFromId((SimulinkModel)this.model, this.engine, this.id);
            return (Boolean)this.engine.evalWithResult("isCommented(?);", new Object[]{handle});
        }
        catch (Exception e) {
            throw new EolRuntimeException(e.getMessage());
        }
    }
}

