/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.simulink.types;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.epsilon.common.util.ReflectionUtil;
import org.eclipse.epsilon.emc.simulink.util.ReflectionLocalUtil;

public class Complex {
    private static final String COMPLEX_MATLAB_CLASS = "com.mathworks.matlab.types.Complex";
    private static Class<?> complex_class;
    private Object complex;

    public static boolean is(Object obj) {
        return Complex.getMatlabClass() == null ? false : Complex.getMatlabClass().isInstance(obj);
    }

    private static Class<?> getMatlabClass() {
        if (complex_class == null) {
            try {
                complex_class = ClassLoader.getSystemClassLoader().loadClass(COMPLEX_MATLAB_CLASS);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return complex_class;
    }

    public Complex(Object complex) {
        if (Complex.is(complex)) {
            this.complex = complex;
        }
    }

    public Complex(Double real, Double imag) {
        try {
            Constructor<?> constructor = Complex.getMatlabClass().getConstructor(Double.TYPE, Double.TYPE);
            this.complex = constructor.newInstance(real, imag);
        }
        catch (NoSuchMethodException | SecurityException e) {
            e.printStackTrace();
            System.out.println("Problem retrieving constructor of the complex type");
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            System.out.println("Problem instantiating the complex type");
            e.printStackTrace();
        }
    }

    public Complex(Double real, Integer imag) {
        this(real, (Double)imag.doubleValue());
    }

    public Complex(Integer real, Double imag) {
        this((Double)real.doubleValue(), imag);
    }

    public Complex(Integer real, Integer imag) {
        this((Double)real.doubleValue(), (Double)imag.doubleValue());
    }

    public Complex() {
        this((Integer)0, (Integer)0);
    }

    public Double getReal() throws Exception {
        return (Double)ReflectionLocalUtil.getFieldValue(this.complex, "real");
    }

    public void setReal(Double real) throws Exception {
        ReflectionLocalUtil.setFieldValue(this.complex, "real", real);
    }

    public void setReal(Integer real) throws Exception {
        this.setReal(real.doubleValue());
    }

    public Double getImag() throws Exception {
        return (Double)ReflectionLocalUtil.getFieldValue(this.complex, "imag");
    }

    public void setImag(Double imag) throws Exception {
        ReflectionLocalUtil.setFieldValue(this.complex, "imag", imag);
    }

    public void setImag(Integer imag) throws Exception {
        this.setImag(imag.doubleValue());
    }

    public String toString() {
        try {
            return (String)ReflectionUtil.invokeMethod((Object)this.complex, (String)"toString", null);
        }
        catch (Exception exception) {
            return "";
        }
    }
}

