/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.modelmutator.mutation;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.Collection;
import java.util.HashSet;
import java.util.Random;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.emfstore.internal.modelmutator.mutation.ContainmentChangeMutation;
import org.eclipse.emf.emfstore.internal.modelmutator.mutation.Mutation;
import org.eclipse.emf.emfstore.internal.modelmutator.mutation.MutationPredicates;
import org.eclipse.emf.emfstore.internal.modelmutator.mutation.MutationTargetSelector;
import org.eclipse.emf.emfstore.modelmutator.ESModelMutatorUtil;
import org.eclipse.emf.emfstore.modelmutator.ESMoveObjectMutation;
import org.eclipse.emf.emfstore.modelmutator.ESMutationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveObjectMutation
extends ContainmentChangeMutation<ESMoveObjectMutation>
implements ESMoveObjectMutation {
    private final MutationTargetSelector sourceContainerSelector;
    private EObject eObjectToMove;

    public MoveObjectMutation(ESModelMutatorUtil util) {
        super(util);
        this.sourceContainerSelector = new MutationTargetSelector(util);
        this.addSourceContainmentFeaturePredicate();
        this.addSourceOriginalFeatureValueNotEmptyPredicate();
        this.addTargetValueIsEmptySingleValuedReferenceOrMultivalueReferencePredicate();
    }

    protected MoveObjectMutation(ESModelMutatorUtil util, MutationTargetSelector sourceContainerSelector, MutationTargetSelector targetContainerSelector) {
        super(util, targetContainerSelector);
        this.sourceContainerSelector = sourceContainerSelector;
        this.addSourceContainmentFeaturePredicate();
        this.addSourceOriginalFeatureValueNotEmptyPredicate();
        this.addTargetValueIsEmptySingleValuedReferenceOrMultivalueReferencePredicate();
    }

    private void addSourceContainmentFeaturePredicate() {
        this.sourceContainerSelector.getTargetFeaturePredicates().add(MutationPredicates.IS_MUTABLE_CONTAINMENT_REFERENCE);
    }

    private void addSourceOriginalFeatureValueNotEmptyPredicate() {
        this.sourceContainerSelector.getOriginalFeatureValuePredicates().add(MutationPredicates.IS_NON_EMPTY_EOBJECT_OR_LIST);
    }

    private void addTargetValueIsEmptySingleValuedReferenceOrMultivalueReferencePredicate() {
        this.getTargetContainerSelector().getOriginalFeatureValuePredicates().add(MutationPredicates.IS_NULL_OR_LIST);
    }

    public Collection<EClass> getExcludedSourceEClasses() {
        return this.sourceContainerSelector.getExcludedEClasses();
    }

    public Collection<EStructuralFeature> getExcludedSourceFeatures() {
        return this.sourceContainerSelector.getExcludedFeatures();
    }

    public Collection<EObject> getExcludedSourceObjects() {
        return this.sourceContainerSelector.getExcludedObjects();
    }

    @Override
    public ESMoveObjectMutation setSourceObject(EObject sourceObject) {
        this.sourceContainerSelector.setTargetObject(sourceObject);
        return this;
    }

    @Override
    public EObject getSourceObject() {
        return this.sourceContainerSelector.getTargetObject();
    }

    @Override
    public ESMoveObjectMutation setSourceFeature(EStructuralFeature sourceFeature) {
        this.sourceContainerSelector.setTargetFeature(sourceFeature);
        return this;
    }

    public EStructuralFeature getSourceFeature() {
        return this.sourceContainerSelector.getTargetFeature();
    }

    @Override
    public ESMoveObjectMutation setEObjectToMove(EObject eObjectToMove) {
        this.eObjectToMove = eObjectToMove;
        return this;
    }

    @Override
    public EObject getEObjectToMove() {
        return this.eObjectToMove;
    }

    @Override
    public Mutation clone() {
        MoveObjectMutation clone = new MoveObjectMutation(this.getUtil(), this.sourceContainerSelector, this.getTargetContainerSelector());
        clone.setEObjectToMove(this.eObjectToMove);
        return clone;
    }

    @Override
    public void apply() throws ESMutationException {
        this.doSelection();
        EObject targetObject = this.getTargetContainerSelector().getTargetObject();
        EReference targetReference = (EReference)this.getTargetContainerSelector().getTargetFeature();
        Random random = this.getRandom();
        if (targetReference.isMany()) {
            Integer insertionIndex = random.nextBoolean() ? Integer.valueOf(0) : null;
            this.getUtil().addPerCommand(targetObject, (EStructuralFeature)targetReference, this.getEObjectToMove(), insertionIndex);
        } else {
            this.getUtil().setPerCommand(targetObject, (EStructuralFeature)targetReference, this.getEObjectToMove());
        }
    }

    private void doSelection() throws ESMutationException {
        if (this.getEObjectToMove() != null) {
            this.makeSureTargetFitsSelectedEObjectToMove();
            this.makeSureTargetContainerIsNotChildOfEObjectToMove();
            this.getTargetContainerSelector().doSelection();
        } else if (this.haveTargetContainer() && this.haveTargetFeature()) {
            this.makeSureSourceContainerIsNotTheSameAsTargetContainer();
            this.makeSureSourceFeatureIsCompatibleWithTargetFeature();
            this.sourceContainerSelector.doSelection();
            this.selectEObjectToMove();
        } else if (this.haveTargetContainer()) {
            this.makeSureSourceContainerIsNotTheSameAsTargetContainer();
            this.makeSureSourceFeatureIsCompatibleWithAnyFeatureOfTargetContainer();
            this.makeSureSourceContainerIsNotAncesterOfTargetContainer();
            this.selectSourceAndTarget();
        } else if (this.haveTargetFeature()) {
            this.makeSureSourceFeatureIsCompatibleWithTargetFeature();
            this.selectSourceAndTarget();
        } else {
            this.selectSourceAndTarget();
        }
    }

    private void selectSourceAndTarget() throws ESMutationException {
        this.sourceContainerSelector.doSelection();
        this.selectEObjectToMove();
        this.makeSureTargetFitsSelectedEObjectToMove();
        this.makeSureTargetContainerIsNotTheSameAsSourceContainer();
        this.makeSureTargetContainerIsNotChildOfEObjectToMove();
        this.getTargetContainerSelector().doSelection();
    }

    private boolean haveTargetFeature() {
        return this.getTargetContainerSelector().getTargetFeature() != null;
    }

    private boolean haveTargetContainer() {
        return this.getTargetContainerSelector().getTargetObject() != null;
    }

    private void makeSureTargetFitsSelectedEObjectToMove() {
        this.getTargetContainerSelector().getTargetFeaturePredicates().add(MutationPredicates.mayTakeEObjectAsValue(this.getEObjectToMove()));
        this.getTargetContainerSelector().getTargetObjectPredicates().add(MutationPredicates.isNotTheSame(this.getEObjectToMove().eContainer()));
    }

    private void makeSureSourceContainerIsNotTheSameAsTargetContainer() {
        this.sourceContainerSelector.getTargetObjectPredicates().add(MutationPredicates.isNotTheSame(this.getTargetContainerSelector().getTargetObject()));
    }

    private void makeSureSourceFeatureIsCompatibleWithAnyFeatureOfTargetContainer() {
        this.sourceContainerSelector.getTargetFeaturePredicates().add(MutationPredicates.isCompatibleWithAnyFeatureOfEClass(this.getTargetContainerSelector().getTargetObject().eClass()));
    }

    private void makeSureSourceFeatureIsCompatibleWithTargetFeature() {
        this.sourceContainerSelector.getTargetFeaturePredicates().add(MutationPredicates.hasCompatibleType(this.getTargetContainerSelector().getTargetFeature()));
    }

    private void makeSureTargetContainerIsNotTheSameAsSourceContainer() {
        this.getTargetContainerSelector().getTargetObjectPredicates().add(MutationPredicates.isNotTheSame(this.sourceContainerSelector.getTargetObject()));
    }

    private void selectEObjectToMove() throws ESMutationException {
        HashSet<Predicate<? super Object>> predicates = new HashSet<Predicate<? super Object>>();
        predicates.addAll(this.predicatesOnEObjectToMoveFromSourceSelector());
        predicates.addAll(this.predicatesOnEObjectToMoveFromTargetSelector());
        Object objectToMove = this.sourceContainerSelector.selectRandomContainedValue((Predicate<? super Object>)Predicates.and(predicates));
        if (objectToMove == null || !(objectToMove instanceof EObject)) {
            throw new ESMutationException("Cannot find object to move.");
        }
        this.setEObjectToMove((EObject)objectToMove);
    }

    private Collection<Predicate<? super Object>> predicatesOnEObjectToMoveFromSourceSelector() {
        HashSet<Predicate<? super Object>> predicates = new HashSet<Predicate<? super Object>>();
        if (this.sourceContainerSelector.getTargetFeature() != null) {
            predicates.add(this.getIsContainedByFeaturePredicate());
        }
        if (this.sourceContainerSelector.getTargetObject() != null) {
            predicates.add(this.getIsContainedByEObjectPredicate());
        }
        return predicates;
    }

    private Collection<Predicate<? super Object>> predicatesOnEObjectToMoveFromTargetSelector() {
        HashSet<Predicate<? super Object>> predicates = new HashSet<Predicate<? super Object>>();
        if (this.haveTargetFeature()) {
            predicates.add(this.getMayBeContainedByFeaturePredicate());
        } else if (this.haveTargetContainer()) {
            EClass targetEClass = this.getTargetContainerSelector().getTargetObject().eClass();
            predicates.add(this.getMayBeContainedByAnyOfTheseReferencesPredicate(targetEClass));
        }
        return predicates;
    }

    private Predicate<? super Object> getIsContainedByEObjectPredicate() {
        return MutationPredicates.isContainedByEObject(this.sourceContainerSelector.getTargetObject());
    }

    private Predicate<? super Object> getIsContainedByFeaturePredicate() {
        return MutationPredicates.isContainedByFeature(this.sourceContainerSelector.getTargetFeature());
    }

    private Predicate<? super Object> getMayBeContainedByAnyOfTheseReferencesPredicate(EClass targetEClass) {
        return MutationPredicates.mayBeContainedByAnyOfTheseReferences((Iterable<EReference>)targetEClass.getEAllContainments());
    }

    private Predicate<? super Object> getMayBeContainedByFeaturePredicate() {
        return MutationPredicates.mayBeContainedByFeature(this.getTargetContainerSelector().getTargetFeature());
    }

    private void makeSureTargetContainerIsNotChildOfEObjectToMove() {
        this.getTargetContainerSelector().getTargetObjectPredicates().add((Predicate<? super EObject>)Predicates.not(MutationPredicates.isChild(this.getEObjectToMove())));
    }

    private void makeSureSourceContainerIsNotAncesterOfTargetContainer() {
        this.sourceContainerSelector.getTargetObjectPredicates().add((Predicate<? super EObject>)Predicates.not(MutationPredicates.isAncestor(this.getTargetContainerSelector().getTargetObject())));
    }
}

