/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.dialogs.admin;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.internal.client.model.AdminBroker;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.EMFStoreMessageDialog;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.admin.GroupComposite;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.admin.Messages;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.admin.OrgUnitManagementGUI;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.admin.ProjectComposite;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.admin.PropertiesComposite;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.admin.UserComposite;
import org.eclipse.emf.emfstore.internal.server.model.ProjectInfo;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACGroup;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACUser;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.Form;

public class PropertiesForm
extends Form {
    private EObject input;
    private final StackLayout stackLayout = new StackLayout();
    private ProjectComposite projectComposite;
    private GroupComposite groupComposite;
    private UserComposite userComposite;
    private final AdminBroker adminBroker;
    private static EObject dragNDropObject;
    private static String dragSource;

    static {
        dragSource = "";
    }

    public PropertiesForm(Composite parent, int style, AdminBroker adminBroker, OrgUnitManagementGUI orgUnitManagementGUI) {
        super(parent, style);
        this.getBody().setLayout((Layout)this.stackLayout);
        this.adminBroker = adminBroker;
        this.initComposites(orgUnitManagementGUI, this.getBody());
    }

    private void initComposites(OrgUnitManagementGUI orgUnitMgmtGUI, Composite body) {
        this.projectComposite = new ProjectComposite(body, 0, this.adminBroker);
        this.groupComposite = new GroupComposite(body, 0, this.adminBroker, orgUnitMgmtGUI);
        this.userComposite = new UserComposite(body, 0, this.adminBroker, orgUnitMgmtGUI);
        this.stackLayout.topControl = this.projectComposite;
    }

    public void setInput(EObject input) {
        String title = "";
        if (input != null && !this.getBody().isVisible()) {
            this.getBody().setVisible(true);
        }
        if (input instanceof ProjectInfo) {
            ProjectInfo projectInfo = (ProjectInfo)input;
            title = String.valueOf(Messages.PropertiesForm_Project) + projectInfo.getName();
            this.stackLayout.topControl = this.projectComposite;
            this.projectComposite.updateControls((EObject)projectInfo);
        } else if (input instanceof ACGroup) {
            try {
                ACGroup group = (ACGroup)this.adminBroker.getOrgUnit(((ACGroup)input).getId());
                title = String.valueOf(Messages.PropertiesForm_Group) + group.getName();
                this.stackLayout.topControl = this.groupComposite;
                this.groupComposite.updateControls((EObject)group);
            }
            catch (ESException e) {
                EMFStoreMessageDialog.showExceptionDialog((Exception)((Object)e));
            }
        } else if (input instanceof ACUser) {
            try {
                ACUser user = (ACUser)this.adminBroker.getOrgUnit(((ACUser)input).getId());
                title = String.valueOf(Messages.PropertiesForm_User) + user.getName();
                this.stackLayout.topControl = this.userComposite;
                this.userComposite.updateControls((EObject)user);
            }
            catch (ESException e) {
                EMFStoreMessageDialog.showExceptionDialog((Exception)((Object)e));
            }
        }
        if (input == null && this.getBody().isVisible()) {
            this.getBody().setVisible(false);
        }
        this.getBody().layout();
        this.setText(title);
        this.input = input;
    }

    public TableViewer getTableViewer() {
        return ((PropertiesComposite)this.stackLayout.topControl).getTableViewer();
    }

    public EObject getCurrentInput() {
        return this.input;
    }

    public static void setDragNDropObject(EObject dragNDropObject) {
        PropertiesForm.dragNDropObject = dragNDropObject;
    }

    public static EObject getDragNDropObject() {
        return dragNDropObject;
    }

    public static void setDragSource(String dragSource) {
        PropertiesForm.dragSource = dragSource;
    }

    public static String getDragSource() {
        return dragSource;
    }
}

