/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.common.model.workSpaceModel.util;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.common.model.ECPAssociationClassElement;
import org.eclipse.emf.ecp.common.model.ECPMetaModelElementContext;
import org.eclipse.emf.ecp.common.model.ECPModelelementContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AssociationClassHelper {
    private AssociationClassHelper() {
    }

    public static List<EObject> getRelatedAssociationClassToDrop(List<EObject> objectsToDrop, List<EObject> elements, ECPMetaModelElementContext context) {
        LinkedList<EObject> result = new LinkedList<EObject>();
        for (EObject objectToDrop : objectsToDrop) {
            EList features = objectToDrop.eClass().getEAllStructuralFeatures();
            for (EStructuralFeature feature : features) {
                if (!(feature instanceof EReference) || !context.isAssociationClassElement(((EReference)feature).getEReferenceType())) continue;
                Object evaluatedFeatures = objectToDrop.eGet(feature);
                if (evaluatedFeatures instanceof List) {
                    for (Object evaluatedFeature : (List)evaluatedFeatures) {
                        AssociationClassHelper.handleAssociationClass(objectToDrop, objectsToDrop, (EObject)evaluatedFeature, elements, result, context);
                    }
                    continue;
                }
                if (!context.isAssociationClassElement((EObject)evaluatedFeatures)) continue;
                AssociationClassHelper.handleAssociationClass(objectToDrop, objectsToDrop, (EObject)evaluatedFeatures, elements, result, context);
            }
        }
        return result;
    }

    private static void handleAssociationClass(EObject objectToDrop, List<EObject> objectsToDrop, EObject association, List<EObject> elements, List<EObject> result, ECPMetaModelElementContext context) {
        ECPAssociationClassElement ecpAssociation = context.getAssociationClassElement(association);
        if (!result.contains(association) && !elements.contains(association)) {
            Object source = association.eGet((EStructuralFeature)ecpAssociation.getSourceFeature());
            Object target = association.eGet((EStructuralFeature)ecpAssociation.getTargetFeature());
            if (source.equals(objectToDrop)) {
                if (elements.contains(target) || objectsToDrop.contains(target)) {
                    result.add(association);
                }
            } else if (target.equals(objectToDrop) && (elements.contains(source) || objectsToDrop.contains(source))) {
                result.add(association);
            }
        }
    }

    public static List<EObject> getRelatedAssociationClassToDelete(EObject objectToDelete, ECPMetaModelElementContext context) {
        LinkedList<EObject> result = new LinkedList<EObject>();
        EList features = objectToDelete.eClass().getEAllStructuralFeatures();
        for (EStructuralFeature feature : features) {
            Object evaluatedFeatures;
            if (!(feature instanceof EReference) || !context.isAssociationClassElement(((EReference)feature).getEReferenceType()) || (evaluatedFeatures = objectToDelete.eGet(feature)) == null) continue;
            if (evaluatedFeatures instanceof List) {
                for (Object evaluatedFeature : (List)evaluatedFeatures) {
                    if (!context.isAssociationClassElement((EObject)evaluatedFeature)) continue;
                    result.add((EObject)evaluatedFeature);
                }
                continue;
            }
            if (!context.isAssociationClassElement((EObject)evaluatedFeatures)) continue;
            result.add((EObject)evaluatedFeatures);
        }
        return result;
    }

    public static EObject getRelatedModelElement(EObject element, EObject association, ECPModelelementContext context) {
        ECPAssociationClassElement ecpAssociation = context.getMetaModelElementContext().getAssociationClassElement(association);
        Object source = association.eGet((EStructuralFeature)ecpAssociation.getSourceFeature());
        Object target = association.eGet((EStructuralFeature)ecpAssociation.getTargetFeature());
        if (element.equals(source)) {
            return (EObject)target;
        }
        if (element.equals(target)) {
            return (EObject)source;
        }
        return null;
    }

    public static EReference getRelatedEReference(EReference eReference, EObject association, ECPMetaModelElementContext context) {
        ECPAssociationClassElement ecpAssociation = context.getAssociationClassElement(association);
        if (eReference.equals(ecpAssociation.getTargetFeature().getEOpposite())) {
            return ecpAssociation.getSourceFeature().getEOpposite();
        }
        if (eReference.equals(ecpAssociation.getSourceFeature().getEOpposite())) {
            return ecpAssociation.getTargetFeature().getEOpposite();
        }
        return null;
    }

    public static List<EStructuralFeature> getAssociationFeatures(EObject association, ECPMetaModelElementContext context) {
        ECPAssociationClassElement ecpAssociation = context.getAssociationClassElement(association);
        return ecpAssociation.getAssociationFeatures();
    }

    public static void createAssociation(EReference eReference, EObject modelElement, EObject relatedModelElement, ECPMetaModelElementContext context) {
        EClass eClazz = eReference.getEReferenceType();
        EPackage ePackage = eClazz.getEPackage();
        EObject association = ePackage.getEFactoryInstance().create(eClazz);
        ECPAssociationClassElement ecpAssociation = context.getAssociationClassElement(association);
        if (ecpAssociation.getSourceFeature().getEOpposite().equals(eReference)) {
            association.eSet((EStructuralFeature)ecpAssociation.getSourceFeature(), (Object)modelElement);
            association.eSet((EStructuralFeature)ecpAssociation.getTargetFeature(), (Object)relatedModelElement);
        } else {
            association.eSet((EStructuralFeature)ecpAssociation.getSourceFeature(), (Object)relatedModelElement);
            association.eSet((EStructuralFeature)ecpAssociation.getTargetFeature(), (Object)modelElement);
        }
    }

    public static List<EStructuralFeature> getAssociationFeatures(EClass eClazz, EReference source, EReference target) {
        LinkedList<EStructuralFeature> result = new LinkedList<EStructuralFeature>();
        result.addAll((Collection<EStructuralFeature>)eClazz.getEStructuralFeatures());
        result.remove(source);
        result.remove(target);
        return result;
    }
}

