/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.ui.handlers;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.emfstore.client.ui.util.EMFStoreMessageDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractEMFStoreUIController {
    protected Shell shell;
    private ProgressMonitorDialog progressDialog;

    public AbstractEMFStoreUIController(Shell shell) {
        this.setShell(shell);
    }

    public Shell getShell() {
        return this.shell;
    }

    public void setShell(Shell shell) {
        this.shell = shell;
    }

    protected ProgressMonitorDialog openProgress() {
        this.progressDialog = new ProgressMonitorDialog(this.getShell());
        this.progressDialog.setCancelable(true);
        this.progressDialog.open();
        return this.progressDialog;
    }

    protected void closeProgress() {
        if (this.progressDialog != null) {
            this.progressDialog.close();
        }
    }

    protected IProgressMonitor getProgressMonitor() {
        if (this.progressDialog != null) {
            return this.progressDialog.getProgressMonitor();
        }
        return new NullProgressMonitor();
    }

    protected boolean confirmationDialog(String message) {
        MessageDialog dialog = new MessageDialog(null, "Confirmation", null, message, 3, new String[]{"Yes", "No"}, 0);
        return dialog.open() == 0;
    }

    public void handleException(Exception exception) {
        EMFStoreMessageDialog.showExceptionDialog(exception);
        this.closeProgress();
    }
}

