/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.conflicts;

import java.util.List;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.DecisionManager;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.Conflict;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.ConflictContext;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.ConflictDescription;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.ConflictOption;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.util.DecisionUtil;
import org.eclipse.emf.emfstore.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.CompositeOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeConflict
extends Conflict {
    public CompositeConflict(List<AbstractOperation> composite, List<AbstractOperation> other, DecisionManager decisionManager, boolean meCausing) {
        super(composite, other, decisionManager, meCausing, false);
        this.init();
    }

    @Override
    protected ConflictContext initConflictContext() {
        return new ConflictContext(this.getDecisionManager(), this.getLeftOperation(), this.getTheirOperation());
    }

    @Override
    protected ConflictDescription initConflictDescription(ConflictDescription description) {
        String descriptionTxt = "";
        descriptionTxt = this.isLeftMy() ? "A change on the [opposite] from the repository conflicts with your operation \"[compdescription]\"." : "Your change on the [opposite] conflicts with the operation \"[compdescription]\" from the repository.";
        description.setDescription(descriptionTxt);
        description.add("compdescription", this.getLeftOperation());
        description.add("opposite", this.getDecisionManager().getModelElement(this.getRightOperation().getModelElementId()));
        description.setImage("composite.gif");
        return description;
    }

    @Override
    protected void initConflictOptions(List<ConflictOption> options) {
        ConflictOption myOption = new ConflictOption("", ConflictOption.OptionType.MyOperation);
        myOption.addOperations(this.getMyOperations());
        ConflictOption theirOption = new ConflictOption("", ConflictOption.OptionType.TheirOperation);
        theirOption.addOperations(this.getTheirOperations());
        String composite = ((CompositeOperation)this.getLeftOperation()).getCompositeName();
        String other = "Change related to " + DecisionUtil.getClassAndName(this.getDecisionManager().getModelElement(this.getRightOperation().getModelElementId()));
        if (this.isLeftMy()) {
            myOption.setOptionLabel(composite);
            theirOption.setOptionLabel(other);
            theirOption.setDetailProvider("org.eclipse.emf.emfstore.client.ui.merge.widget.otherinvolved");
        } else {
            myOption.setOptionLabel(other);
            myOption.setDetailProvider("org.eclipse.emf.emfstore.client.ui.merge.widget.otherinvolved");
            theirOption.setOptionLabel(composite);
        }
        options.add(myOption);
        options.add(theirOption);
    }
}

