/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.migration;

import org.eclipse.emf.emfstore.common.extensionpoint.ExtensionPoint;
import org.eclipse.emf.emfstore.common.extensionpoint.ExtensionPointException;
import org.eclipse.emf.emfstore.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.migration.EMFStoreMigrationException;
import org.eclipse.emf.emfstore.migration.EMFStoreMigrator;

public final class EMFStoreMigratorUtil {
    private static final String MIGRATOR_CLASS = "migratorClass";
    private static EMFStoreMigrator migrator;

    private EMFStoreMigratorUtil() {
    }

    public static boolean isMigratorAvailable() {
        if (migrator != null) {
            return true;
        }
        try {
            migrator = EMFStoreMigratorUtil.loadMigrator();
        }
        catch (EMFStoreMigrationException e) {
            return false;
        }
        return true;
    }

    public static EMFStoreMigrator getEMFStoreMigrator() throws EMFStoreMigrationException {
        if (migrator != null) {
            return migrator;
        }
        return EMFStoreMigratorUtil.loadMigrator();
    }

    private static EMFStoreMigrator loadMigrator() throws EMFStoreMigrationException {
        ExtensionPoint extensionPoint = new ExtensionPoint("org.eclipse.emf.emfstore.migration.migrator", true);
        if (extensionPoint.size() > 1) {
            ModelUtil.logWarning((String)"Multiple EMFStore Migrators are registered. EMFStore will default to first loadable migrator.");
        }
        try {
            return (EMFStoreMigrator)extensionPoint.getFirst().getClass(MIGRATOR_CLASS, EMFStoreMigrator.class);
        }
        catch (ExtensionPointException e) {
            String message = "Error while instantiating EMFStore Migrator";
            ModelUtil.logWarning((String)message, (Throwable)e);
            throw new EMFStoreMigrationException("No EMFStore migrator registered.");
        }
    }
}

