/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.navigator.wizards;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecp.common.model.ECPMetaModelElementContext;
import org.eclipse.emf.ecp.common.model.ECPWorkspaceManager;
import org.eclipse.emf.ecp.common.model.NoWorkspaceException;
import org.eclipse.emf.ecp.navigator.Activator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelTreeContentProvider
extends AdapterFactoryContentProvider {
    private Set<EPackage> packages = new HashSet<EPackage>();
    private HashSet<EClass> modelElementClasses;
    private Set<EPackage> rootPackages;
    private ECPMetaModelElementContext metaContext;

    public ModelTreeContentProvider(EClass selected) {
        super((AdapterFactory)new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE));
        HashSet eClasses;
        try {
            this.metaContext = ECPWorkspaceManager.getInstance().getWorkSpace().getActiveProject().getMetaModelElementContext();
            eClasses = this.metaContext.getAllModelElementEClasses(false);
        }
        catch (NoWorkspaceException e) {
            Activator.getDefault().logException(e.getMessage(), (Exception)((Object)e));
            eClasses = new HashSet();
        }
        catch (NullPointerException e) {
            Activator.getDefault().logException(e.getMessage(), e);
            eClasses = new HashSet();
        }
        this.modelElementClasses = new HashSet();
        this.rootPackages = new HashSet<EPackage>();
        for (EClass eClass : eClasses) {
            if (this.isNonDomainElement(eClass) || eClass.isAbstract()) continue;
            this.modelElementClasses.add(eClass);
        }
        this.extractRootPackages(this.modelElementClasses);
    }

    private void extractRootPackages(Set<EClass> eClasses) {
        for (EClass eClass : eClasses) {
            EPackage ePackage = eClass.getEPackage();
            this.packages.add(ePackage);
            this.extractAllSuperPackages(ePackage);
        }
    }

    private void extractAllSuperPackages(EPackage ePackage) {
        EPackage eSuperPackage = ePackage.getESuperPackage();
        if (eSuperPackage == null) {
            this.rootPackages.add(ePackage);
            return;
        }
        if (this.packages.contains(eSuperPackage)) {
            return;
        }
        this.packages.add(eSuperPackage);
        this.extractAllSuperPackages(eSuperPackage);
    }

    public Object[] getElements(Object inputElement) {
        if (this.rootPackages.size() == 1) {
            return this.getChildren(this.rootPackages.iterator().next());
        }
        return this.rootPackages.toArray();
    }

    public Object[] getChildren(Object object) {
        if (object instanceof EPackage) {
            Object[] children = super.getChildren(object);
            ArrayList<Object> ret = new ArrayList<Object>();
            int i = 0;
            while (i < children.length) {
                Object child = children[i];
                if (child instanceof EPackage && this.packages.contains(child)) {
                    ret.add(child);
                }
                if (child instanceof EClass && this.modelElementClasses.contains(child)) {
                    ret.add(child);
                }
                ++i;
            }
            return ret.toArray();
        }
        return null;
    }

    private boolean isNonDomainElement(EClass eClass) {
        return this.metaContext.isNonDomainElement(eClass);
    }

    public boolean hasChildren(Object object) {
        if (object instanceof EClass) {
            return false;
        }
        Object[] children = this.getChildren(object);
        if (children != null) {
            return children.length > 0;
        }
        return false;
    }
}

