/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.server.core;

import java.util.List;
import org.eclipse.emf.emfstore.common.model.EMFStoreProperty;
import org.eclipse.emf.emfstore.common.model.Project;
import org.eclipse.emf.emfstore.server.EmfStore;
import org.eclipse.emf.emfstore.server.accesscontrol.AuthorizationControl;
import org.eclipse.emf.emfstore.server.core.AbstractEmfstoreInterface;
import org.eclipse.emf.emfstore.server.core.subinterfaces.EMFStorePropertiesSubInterfaceImpl;
import org.eclipse.emf.emfstore.server.core.subinterfaces.FileTransferSubInterfaceImpl;
import org.eclipse.emf.emfstore.server.core.subinterfaces.HistorySubInterfaceImpl;
import org.eclipse.emf.emfstore.server.core.subinterfaces.ProjectPropertiesSubInterfaceImpl;
import org.eclipse.emf.emfstore.server.core.subinterfaces.ProjectSubInterfaceImpl;
import org.eclipse.emf.emfstore.server.core.subinterfaces.UserSubInterfaceImpl;
import org.eclipse.emf.emfstore.server.core.subinterfaces.VersionSubInterfaceImpl;
import org.eclipse.emf.emfstore.server.exceptions.EmfStoreException;
import org.eclipse.emf.emfstore.server.exceptions.FatalEmfStoreException;
import org.eclipse.emf.emfstore.server.exceptions.InvalidVersionSpecException;
import org.eclipse.emf.emfstore.server.filetransfer.FileChunk;
import org.eclipse.emf.emfstore.server.filetransfer.FileTransferInformation;
import org.eclipse.emf.emfstore.server.model.ProjectHistory;
import org.eclipse.emf.emfstore.server.model.ProjectId;
import org.eclipse.emf.emfstore.server.model.ProjectInfo;
import org.eclipse.emf.emfstore.server.model.ServerSpace;
import org.eclipse.emf.emfstore.server.model.SessionId;
import org.eclipse.emf.emfstore.server.model.accesscontrol.ACOrgUnitId;
import org.eclipse.emf.emfstore.server.model.accesscontrol.ACUser;
import org.eclipse.emf.emfstore.server.model.accesscontrol.OrgUnitProperty;
import org.eclipse.emf.emfstore.server.model.versioning.ChangePackage;
import org.eclipse.emf.emfstore.server.model.versioning.HistoryInfo;
import org.eclipse.emf.emfstore.server.model.versioning.HistoryQuery;
import org.eclipse.emf.emfstore.server.model.versioning.LogMessage;
import org.eclipse.emf.emfstore.server.model.versioning.PrimaryVersionSpec;
import org.eclipse.emf.emfstore.server.model.versioning.TagVersionSpec;
import org.eclipse.emf.emfstore.server.model.versioning.VersionSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmfStoreImpl
extends AbstractEmfstoreInterface
implements EmfStore {
    public EmfStoreImpl(ServerSpace serverSpace, AuthorizationControl authorizationControl) throws FatalEmfStoreException {
        super(serverSpace, authorizationControl);
    }

    @Override
    protected void initSubInterfaces() throws FatalEmfStoreException {
        this.addSubInterface(new HistorySubInterfaceImpl(this));
        this.addSubInterface(new ProjectSubInterfaceImpl(this));
        this.addSubInterface(new UserSubInterfaceImpl(this));
        this.addSubInterface(new VersionSubInterfaceImpl(this));
        this.addSubInterface(new FileTransferSubInterfaceImpl(this));
        this.addSubInterface(new ProjectPropertiesSubInterfaceImpl(this));
        this.addSubInterface(new EMFStorePropertiesSubInterfaceImpl(this));
    }

    @Override
    public List<HistoryInfo> getHistoryInfo(SessionId sessionId, ProjectId projectId, HistoryQuery historyQuery) throws EmfStoreException {
        this.sanityCheckObjects(sessionId, projectId, historyQuery);
        this.checkReadAccess(sessionId, projectId, null);
        return this.getSubInterface(HistorySubInterfaceImpl.class).getHistoryInfo(projectId, historyQuery);
    }

    @Override
    public void addTag(SessionId sessionId, ProjectId projectId, PrimaryVersionSpec versionSpec, TagVersionSpec tag) throws EmfStoreException {
        this.sanityCheckObjects(sessionId, projectId, versionSpec, tag);
        this.checkProjectAdminAccess(sessionId, projectId);
        this.getSubInterface(HistorySubInterfaceImpl.class).addTag(projectId, versionSpec, tag);
    }

    @Override
    public void removeTag(SessionId sessionId, ProjectId projectId, PrimaryVersionSpec versionSpec, TagVersionSpec tag) throws EmfStoreException {
        this.sanityCheckObjects(sessionId, projectId, versionSpec, tag);
        this.checkProjectAdminAccess(sessionId, projectId);
        this.getSubInterface(HistorySubInterfaceImpl.class).removeTag(projectId, versionSpec, tag);
    }

    @Override
    public ProjectInfo createEmptyProject(SessionId sessionId, String name, String description, LogMessage logMessage) throws EmfStoreException {
        this.sanityCheckObjects(sessionId, name, description, logMessage);
        this.checkServerAdminAccess(sessionId);
        return this.getSubInterface(ProjectSubInterfaceImpl.class).createProject(name, description, logMessage);
    }

    @Override
    public ProjectInfo createProject(SessionId sessionId, String name, String description, LogMessage logMessage, Project project) throws EmfStoreException {
        this.sanityCheckObjects(sessionId, name, description, logMessage, project);
        this.checkServerAdminAccess(sessionId);
        return this.getSubInterface(ProjectSubInterfaceImpl.class).createProject(name, description, logMessage, project);
    }

    @Override
    public void deleteProject(SessionId sessionId, ProjectId projectId, boolean deleteFiles) throws EmfStoreException {
        this.sanityCheckObjects(sessionId, projectId);
        this.checkServerAdminAccess(sessionId);
        this.getSubInterface(ProjectSubInterfaceImpl.class).deleteProject(projectId, deleteFiles);
    }

    @Override
    public PrimaryVersionSpec createVersion(SessionId sessionId, ProjectId projectId, PrimaryVersionSpec baseVersionSpec, ChangePackage changePackage, LogMessage logMessage) throws EmfStoreException, InvalidVersionSpecException {
        this.sanityCheckObjects(sessionId, projectId, baseVersionSpec, changePackage, logMessage);
        this.checkWriteAccess(sessionId, projectId, null);
        ACUser user = this.getAuthorizationControl().resolveUser(sessionId);
        PrimaryVersionSpec newVersion = this.getSubInterface(VersionSubInterfaceImpl.class).createVersion(projectId, baseVersionSpec, changePackage, logMessage, user);
        return newVersion;
    }

    @Override
    public List<ChangePackage> getChanges(SessionId sessionId, ProjectId projectId, VersionSpec source, VersionSpec target) throws EmfStoreException {
        this.sanityCheckObjects(sessionId, projectId, source, target);
        this.checkReadAccess(sessionId, projectId, null);
        return this.getSubInterface(VersionSubInterfaceImpl.class).getChanges(projectId, source, target);
    }

    @Override
    public PrimaryVersionSpec resolveVersionSpec(SessionId sessionId, ProjectId projectId, VersionSpec versionSpec) throws EmfStoreException {
        this.sanityCheckObjects(sessionId, projectId, versionSpec);
        this.checkReadAccess(sessionId, projectId, null);
        return this.getSubInterface(VersionSubInterfaceImpl.class).resolveVersionSpec(projectId, versionSpec);
    }

    @Override
    public Project getProject(SessionId sessionId, ProjectId projectId, VersionSpec versionSpec) throws EmfStoreException {
        this.sanityCheckObjects(sessionId, projectId, versionSpec);
        this.checkReadAccess(sessionId, projectId, null);
        return this.getSubInterface(ProjectSubInterfaceImpl.class).getProject(projectId, versionSpec);
    }

    @Override
    public List<ProjectInfo> getProjectList(SessionId sessionId) throws EmfStoreException {
        this.sanityCheckObjects(sessionId);
        return this.getSubInterface(ProjectSubInterfaceImpl.class).getProjectList(sessionId);
    }

    @Override
    public ProjectId importProjectHistoryToServer(SessionId sessionId, ProjectHistory projectHistory) throws EmfStoreException {
        this.sanityCheckObjects(sessionId, projectHistory);
        this.checkServerAdminAccess(sessionId);
        return this.getSubInterface(ProjectSubInterfaceImpl.class).importProjectHistoryToServer(projectHistory);
    }

    @Override
    public ProjectHistory exportProjectHistoryFromServer(SessionId sessionId, ProjectId projectId) throws EmfStoreException {
        this.sanityCheckObjects(sessionId, projectId);
        this.checkServerAdminAccess(sessionId);
        return this.getSubInterface(ProjectSubInterfaceImpl.class).exportProjectHistoryFromServer(projectId);
    }

    @Override
    public ACUser resolveUser(SessionId sessionId, ACOrgUnitId id) throws EmfStoreException {
        this.sanityCheckObjects(sessionId);
        return this.getSubInterface(UserSubInterfaceImpl.class).resolveUser(sessionId, id);
    }

    @Override
    public FileChunk downloadFileChunk(SessionId sessionId, ProjectId projectId, FileTransferInformation fileInformation) throws EmfStoreException {
        this.sanityCheckObjects(sessionId, projectId, fileInformation);
        this.checkReadAccess(sessionId, projectId, null);
        return this.getSubInterface(FileTransferSubInterfaceImpl.class).readChunk(projectId, fileInformation);
    }

    @Override
    public FileTransferInformation uploadFileChunk(SessionId sessionId, ProjectId projectId, FileChunk fileChunk) throws EmfStoreException {
        this.sanityCheckObjects(sessionId, projectId, fileChunk, fileChunk.getFileInformation());
        this.checkWriteAccess(sessionId, projectId, null);
        return this.getSubInterface(FileTransferSubInterfaceImpl.class).writeChunk(fileChunk, projectId);
    }

    @Override
    public void transmitProperty(SessionId sessionId, OrgUnitProperty changedProperty, ACUser user, ProjectId projectId) throws EmfStoreException {
        this.sanityCheckObjects(projectId, user, changedProperty);
        this.checkWriteAccess(sessionId, projectId, null);
        this.getSubInterface(ProjectPropertiesSubInterfaceImpl.class).setProperty(changedProperty, user, projectId);
    }

    @Override
    public List<EMFStoreProperty> getEMFProperties(SessionId sessionId, ProjectId projectId) throws EmfStoreException {
        this.sanityCheckObjects(sessionId, projectId);
        this.checkReadAccess(sessionId, projectId, null);
        return this.getSubInterface(EMFStorePropertiesSubInterfaceImpl.class).getProperties(projectId);
    }

    @Override
    public List<EMFStoreProperty> setEMFProperties(SessionId sessionId, List<EMFStoreProperty> properties, ProjectId projectId) throws EmfStoreException {
        this.sanityCheckObjects(projectId, properties);
        this.checkWriteAccess(sessionId, projectId, null);
        EMFStorePropertiesSubInterfaceImpl propertiesInterface = this.getSubInterface(EMFStorePropertiesSubInterfaceImpl.class);
        return propertiesInterface.setProperties(properties, projectId);
    }
}

