/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfatic.ui.editor;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfatic.core.generator.ecore.EcoreGenerator;
import org.eclipse.emf.emfatic.core.generics.util.OneToManyMap;
import org.eclipse.emf.emfatic.core.generics.util.OneToOneMap;
import org.eclipse.emf.emfatic.core.lang.gen.ast.BoundExceptWildcard;
import org.eclipse.emf.emfatic.core.lang.gen.ast.ClassDecl;
import org.eclipse.emf.emfatic.core.lang.gen.ast.CompUnit;
import org.eclipse.emf.emfatic.core.lang.gen.ast.EmfaticASTNode;
import org.eclipse.emf.emfatic.core.lang.gen.ast.Reference;
import org.eclipse.emf.emfatic.core.lang.gen.ast.TypeWithMulti;
import org.eclipse.emf.emfatic.core.lang.gen.ast.Wildcard;
import org.eclipse.emf.emfatic.ui.EmfaticUIPlugin;
import org.eclipse.emf.emfatic.ui.editor.EmfaticEditorMessages;
import org.eclipse.emf.emfatic.ui.editor.EmfaticEditorSelectionListener;
import org.eclipse.emf.emfatic.ui.editor.EmfaticKeyListener;
import org.eclipse.emf.emfatic.ui.editor.EmfaticOutlineConfiguration;
import org.eclipse.emf.emfatic.ui.editor.EmfaticSourceViewerConfiguration;
import org.eclipse.emf.emfatic.ui.editor.HighlightingManager;
import org.eclipse.emf.emfatic.ui.editor.ThemeChangeListener;
import org.eclipse.emf.emfatic.ui.hyperlinks.EmfaticHyperlinkDetector;
import org.eclipse.emf.emfatic.ui.outline.EmfaticContentOutlinePage;
import org.eclipse.emf.emfatic.ui.partition.EmfaticDocumentProvider;
import org.eclipse.emf.emfatic.ui.redsquiggles.EmfaticCSTChangeListener;
import org.eclipse.emf.emfatic.ui.views.TypesView;
import org.eclipse.gymnast.runtime.core.ast.ASTNode;
import org.eclipse.gymnast.runtime.core.outline.OutlineNode;
import org.eclipse.gymnast.runtime.ui.editor.LDTEditor;
import org.eclipse.gymnast.runtime.ui.editor.LDTSourceViewerConfiguration;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ISourceViewerExtension2;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class EmfaticEditor
extends LDTEditor
implements IShowInTargetList,
IShowInSource {
    private EmfaticEditorSelectionListener selectionListener = new EmfaticEditorSelectionListener(this);
    private EmfaticContentOutlinePage _emfaticContentOutlinePage;
    private EmfaticKeyListener _keyListener = null;
    private OutlineNode[] lastShownOutlineNodes = new OutlineNode[0];
    private IViewReference _typesViewReference = null;
    private HighlightingManager highlightingManager;
    private ProjectionSupport projectionSupport;
    private ProjectionAnnotationModel annotationModel;
    private Annotation[] oldAnnotations;

    public EmfaticEditor() {
        this.addParseTreeChangedListener(new EmfaticCSTChangeListener(this));
        this.setDocumentProvider((IDocumentProvider)new EmfaticDocumentProvider());
        this.highlightingManager = new HighlightingManager();
        PlatformUI.getWorkbench().getThemeManager().addPropertyChangeListener((IPropertyChangeListener)new ThemeChangeListener(){

            @Override
            public void themeChange() {
                EmfaticEditor.this.highlightingManager.initialiseDefaultColors();
                EmfaticEditor.this.refreshText();
            }
        });
        this.highlightingManager.getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (EmfaticEditor.this.highlightingManager.isColorPreference(event.getProperty())) {
                    EmfaticEditor.this.refreshText();
                }
            }
        });
    }

    public void refreshText() {
        ISourceViewer viewer = this.getSourceViewer();
        if (!(viewer instanceof ISourceViewerExtension2)) {
            return;
        }
        ((ISourceViewerExtension2)viewer).unconfigure();
        this.initializeEditor();
        viewer.configure(this.getSourceViewerConfiguration());
    }

    protected LDTSourceViewerConfiguration createSourceViewerConfiguration() {
        return new EmfaticSourceViewerConfiguration(this);
    }

    public void doSave(IProgressMonitor progressMonitor) {
        super.doSave(progressMonitor);
        if (EmfaticUIPlugin.getDefault().getPreferenceStore().getBoolean("autoGenerateEcore")) {
            this.generateEcoreFile();
        }
    }

    private void generateEcoreFile() {
        IEditorInput input = this.getEditorInput();
        if (input instanceof IFileEditorInput) {
            final IFile file = ((IFileEditorInput)input).getFile();
            Job job = new Job("Generating Ecore Model for " + file.getName()){

                protected IStatus run(IProgressMonitor monitor) {
                    new EcoreGenerator().generate(file, monitor);
                    return Status.OK_STATUS;
                }
            };
            job.setRule((ISchedulingRule)file.getParent());
            job.schedule();
        }
    }

    protected EmfaticOutlineConfiguration createOutlineConfiguration() {
        return new EmfaticOutlineConfiguration(this);
    }

    public void updateFoldingStructure(List<Position> positions) {
        this.initFoldingSupport();
        Annotation[] annotations = new Annotation[positions.size()];
        HashMap<ProjectionAnnotation, Position> newAnnotations = new HashMap<ProjectionAnnotation, Position>();
        int i = 0;
        while (i < positions.size()) {
            ProjectionAnnotation annotation = new ProjectionAnnotation();
            newAnnotations.put(annotation, positions.get(i));
            annotations[i] = annotation;
            ++i;
        }
        this.annotationModel.modifyAnnotations(this.oldAnnotations, newAnnotations, null);
        this.oldAnnotations = annotations;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.initFoldingSupport();
        this.selectionListener.install(this.getSelectionProvider());
        this._keyListener = new EmfaticKeyListener(this);
        this.getSourceViewer().getTextWidget().addKeyListener((KeyListener)this._keyListener);
    }

    private void initFoldingSupport() {
        if (this.annotationModel == null) {
            ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
            this.projectionSupport = new ProjectionSupport(viewer, this.getAnnotationAccess(), this.getSharedColors());
            this.projectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.error");
            this.projectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.warning");
            this.projectionSupport.install();
            viewer.doOperation(19);
            this.annotationModel = viewer.getProjectionAnnotationModel();
        }
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        this.fAnnotationAccess = this.getAnnotationAccess();
        this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        ProjectionViewer viewer = new ProjectionViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        return viewer;
    }

    public EmfaticASTNode getClosestEnclosingASTNodeAt(int offset, Class<?> filter) {
        return this.getClosestEnclosingASTNodeAt(offset, 0, filter);
    }

    public EmfaticASTNode getClosestEnclosingASTNodeAt(int offset, int length, Class<?> filter) {
        EmfaticASTNode node = this.getClosestEnclosingASTNodeAtWithin(new HashSet<ASTNode>(), this.getParseRoot(), offset, length, filter);
        return node;
    }

    private EmfaticASTNode getClosestEnclosingASTNodeAtWithin(Set<ASTNode> seenNodes, ASTNode within, int offset, int length, Class<?> filter) {
        if (within == null) {
            return null;
        }
        if (seenNodes.contains(within)) {
            return null;
        }
        seenNodes.add(within);
        ASTNode node = within.getNodeAt(offset, 0);
        int i = offset + 1;
        while (node == null && i < offset + length) {
            node = this.getParseRoot().getNodeAt(i, 0);
            ++i;
        }
        if (node != null) {
            if (node.getChildren().length > 0) {
                ASTNode[] aSTNodeArray = node.getChildren();
                int n = aSTNodeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ASTNode child = aSTNodeArray[n2];
                    EmfaticASTNode innerNode = this.getClosestEnclosingASTNodeAtWithin(seenNodes, child, offset, length, filter);
                    if (innerNode != null) {
                        node = innerNode;
                        break;
                    }
                    ++n2;
                }
            }
            while (!filter.isInstance(node) && node.getParent() != null) {
                node = node.getParent();
            }
        }
        if (filter.isInstance(node)) {
            return (EmfaticASTNode)node;
        }
        return null;
    }

    public void dispose() {
        if (this.selectionListener != null) {
            this.selectionListener.uninstall(this.getSelectionProvider());
            this.selectionListener = null;
        }
        super.dispose();
    }

    public OneToOneMap<ASTNode, EObject> getCstDecl2EcoreAST() {
        CompUnit compUnit = (CompUnit)this.getParseRoot();
        if (compUnit != null) {
            return compUnit.getCstDecl2EcoreAST();
        }
        return null;
    }

    public OneToManyMap<EObject, ASTNode> getEcoreDecl2CstUse() {
        CompUnit compUnit = (CompUnit)this.getParseRoot();
        if (compUnit != null) {
            return compUnit.getEcoreDecl2CstUse();
        }
        return null;
    }

    public IDocument getDocument() {
        IDocument doc = null;
        if (this.getDocumentProvider() == null) {
            return doc;
        }
        doc = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        return doc;
    }

    public void openTarget(EmfaticASTNode linkTarget) {
        this.setSelection(linkTarget, true);
    }

    public void setSelection(EmfaticASTNode reference, boolean moveCursor) {
        ISourceViewer sourceViewer;
        if (reference == null) {
            if (moveCursor) {
                this.resetHighlightRange();
                this.markInNavigationHistory();
            }
            return;
        }
        if (moveCursor) {
            this.markInNavigationHistory();
        }
        if ((sourceViewer = this.getSourceViewer()) == null) {
            return;
        }
        StyledText textWidget = sourceViewer.getTextWidget();
        if (textWidget == null) {
            return;
        }
        try {
            int offset = reference.getRangeStart();
            if (offset < 0) {
                return;
            }
            int length = reference.getRangeLength();
            textWidget.setRedraw(false);
            if (length > 0) {
                this.setHighlightRange(offset, length, moveCursor);
            }
            if (!moveCursor) {
                return;
            }
            try {
                if (offset > -1 && length > 0) {
                    sourceViewer.revealRange(offset, length);
                    sourceViewer.setSelectedRange(offset, length);
                    this.markInNavigationHistory();
                }
            }
            catch (IllegalArgumentException x) {
                x.printStackTrace();
            }
        }
        finally {
            textWidget.setRedraw(true);
        }
    }

    public void setContentOutlinePage(EmfaticContentOutlinePage emfaticContentOutlinePage) {
        this._emfaticContentOutlinePage = emfaticContentOutlinePage;
    }

    protected EmfaticContentOutlinePage getContentOutlinePage() {
        return this._emfaticContentOutlinePage;
    }

    public EObject getEcoreDeclAtCursor() {
        ISelection selection = this.getSelectionProvider().getSelection();
        if (selection instanceof ITextSelection) {
            int length;
            ITextSelection ts = (ITextSelection)selection;
            int offset = ts.getOffset();
            ReferedEcoreDecl red = this.getReferedEcoreDecl(offset, length = ts.getLength());
            if (red == null || red.ecoreDecl == null) {
                return null;
            }
            EObject ecoreDecl = red.ecoreDecl;
            return ecoreDecl;
        }
        return null;
    }

    public EObject gotoDeclaration() {
        EObject ecoreDecl = this.getEcoreDeclAtCursor();
        if (ecoreDecl == null) {
            return null;
        }
        EmfaticASTNode landingPlace = EmfaticHyperlinkDetector.getLandingPlace(ecoreDecl, this);
        this.setSelection(landingPlace, true);
        return ecoreDecl;
    }

    public ReferedEcoreDecl getReferedEcoreDecl(int offset, int length) {
        EmfaticASTNode node = this.getClosestEnclosingASTNodeAt(offset, length, Wildcard.class);
        if (node != null) {
            node = ((Wildcard)node).getBoundExceptWildcard();
        }
        if (node == null && (node = this.getClosestEnclosingASTNodeAt(offset, length, BoundExceptWildcard.class)) == null) {
            node = this.getClosestEnclosingASTNodeAt(offset, length, TypeWithMulti.class);
            if (node == null) {
                node = this.getClosestEnclosingASTNodeAt(offset, length, Reference.class);
                if (node == null) {
                    return null;
                }
                node = ((Reference)node).getOppositeName();
            } else {
                node = ((TypeWithMulti)node).getName();
            }
        }
        if (node instanceof BoundExceptWildcard) {
            node = ((BoundExceptWildcard)node).getRawTNameOrTVarOrParamzedTName();
        }
        EObject ecoreDecl = (EObject)this.getEcoreDecl2CstUse().getInv((Object)node);
        ReferedEcoreDecl res = new ReferedEcoreDecl();
        res.ecoreDecl = ecoreDecl;
        res.node = node;
        return res;
    }

    protected void createActions() {
        super.createActions();
        ResourceBundle bundle = EmfaticEditorMessages.getResourceBundle();
        ContentAssistAction action = new ContentAssistAction(bundle, "ContentAssistProposal.", (ITextEditor)this);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)action);
        this.markAsStateDependentAction("ContentAssistProposal", true);
    }

    public OutlineNode[] getOutlineElements() {
        OutlineNode[] candidateOutlineNodes = super.getOutlineElements();
        if (candidateOutlineNodes != null && candidateOutlineNodes.length > 0) {
            this.lastShownOutlineNodes = candidateOutlineNodes;
        }
        return this.lastShownOutlineNodes;
    }

    public String[] getShowInTargetIds() {
        EObject ecoreDecl = this.getEcoreDeclAtCursor();
        String[] res = null;
        res = ecoreDecl == null ? ((ecoreDecl = this.getEcoreDeclAtCursor2()) == null ? new String[]{} : new String[]{"org.eclipse.emf.emfatic.ui.views.TypesView"}) : new String[]{"org.eclipse.emf.emfatic.ui.views.TypesView"};
        return res;
    }

    private EObject getEcoreDeclAtCursor2() {
        ISelection selection = this.getSelectionProvider().getSelection();
        if (selection instanceof ITextSelection) {
            ITextSelection ts = (ITextSelection)selection;
            int offset = ts.getOffset();
            EmfaticASTNode node = this.getClosestEnclosingASTNodeAt(offset, ClassDecl.class);
            if (node == null) {
                return null;
            }
            EObject ecoreDecl = (EObject)this.getCstDecl2EcoreAST().get((Object)node);
            return ecoreDecl;
        }
        return null;
    }

    public ShowInContext getShowInContext() {
        if (this.getEditorInput() instanceof FileEditorInput) {
            FileEditorInput fei = (FileEditorInput)this.getEditorInput();
            return new ShowInContext((Object)fei.getFile(), this.getSelectionProvider().getSelection());
        }
        return new ShowInContext((Object)this.getEditorInput(), this.getSelectionProvider().getSelection());
    }

    public void showInTypeHierarchy(EClass openedDecl) {
        if (!(openedDecl instanceof EClass)) {
            return;
        }
        TypesView tv = this.getTypesView();
        if (tv == null) {
            return;
        }
        WeakReference<EClass> wrC = new WeakReference<EClass>(openedDecl);
        tv.setInput(wrC, true);
    }

    public TypesView getTypesView() {
        TypesView tv;
        TypesView tv2;
        if (this._typesViewReference != null && (tv2 = (TypesView)this._typesViewReference.getView(false)) != null) {
            return tv2;
        }
        IWorkbenchPage wp = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IViewReference _typesViewReference = wp.findViewReference("org.eclipse.emf.emfatic.ui.views.TypesView");
        if (_typesViewReference != null && (tv = (TypesView)_typesViewReference.getView(true)) != null) {
            return tv;
        }
        try {
            tv = wp.showView("org.eclipse.emf.emfatic.ui.views.TypesView");
            return tv;
        }
        catch (PartInitException e) {
            e.printStackTrace();
            return null;
        }
    }

    public class ReferedEcoreDecl {
        public EObject ecoreDecl;
        public EmfaticASTNode node;
    }
}

