/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.fxml;

import java.io.IOException;
import java.net.URL;
import javafx.fxml.FXMLLoader;
import javafx.fxml.JavaFXBuilderFactory;
import javafx.util.BuilderFactory;
import org.eclipse.fx.core.fxml.FXMLDocument;
import org.eclipse.jdt.annotation.NonNull;

public class ExtendedFXMLLoader {
    private FXMLDocument<?> lastDocument;
    private FXMLLoader lastLoader;

    @NonNull
    public <T> T load(ClassLoader cl, String path) throws IOException {
        this.lastDocument = null;
        this.lastLoader = null;
        try {
            FXMLDocument d;
            String classname = path.substring(0, path.lastIndexOf(46)).replace('/', '.');
            Class<?> clazz = cl.loadClass(classname);
            this.lastDocument = d = (FXMLDocument)clazz.newInstance();
            URL url = cl.getResource(path);
            if (url != null) {
                return d.load(url, null);
            }
            throw new IOException("Unable to get url for path '" + path + "'");
        }
        catch (ClassNotFoundException classNotFoundException) {
            FXMLLoader loader = new FXMLLoader();
            loader.setBuilderFactory((BuilderFactory)new JavaFXBuilderFactory());
            loader.setLocation(cl.getResource(path));
            this.lastLoader = loader;
            Object rv = loader.load(cl.getResourceAsStream(path));
            if (rv != null) {
                return (T)rv;
            }
            throw new IOException("Unable to load fxml document from '" + path + "'");
        }
        catch (InstantiationException e) {
            throw new IOException(e);
        }
        catch (IllegalAccessException e) {
            throw new IOException(e);
        }
    }

    public <C> C getController() {
        if (this.lastDocument == null && this.lastLoader == null) {
            return null;
        }
        if (this.lastDocument != null) {
            return (C)this.lastDocument.getController();
        }
        return (C)this.lastLoader.getController();
    }
}

