/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.osgi.util.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.fx.core.Memento;
import org.eclipse.fx.core.MementoStore;
import org.eclipse.fx.core.ObjectSerializer;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.prefs.BackingStoreException;

@Component
public class MementoStoreImpl
implements MementoStore {
    List<ObjectSerializer> serializers = new ArrayList<ObjectSerializer>();
    IPreferencesService preferencesService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.MULTIPLE)
    public void registerObjectSerializer(ObjectSerializer serializer) {
        List<ObjectSerializer> list = this.serializers;
        synchronized (list) {
            this.serializers.add(serializer);
        }
    }

    @Reference
    public void setPreferenceService(IPreferencesService preferenceService) {
        this.preferencesService = preferenceService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterObjectSerializer(ObjectSerializer serializer) {
        List<ObjectSerializer> list = this.serializers;
        synchronized (list) {
            this.serializers.remove(serializer);
        }
    }

    public @NonNull Memento getMemento(String path) {
        return new MementoImpl(this.preferencesService, path);
    }

    public void remove(String path) {
        try {
            InstanceScope.INSTANCE.getNode(path).removeNode();
        }
        catch (BackingStoreException e) {
            throw new RuntimeException(e);
        }
    }

    class MementoImpl
    implements Memento {
        private final IPreferencesService preferencesService;
        private final String path;
        private final IEclipsePreferences node;
        private final IEclipsePreferences defaultNode;
        private static final String TYPE_PREFIX = "__type_";

        private void flush() {
            try {
                this.node.flush();
            }
            catch (BackingStoreException e) {
                throw new RuntimeException(e);
            }
        }

        public MementoImpl(IPreferencesService preferencesService, String path) {
            this.preferencesService = preferencesService;
            this.path = path;
            this.node = InstanceScope.INSTANCE.getNode(path);
            this.defaultNode = DefaultScope.INSTANCE.getNode(path);
        }

        public void put(@NonNull String key, String value) {
            this.node.put(key, value);
            this.flush();
        }

        public void put(@NonNull String key, boolean value) {
            this.node.putBoolean(key, value);
            this.flush();
        }

        public void put(@NonNull String key, int value) {
            this.node.putInt(key, value);
            this.flush();
        }

        public void put(@NonNull String key, double value) {
            this.node.putDouble(key, value);
            this.flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(@NonNull String key, Object value, String serializer) {
            if (value == null) {
                this.node.put(key, null);
                this.node.put(TYPE_PREFIX + key, "serialized:" + serializer);
            }
            List<ObjectSerializer> list = MementoStoreImpl.this.serializers;
            synchronized (list) {
                for (ObjectSerializer s : MementoStoreImpl.this.serializers) {
                    if (!s.getId().equals(serializer)) continue;
                    this.node.put(key, s.serialize(value));
                    this.node.put(TYPE_PREFIX + key, "serialized:" + serializer);
                    this.flush();
                    return;
                }
            }
            throw new IllegalArgumentException("The serializer '" + serializer + "' is not known");
        }

        public void remove(@NonNull String key) {
            this.node.remove(key);
            this.flush();
        }

        public boolean exists(@NonNull String key) {
            try {
                return Arrays.asList(this.node.keys()).contains(key);
            }
            catch (BackingStoreException e) {
                throw new RuntimeException(e);
            }
        }

        public @Nullable String get(@NonNull String key, @Nullable String defaultValue) {
            return this.preferencesService.getString(this.path, key, defaultValue, null);
        }

        public boolean get(@NonNull String key, boolean defaultValue) {
            return this.preferencesService.getBoolean(this.path, key, defaultValue, null);
        }

        public int get(@NonNull String key, int defaultValue) {
            return this.preferencesService.getInt(this.path, key, defaultValue, null);
        }

        public double get(@NonNull String key, double defaultValue) {
            return this.preferencesService.getDouble(this.path, key, defaultValue, null);
        }

        public <O> O getDefault(String key, Class<O> clazz) {
            List<ObjectSerializer> list = MementoStoreImpl.this.serializers;
            synchronized (list) {
                String value;
                String serializer;
                block7: {
                    block6: {
                        serializer = this.defaultNode.get(TYPE_PREFIX + key, null);
                        if (serializer != null) break block6;
                        return null;
                    }
                    value = this.defaultNode.get(key, null);
                    if (value != null) break block7;
                    return null;
                }
                serializer = serializer.substring("serialized:".length());
                for (ObjectSerializer s : MementoStoreImpl.this.serializers) {
                    if (!s.getId().equals(serializer)) continue;
                    return (O)s.deserialize(clazz, value);
                }
                throw new IllegalArgumentException("The serializer '" + serializer + "' is not known");
            }
        }

        public boolean getDefaultBoolean(String key) {
            return this.defaultNode.getBoolean(key, false);
        }

        public int getDefaultInteger(String key) {
            return this.defaultNode.getInt(key, 0);
        }

        public double getDefaultDouble(String key) {
            return this.defaultNode.getDouble(key, 0.0);
        }

        public String getDefaultString(String key) {
            return this.defaultNode.get(key, "");
        }

        public <O> @Nullable O get(String key, Class<O> clazz, @Nullable O defaultValue) {
            List<ObjectSerializer> list = MementoStoreImpl.this.serializers;
            synchronized (list) {
                String serializer = this.preferencesService.getString(this.path, TYPE_PREFIX + key, null, null);
                if (serializer == null) {
                    return defaultValue;
                }
                String value = this.preferencesService.getString(this.path, key, null, null);
                if (value == null) {
                    return defaultValue;
                }
                serializer = serializer.substring("serialized:".length());
                for (ObjectSerializer s : MementoStoreImpl.this.serializers) {
                    if (!s.getId().equals(serializer)) continue;
                    return (O)s.deserialize(clazz, value);
                }
                throw new IllegalArgumentException("The serializer '" + serializer + "' is not known");
            }
        }
    }
}

