/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource.persistence;

import com.google.inject.Inject;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.linking.lazy.LazyLinkingResource;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.persistence.IResourceStorageFacade;
import org.eclipse.xtext.resource.persistence.PortableURIs;
import org.eclipse.xtext.resource.persistence.ResourceStorageLoadable;
import org.eclipse.xtext.util.internal.Stopwatches;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Pure;

public class StorageAwareResource
extends LazyLinkingResource {
    public static final String UNRESOLVABLE_FRAGMENT = "UNRESOLVABLE";
    private static final Logger LOG = Logger.getLogger(StorageAwareResource.class);
    @Inject(optional=true)
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private IResourceStorageFacade resourceStorageFacade;
    @Inject
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private PortableURIs portableURIs;
    @Accessors
    private boolean isLoadedFromStorage = false;
    @Accessors
    private IResourceDescription resourceDescription = null;

    public void load(Map<?, ?> options) throws IOException {
        if (!this.isLoaded && !this.isLoading && this.resourceStorageFacade != null && this.resourceStorageFacade.shouldLoadFromStorage(this)) {
            boolean _isDebugEnabled = LOG.isDebugEnabled();
            if (_isDebugEnabled) {
                URI _uRI = this.getURI();
                String _plus = "Loading " + _uRI;
                String _plus_1 = _plus + " from storage.";
                LOG.debug((Object)_plus_1);
            }
            try {
                ResourceStorageLoadable in = this.resourceStorageFacade.getOrCreateResourceStorageLoadable(this);
                this.loadFromStorage(in);
                return;
            }
            catch (Throwable _t) {
                if (_t instanceof IOException) {
                    IOException e = (IOException)_t;
                    this.contents.clear();
                    this.eAdapters.clear();
                    this.unload();
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        super.load(options);
    }

    public void loadFromStorage(ResourceStorageLoadable storageInputStream) throws IOException {
        if (storageInputStream == null) {
            throw new NullPointerException("storageInputStream");
        }
        Stopwatches.StoppedTask task = Stopwatches.forTask((String)"Loading from storage");
        task.start();
        this.isLoading = true;
        this.isLoadedFromStorage = true;
        try {
            storageInputStream.loadIntoResource(this);
            this.isLoaded = true;
        }
        finally {
            this.isLoading = false;
            task.stop();
        }
    }

    @Override
    protected void doUnload() {
        super.doUnload();
        this.isLoadedFromStorage = false;
    }

    @Override
    protected void clearInternalState() {
        this.isLoadedFromStorage = false;
        super.clearInternalState();
    }

    @Override
    public EObject getEObject(String uriFragment) {
        EObject _xblockexpression = null;
        boolean _isPortableURIFragment = this.portableURIs.isPortableURIFragment(uriFragment);
        if (_isPortableURIFragment) {
            return this.portableURIs.resolve(this, uriFragment);
        }
        _xblockexpression = super.getEObject(uriFragment);
        return _xblockexpression;
    }

    @Override
    protected Set<String> getUnresolvableURIFragments() {
        if (this.isLoadedFromStorage) {
            return Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new String[]{UNRESOLVABLE_FRAGMENT}));
        }
        return super.getUnresolvableURIFragments();
    }

    @Pure
    public IResourceStorageFacade getResourceStorageFacade() {
        return this.resourceStorageFacade;
    }

    @Pure
    public PortableURIs getPortableURIs() {
        return this.portableURIs;
    }

    @Pure
    public boolean isLoadedFromStorage() {
        return this.isLoadedFromStorage;
    }

    public void setIsLoadedFromStorage(boolean isLoadedFromStorage) {
        this.isLoadedFromStorage = isLoadedFromStorage;
    }

    @Pure
    public IResourceDescription getResourceDescription() {
        return this.resourceDescription;
    }

    public void setResourceDescription(IResourceDescription resourceDescription) {
        this.resourceDescription = resourceDescription;
    }
}

