/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.glyphs;

import fr.inria.zvtm.glyphs.VText;
import fr.inria.zvtm.text.PrefixTextShortener;
import fr.inria.zvtm.text.TextShortener;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public class AdaptiveText<T>
extends VText {
    private TextShortener shortener = PrefixTextShortener.INSTANCE;
    private double vsHeight;
    private double vsWidth;
    private Rectangle2D textPxBounds = null;

    public AdaptiveText(double x, double y, int z, Color c, String t, double vsWidth, double vsHeight) {
        super(x, y, z, c, t);
        this.vsHeight = vsHeight;
        this.vsWidth = vsWidth;
        super.setTextAnchor((short)1);
        this.invalidatePixelBounds();
    }

    private void computePixelBounds(Graphics2D g2d) {
        this.textPxBounds = new TextLayout(this.getText(), this.getFont(), g2d.getFontRenderContext()).getBounds();
    }

    private void invalidatePixelBounds() {
        this.textPxBounds = null;
    }

    private boolean validPixelBounds() {
        return this.textPxBounds != null;
    }

    public void setShortener(TextShortener shortener) {
        this.shortener = shortener;
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this.invalidatePixelBounds();
    }

    @Override
    public void setScale(float ignored) {
    }

    @Override
    public void setScaleIndependent(boolean ignored) {
    }

    @Override
    public void setTextAnchor(short ignored) {
    }

    @Override
    public boolean visibleInRegion(double wb, double nb, double eb, double sb, int i) {
        return this.vx + this.vsWidth / 2.0 >= wb && this.vx - this.vsWidth / 2.0 <= eb && this.vy + this.vsHeight / 2.0 >= sb && this.vy - this.vsHeight / 2.0 <= nb;
    }

    @Override
    public boolean containedInRegion(double wb, double nb, double eb, double sb, int i) {
        return this.vx - this.vsWidth / 2.0 >= wb && this.vx + this.vsWidth / 2.0 <= eb && this.vy - this.vsHeight / 2.0 >= sb && this.vy + this.vsHeight / 2.0 <= nb;
    }

    @Override
    public void draw(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        String finalTxt = this.getText();
        if (!this.validPixelBounds()) {
            this.computePixelBounds(g);
        }
        double xscr = this.vsWidth * this.coef;
        double yscr = this.vsHeight * this.coef;
        float txtScale = 1.0f;
        if (yscr < this.textPxBounds.getHeight()) {
            txtScale = (float)(yscr / this.textPxBounds.getHeight());
        }
        if (xscr < this.textPxBounds.getWidth() * (double)txtScale) {
            int txLen = (int)Math.floor(xscr / (this.textPxBounds.getWidth() * (double)txtScale) * (double)this.getText().length());
            finalTxt = this.shortener.shorten(finalTxt, txLen);
        }
        if (this.alphaC != null && this.alphaC.getAlpha() == 0.0f) {
            return;
        }
        g.setFont(this.font != null ? this.font : AdaptiveText.getMainFont());
        AffineTransform at = AffineTransform.getTranslateInstance((double)(dx + this.pc[i].cx) - this.textPxBounds.getWidth() * (double)txtScale * (double)finalTxt.length() / (double)this.getText().length() * 0.5, (double)(dy + this.pc[i].cy) + this.textPxBounds.getHeight() * 0.5 * (double)txtScale);
        at.concatenate(AffineTransform.getScaleInstance(txtScale, txtScale));
        g.setTransform(at);
        if (this.alphaC != null) {
            g.setComposite(this.alphaC);
            if (this.isBorderDrawn()) {
                g.setColor(this.borderColor);
            }
            g.setColor(this.color);
            g.drawString(finalTxt, 0.0f, 0.0f);
            g.setComposite(acO);
        } else {
            if (this.isBorderDrawn()) {
                g.setColor(this.borderColor);
            }
            g.setColor(this.color);
            g.drawString(finalTxt, 0.0f, 0.0f);
        }
        g.setTransform(stdT);
    }

    @Override
    public void drawForLens(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        this.draw(g, vW, vH, i, stdS, stdT, dx, dy);
    }
}

