/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.sew.launcher.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.efm.sew.launcher.Activator;
import org.eclipse.efm.sew.launcher.LaunchConfigurationTabGroup;
import org.eclipse.efm.sew.launcher.ui.AbstractSewLaunchConfigurationTab;
import org.eclipse.efm.sew.launcher.ui.internal.SWTFactory;
import org.eclipse.efm.sew.launcher.ui.internal.fieldeditor.BooleanFieldEditor;
import org.eclipse.efm.sew.launcher.ui.internal.fieldeditor.StringFieldEditor;
import org.eclipse.efm.sew.launcher.workflow.common.ConsoleVerboseKind;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.PlatformUI;

public class DebugTab
extends AbstractSewLaunchConfigurationTab {
    private static final String[] CONSOLE_LEVEL_COMBO_ITEMS = new String[]{ConsoleVerboseKind.SILENT.getLiteral(), ConsoleVerboseKind.MINIMUM.getLiteral(), ConsoleVerboseKind.MEDIUM.getLiteral(), ConsoleVerboseKind.MAXIMUM.getLiteral()};
    private Combo fConsoleLevelCombo = null;
    private ConsoleVerboseKind fConsoleLevel = ConsoleVerboseKind.MINIMUM;
    private BooleanFieldEditor fFirstParsedModelTextualEnabledBooleanField;
    private BooleanFieldEditor fFirstParsedModelGraphizEnabledBooleanField;
    private BooleanFieldEditor fFirstCompiledModelTextualEnabledBooleanField;
    private boolean fEnabledSymbexDeveloperMode;
    private BooleanFieldEditor fFirstSymbexOutputTextualEnabledBooleanField;
    private BooleanFieldEditor fFirstSymbexOutputGraphizEnabledBooleanField;
    private StringFieldEditor fFirstSymbexOutputGraphizTraceStringField;
    private StringFieldEditor fFirstSymbexOutputGraphizFormatStringField;
    private Composite fCompositeFirstSymbexOutputGraphiz;
    private BooleanFieldEditor fSecondSymbexOutputTextualEnabledBooleanField;
    private BooleanFieldEditor fSecondSymbexOutputGraphizEnabledBooleanField;
    private StringFieldEditor fSecondSymbexOutputGraphizTraceStringField;
    private StringFieldEditor fSecondSymbexOutputGraphizFormatStringField;
    private Composite fCompositeSecondSymbexOutputGraphiz;
    private TabListener fListener = new TabListener();

    public DebugTab(LaunchConfigurationTabGroup groupTab) {
        super(groupTab);
        this.setHelpContextId("org.eclipse.efm.sew.launcher.efm_runconf_debug_tab");
        IPreferenceStore prefs = Activator.getDefault().getPreferenceStore();
        this.fEnabledSymbexDeveloperMode = prefs.getBoolean("org.eclipse.efm.sew.launcher.ui.PREF_SYMBEX_DEVELOPER_MODE");
    }

    public void createControl(Composite parent) {
        Composite simpleComposite = SWTFactory.createComposite(parent, parent.getFont(), 1, 1, 768, 0, 0);
        this.setControl((Control)simpleComposite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), this.getHelpContextId());
        this.createDebugTracePage(simpleComposite);
    }

    public void createDebugTracePage(Composite parent) {
        Group group = SWTFactory.createGroup(parent, "Debug Trace", 1, 1, 768);
        this.createConsoleLogComponent((Composite)group);
        this.createFirstSymbexWorkflowPage((Composite)group);
        this.createSecondSymbexWorkflowtPage((Composite)group);
    }

    private void createConsoleLogComponent(Composite parent) {
        Group group = SWTFactory.createGroup(parent, "Console Log", 2, 1, 768);
        SWTFactory.createLabel((Composite)group, "&Verbose Level:", 1);
        this.fConsoleLevelCombo = SWTFactory.createCombo((Composite)group, 12, 1, CONSOLE_LEVEL_COMBO_ITEMS);
        this.fConsoleLevelCombo.addSelectionListener((SelectionListener)this.fListener);
    }

    public void createFirstSymbexWorkflowPage(Composite parent) {
        Group group = SWTFactory.createGroup(parent, "First Stage Symbex Workflow Page", 1, 1, 768);
        this.createFirstInputModelGraphicComponent((Composite)group);
        this.createFirstSymbexOutputComponent((Composite)group);
    }

    private void createFirstInputModelGraphicComponent(Composite parent) {
        Group group = SWTFactory.createGroup(parent, "Input Model Generated Traces", 1, 1, 768);
        Composite comp = SWTFactory.createComposite((Composite)group, 1, 1, 768);
        this.fFirstParsedModelTextualEnabledBooleanField = new BooleanFieldEditor(this, "org.eclipse.efm.sew.launcher.ATTR_ENABLED_FIRST_PARSED_MODEL_TEXTUAL_GENERATION", "&Parsed Model as Textual Representation", comp, false);
        this.fFirstParsedModelGraphizEnabledBooleanField = new BooleanFieldEditor(this, "org.eclipse.efm.sew.launcher.ATTR_ENABLED_FIRST_PARSED_MODEL_GRAPHVIZ_GENERATION", "&Parsed Model as <Graphiz> Representation", comp, false);
        if (this.fEnabledSymbexDeveloperMode) {
            this.fFirstCompiledModelTextualEnabledBooleanField = new BooleanFieldEditor(this, "org.eclipse.efm.sew.launcher.ATTR_ENABLED_FIRST_COMPILED_MODEL_TEXTUAL_GENERATION", "&Compiled Model as Textual Representation", comp, false);
        }
    }

    private void createFirstSymbexOutputComponent(Composite parent) {
        Group group = SWTFactory.createGroup(parent, "Symbex Output Generated Traces", 1, 1, 768);
        Composite comp = SWTFactory.createComposite((Composite)group, 1, 1, 768);
        this.fFirstSymbexOutputTextualEnabledBooleanField = new BooleanFieldEditor(this, "org.eclipse.efm.sew.launcher.ATTR_ENABLED_FIRST_SYMBEX_OUTPUT_TEXTUAL_GENERATION", "&Basic Textual Representation", comp, false);
        group = SWTFactory.createGroup(comp, "Symbex Output Generated Graphic Traces", 1, 1, 768);
        comp = SWTFactory.createComposite((Composite)group, 2, 1, 768);
        this.fFirstSymbexOutputGraphizEnabledBooleanField = new BooleanFieldEditor(this, "org.eclipse.efm.sew.launcher.ATTR_ENABLED_FIRST_SYMBEX_OUTPUT_GRAPHVIZ_GENERATION", "&<Graphiz> Representation", comp, false);
        this.fCompositeFirstSymbexOutputGraphiz = SWTFactory.createComposite(comp, 2, 2, 768);
        this.fFirstSymbexOutputGraphizTraceStringField = new StringFieldEditor(this, "org.eclipse.efm.sew.launcher.ATTR_FIRST_SYMBEX_OUTPUT_GRAPHVIZ_TRACE_SPEC", "&Trace:", this.fCompositeFirstSymbexOutputGraphiz, "com = [*]\nvariable = [*]\n// See full grammar of [Trace Specification] at the end of this generated file", 2);
        this.fFirstSymbexOutputGraphizFormatStringField = new StringFieldEditor(this, "org.eclipse.efm.sew.launcher.ATTR_FIRST_SYMBEX_OUTPUT_GRAPHVIZ_FORMAT_SPEC", "&Format:", this.fCompositeFirstSymbexOutputGraphiz, "path#condition = PC: %1%\npath#timed#condition = PtC: %1%\nnode#condition = \nnode#timed#condition = \nassign     = %3%=%4%\nnewfresh   = newfresh(%1%:%3%) <- %4%\ninput#env  = INPUT %3%(%4%)\ninput      = input %3%(%4%)\noutput#env = OUTPUT %3%(%4%)\noutput     = output %3%(%4%)\nroutine    = invoke %2%:%3%\ntransition = fired transition %3%\nmachine    = \"run %1%:%3%\"\n", 2);
    }

    private void setEnableFirstExecutionPage(boolean checked) {
        this.fCompositeFirstSymbexOutputGraphiz.setVisible(checked);
        this.visibleAndExclude((Control)this.fCompositeFirstSymbexOutputGraphiz, checked);
    }

    public void createSecondSymbexWorkflowtPage(Composite parent) {
        Group group = SWTFactory.createGroup(parent, "Second Stage Symbex Workflow Page", 1, 1, 768);
        this.createSecondSymbexOutputComponent((Composite)group);
    }

    private void createSecondSymbexOutputComponent(Composite parent) {
        Group group = SWTFactory.createGroup(parent, "Symbex Output Generated Traces", 1, 1, 768);
        Composite comp = SWTFactory.createComposite((Composite)group, 1, 1, 768);
        this.fSecondSymbexOutputTextualEnabledBooleanField = new BooleanFieldEditor(this, "org.eclipse.efm.sew.launcher.ATTR_ENABLED_SECOND_SYMBEX_OUTPUT_TEXTUAL_GENERATION", "&Basic Textual Representation", comp, false);
        group = SWTFactory.createGroup(comp, "Symbex Output Generated Graphic Traces", 1, 1, 768);
        comp = SWTFactory.createComposite((Composite)group, 2, 1, 768);
        this.fSecondSymbexOutputGraphizEnabledBooleanField = new BooleanFieldEditor(this, "org.eclipse.efm.sew.launcher.ATTR_ENABLED_SECOND_SYMBEX_OUTPUT_GRAPHVIZ_GENERATION", "&<Graphiz> Representation", comp, false);
        this.fCompositeSecondSymbexOutputGraphiz = SWTFactory.createComposite(comp, 2, 2, 768);
        this.fSecondSymbexOutputGraphizTraceStringField = new StringFieldEditor(this, "org.eclipse.efm.sew.launcher.ATTR_SECOND_SYMBEX_OUTPUT_GRAPHVIZ_TRACE_SPEC", "&Trace:", this.fCompositeSecondSymbexOutputGraphiz, "com = [*]\n// See full grammar of [Trace Specification] at the end of this generated file", 2);
        this.fSecondSymbexOutputGraphizFormatStringField = new StringFieldEditor(this, "org.eclipse.efm.sew.launcher.ATTR_ENABLED_SECOND_SYMBEX_OUTPUT_GRAPHVIZ_FORMAT_SPEC", "&Format:", this.fCompositeSecondSymbexOutputGraphiz, "path#condition = PC: %1%\npath#timed#condition = PtC: %1%\nnode#condition = \nnode#timed#condition = \nassign     = %3%=%4%\nnewfresh   = newfresh(%1%:%3%) <- %4%\ninput#env  = INPUT %3%(%4%)\ninput      = input %3%(%4%)\noutput#env = OUTPUT %3%(%4%)\noutput     = output %3%(%4%)\nroutine    = invoke %2%:%3%\ntransition = fired transition %3%\nmachine    = \"run %1%:%3%\"\n", 2);
    }

    private void setEnableSecondExecutionPage(boolean checked) {
        this.fCompositeSecondSymbexOutputGraphiz.setVisible(checked);
        this.visibleAndExclude((Control)this.fCompositeSecondSymbexOutputGraphiz, checked);
    }

    IDialogSettings getDialogBoundsSettings(String id) {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(id);
        if (section == null) {
            section = settings.addNewSection(id);
        }
        return section;
    }

    private void handleConsoleLevelSelectionChange() {
        this.fConsoleLevel = ConsoleVerboseKind.get(this.fConsoleLevelCombo.getText());
        if (this.fConsoleLevel == null) {
            this.fConsoleLevel = ConsoleVerboseKind.MINIMUM;
        }
        this.updateLaunchConfigurationDialog();
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        return true;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_CONSOLE_LOG_VERBOSE_LEVEL", "MINIMUM");
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_FIRST_PARSED_MODEL_TEXTUAL_GENERATION", false);
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_FIRST_PARSED_MODEL_TEXTUAL_FILENAME", "model_parsed.xlia");
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_FIRST_PARSED_MODEL_GRAPHVIZ_GENERATION", false);
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_FIRST_PARSED_MODEL_GRAPHVIZ_FILENAME", "model_parsed_graph.gv");
        if (this.fEnabledSymbexDeveloperMode) {
            configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_FIRST_COMPILED_MODEL_TEXTUAL_GENERATION", false);
            configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_FIRST_COMPILED_MODEL_TEXTUAL_FILENAME", "phase1_compiled_model.fexe");
        }
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_FIRST_SYMBEX_OUTPUT_TEXTUAL_GENERATION", false);
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_FIRST_SYMBEX_OUTPUT_TEXTUAL_FILENAME", "symbex_output.fscn");
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_FIRST_SYMBEX_OUTPUT_GRAPHVIZ_GENERATION", false);
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_FIRST_SYMBEX_OUTPUT_GRAPHVIZ_FILENAME", "symbex_output.gv");
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_FIRST_SYMBEX_OUTPUT_GRAPHVIZ_TRACE_SPEC", "com = [*]\nvariable = [*]\n// See full grammar of [Trace Specification] at the end of this generated file");
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_FIRST_SYMBEX_OUTPUT_GRAPHVIZ_FORMAT_SPEC", "path#condition = PC: %1%\npath#timed#condition = PtC: %1%\nnode#condition = \nnode#timed#condition = \nassign     = %3%=%4%\nnewfresh   = newfresh(%1%:%3%) <- %4%\ninput#env  = INPUT %3%(%4%)\ninput      = input %3%(%4%)\noutput#env = OUTPUT %3%(%4%)\noutput     = output %3%(%4%)\nroutine    = invoke %2%:%3%\ntransition = fired transition %3%\nmachine    = \"run %1%:%3%\"\n");
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_SECOND_PARSED_MODEL_TEXTUAL_GENERATION", false);
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_SECOND_PARSED_MODEL_TEXTUAL_FILENAME", "phase2_parsed_model.xlia");
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_SECOND_PARSED_MODEL_GRAPHVIZ_GENERATION", false);
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_SECOND_PARSED_MODEL_GRAPHVIZ_FILENAME", "phase2_parsed_model.gv");
        if (this.fEnabledSymbexDeveloperMode) {
            configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_SECOND_COMPILED_MODEL_TEXTUAL_GENERATION", false);
            configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_SECOND_COMPILED_MODEL_TEXTUAL_FILENAME", "phase2_compiled_model.fexe");
        }
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_SECOND_SYMBEX_OUTPUT_TEXTUAL_GENERATION", false);
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_SECOND_SYMBEX_OUTPUT_TEXTUAL_FILENAME", "symbex_output_extension.fscn");
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_SECOND_SYMBEX_OUTPUT_GRAPHVIZ_GENERATION", false);
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_SECOND_SYMBEX_OUTPUT_GRAPHVIZ_FILENAME", "symbex_output_extension.gv");
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_SECOND_SYMBEX_OUTPUT_GRAPHVIZ_TRACE_SPEC", "com = [*]\n// See full grammar of [Trace Specification] at the end of this generated file");
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_SECOND_SYMBEX_OUTPUT_GRAPHVIZ_FORMAT_SPEC", "path#condition = PC: %1%\npath#timed#condition = PtC: %1%\nnode#condition = \nnode#timed#condition = \nassign     = %3%=%4%\nnewfresh   = newfresh(%1%:%3%) <- %4%\ninput#env  = INPUT %3%(%4%)\ninput      = input %3%(%4%)\noutput#env = OUTPUT %3%(%4%)\noutput     = output %3%(%4%)\nroutine    = invoke %2%:%3%\ntransition = fired transition %3%\nmachine    = \"run %1%:%3%\"\n");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.fConsoleLevel = ConsoleVerboseKind.get(configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_CONSOLE_LOG_VERBOSE_LEVEL", ConsoleVerboseKind.MINIMUM.getLiteral()));
        }
        catch (CoreException e) {
            e.printStackTrace();
            this.fConsoleLevel = ConsoleVerboseKind.MINIMUM;
        }
        if (this.fConsoleLevel == null) {
            this.fConsoleLevel = ConsoleVerboseKind.MINIMUM;
        }
        this.initializeConsoleLevel();
        this.fFirstParsedModelTextualEnabledBooleanField.initializeFrom(configuration);
        this.fFirstParsedModelGraphizEnabledBooleanField.initializeFrom(configuration);
        if (this.fEnabledSymbexDeveloperMode) {
            this.fFirstCompiledModelTextualEnabledBooleanField.initializeFrom(configuration);
        }
        this.fFirstSymbexOutputTextualEnabledBooleanField.initializeFrom(configuration);
        this.fFirstSymbexOutputGraphizEnabledBooleanField.initializeFrom(configuration);
        this.fFirstSymbexOutputGraphizTraceStringField.initializeFrom(configuration);
        this.fFirstSymbexOutputGraphizFormatStringField.initializeFrom(configuration);
        this.fSecondSymbexOutputTextualEnabledBooleanField.initializeFrom(configuration);
        this.fSecondSymbexOutputGraphizEnabledBooleanField.initializeFrom(configuration);
        this.fSecondSymbexOutputGraphizTraceStringField.initializeFrom(configuration);
        this.fSecondSymbexOutputGraphizFormatStringField.initializeFrom(configuration);
        this.setEnableFirstExecutionPage(this.fFirstSymbexOutputGraphizEnabledBooleanField.getBooleanValue());
        this.setEnableSecondExecutionPage(this.fSecondSymbexOutputGraphizEnabledBooleanField.getBooleanValue());
    }

    private void initializeConsoleLevel() {
        switch (this.fConsoleLevel) {
            case SILENT: {
                this.fConsoleLevelCombo.select(0);
                break;
            }
            case MINIMUM: {
                this.fConsoleLevelCombo.select(1);
                break;
            }
            case MEDIUM: {
                this.fConsoleLevelCombo.select(2);
                break;
            }
            case MAXIMUM: {
                this.fConsoleLevelCombo.select(3);
                break;
            }
            default: {
                this.fConsoleLevelCombo.select(0);
            }
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_CONSOLE_LOG_VERBOSE_LEVEL", this.fConsoleLevel.getLiteral());
        this.fFirstParsedModelTextualEnabledBooleanField.performApply(configuration);
        this.fFirstParsedModelGraphizEnabledBooleanField.performApply(configuration);
        if (this.fEnabledSymbexDeveloperMode) {
            this.fFirstCompiledModelTextualEnabledBooleanField.performApply(configuration);
        }
        this.fFirstSymbexOutputTextualEnabledBooleanField.performApply(configuration);
        this.fFirstSymbexOutputGraphizEnabledBooleanField.performApply(configuration);
        this.fFirstSymbexOutputGraphizTraceStringField.performApply(configuration);
        this.fFirstSymbexOutputGraphizFormatStringField.performApply(configuration);
        this.fSecondSymbexOutputTextualEnabledBooleanField.performApply(configuration);
        this.fSecondSymbexOutputGraphizEnabledBooleanField.performApply(configuration);
        this.fSecondSymbexOutputGraphizTraceStringField.performApply(configuration);
        this.fSecondSymbexOutputGraphizFormatStringField.performApply(configuration);
        this.setEnableFirstExecutionPage(this.fFirstSymbexOutputGraphizEnabledBooleanField.getBooleanValue());
        this.setEnableSecondExecutionPage(this.fSecondSymbexOutputGraphizEnabledBooleanField.getBooleanValue());
    }

    public String getName() {
        return "Debug";
    }

    private class TabListener
    extends SelectionAdapter
    implements ModifyListener {
        private TabListener() {
        }

        public void modifyText(ModifyEvent e) {
            DebugTab.this.updateLaunchConfigurationDialog();
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == DebugTab.this.fConsoleLevelCombo) {
                DebugTab.this.handleConsoleLevelSelectionChange();
            }
        }
    }
}

