/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.wizards.projectFormat;

import java.net.URI;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewPathVariableDialog
extends Dialog {
    private String name;
    private URI actualValue;
    private Text newValue;
    private final ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            NewPathVariableDialog.this.validate();
        }
    };

    public NewPathVariableDialog(Shell shell, String name, URI actualValue) {
        super(shell);
        this.setShellStyle(shell.getStyle() | 0x10);
        this.name = name;
        this.actualValue = actualValue;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Errors during loading path variables.");
    }

    public URI getActualValue() {
        return this.actualValue;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(1, false));
        container.setLayoutData((Object)new GridData(1808));
        Composite nameContainer = new Composite(parent, 0);
        nameContainer.setLayout((Layout)new GridLayout(2, false));
        nameContainer.setLayoutData((Object)new GridData(1808));
        Label label = new Label(nameContainer, 0);
        label.setText("The name of the path variable: ");
        Text text = new Text(nameContainer, 2052);
        text.setLayoutData((Object)new GridData(768));
        text.setText(this.name);
        text.setEditable(false);
        label = new Label(nameContainer, 0);
        label.setText("The value of the path variable: ");
        this.newValue = new Text(nameContainer, 2052);
        this.newValue.setLayoutData((Object)new GridData(768));
        if (this.actualValue != null) {
            this.newValue.setText(this.actualValue.toString());
        }
        this.newValue.setEditable(true);
        this.newValue.addModifyListener(this.modifyListener);
        Dialog.applyDialogFont((Control)container);
        return container;
    }

    private void validate() {
        String temp = this.newValue.getText();
        Path tempPath = new Path(temp);
        if (tempPath.isValidPath(temp)) {
            this.actualValue = URIUtil.toURI((IPath)tempPath);
            this.getButton(0).setEnabled(true);
        } else {
            this.getButton(0).setEnabled(false);
        }
    }
}

