/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.referenceSearch;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.graphics.Image;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.editors.referenceSearch.ReferenceSearchContentProvider;
import org.eclipse.titan.designer.editors.referenceSearch.ReferenceSearchMatch;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

public class ReferenceSearchResultView
extends AbstractTextSearchViewPage {
    private ReferenceSearchContentProvider contentProvider;

    public ReferenceSearchResultView() {
        super(2);
    }

    protected void elementsChanged(Object[] objects) {
        if (this.contentProvider != null) {
            this.getViewer().refresh();
        }
    }

    protected void clear() {
        this.getViewer().refresh();
    }

    protected void configureTreeViewer(TreeViewer viewer) {
        this.contentProvider = new ReferenceSearchContentProvider(this);
        viewer.setContentProvider((IContentProvider)this.contentProvider);
        viewer.setLabelProvider((IBaseLabelProvider)new ReferenceSearchLabelProvider());
        viewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        this.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                try {
                    Object selectedElement = ((TreeSelection)event.getSelection()).getFirstElement();
                    if (selectedElement instanceof ReferenceSearchMatch) {
                        ReferenceSearchMatch match = (ReferenceSearchMatch)((Object)selectedElement);
                        ReferenceSearchResultView.this.showMatch(match, match.getOffset(), match.getLength(), false);
                        return;
                    }
                }
                catch (PartInitException e) {
                    ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
                }
            }
        });
    }

    protected void configureTableViewer(TableViewer viewer) {
    }

    protected void showMatch(Match match, int currentOffset, int currentLength) throws PartInitException {
        if (!(match instanceof ReferenceSearchMatch)) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.getViewer().getSelection();
        if (selection != null && !selection.toList().contains(match)) {
            this.getViewer().setSelection((ISelection)new StructuredSelection((Object)match));
        }
        IFile file = (IFile)match.getElement();
        IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(file.getName());
        if (desc == null) {
            return;
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart part = page.openEditor((IEditorInput)new FileEditorInput(file), desc.getId(), false);
        if (part != null && part instanceof ITextEditor) {
            ITextEditor textEditor = (ITextEditor)part;
            textEditor.selectAndReveal(currentOffset, currentLength);
        }
    }

    private static class ReferenceSearchLabelProvider
    extends LabelProvider {
        private static final String ICON_MATCH = "match.gif";
        private final Image matchIcon = ImageCache.getImage("match.gif");

        public Image getImage(Object element) {
            if (element instanceof Match) {
                return this.matchIcon;
            }
            return WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider().getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof IResource) {
                return WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider().getText(element);
            }
            if (element instanceof ReferenceSearchMatch) {
                ReferenceSearchMatch refSearchMatch = (ReferenceSearchMatch)((Object)element);
                return refSearchMatch.getId().getDisplayName() + " at line " + refSearchMatch.getId().getLocation().getLine() + ".";
            }
            return "Unexpected element";
        }
    }
}

