/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values;

public class CharstringExtractor {
    private static final String INVALID_ESCAPE_SEQUENCE = "Invalid escape sequence: ";
    private boolean mErrorneous = false;
    private final String mExtractedString;
    private String mErrorMessage;

    public CharstringExtractor(String aTccnCharstring) {
        this.mExtractedString = this.extractString(aTccnCharstring);
    }

    public String getExtractedString() {
        return this.mExtractedString;
    }

    public boolean isErrorneous() {
        return this.mErrorneous;
    }

    public String getErrorMessage() {
        return this.mErrorMessage;
    }

    private String extractString(String aTccnCharstring) {
        int slength = aTccnCharstring.length();
        int pointer = 0;
        StringBuilder sb = new StringBuilder();
        while (pointer < slength) {
            if (pointer + 1 < slength && aTccnCharstring.substring(pointer, pointer + 2).equals("\"\"")) {
                sb.append('\"');
                pointer += 2;
                continue;
            }
            if (pointer + 1 < slength) {
                char c1 = aTccnCharstring.charAt(pointer);
                if (c1 == '\\') {
                    char c2;
                    if ((c2 = aTccnCharstring.charAt(++pointer)) == '\'' || c2 == '\"' || c2 == '?' || c2 == '\\') {
                        sb.append(aTccnCharstring.charAt(pointer));
                        ++pointer;
                        continue;
                    }
                    if (c2 == 'a') {
                        sb.append('\u0007');
                        ++pointer;
                        continue;
                    }
                    if (c2 == 'b') {
                        sb.append('\b');
                        ++pointer;
                        continue;
                    }
                    if (c2 == 'f') {
                        sb.append('\f');
                        ++pointer;
                        continue;
                    }
                    if (c2 == 'n') {
                        sb.append('\n');
                        ++pointer;
                        continue;
                    }
                    if (c2 == 'r') {
                        sb.append('\r');
                        ++pointer;
                        continue;
                    }
                    if (c2 == 't') {
                        sb.append('\t');
                        ++pointer;
                        continue;
                    }
                    if (c2 == 'v') {
                        sb.append('\u000b');
                        ++pointer;
                        continue;
                    }
                    if (c2 == '\n') {
                        sb.append('\n');
                        ++pointer;
                        continue;
                    }
                    if (c2 == 'x') {
                        if (++pointer >= slength) {
                            this.mErrorMessage = "Invalid escape sequence: '\\x'";
                            this.mErrorneous = true;
                            return null;
                        }
                        int hexStart = pointer;
                        if (!CharstringExtractor.isHexDigit(aTccnCharstring.charAt(pointer))) {
                            this.mErrorMessage = "Invalid escape sequence: '\\x" + aTccnCharstring.charAt(hexStart) + "'";
                            this.mErrorneous = true;
                            return null;
                        }
                        if (++pointer < slength && CharstringExtractor.isHexDigit(aTccnCharstring.charAt(pointer))) {
                            ++pointer;
                        }
                        sb.append((char)Integer.parseInt(aTccnCharstring.substring(hexStart, pointer), 16));
                        continue;
                    }
                    if (CharstringExtractor.isOctDigit(c2)) {
                        int octStart = pointer++;
                        while (pointer < slength && pointer - octStart < 3 && CharstringExtractor.isOctDigit(aTccnCharstring.charAt(pointer))) {
                            ++pointer;
                        }
                        int octInt = Integer.parseInt(aTccnCharstring.substring(octStart, pointer), 8);
                        if (octInt > 255) {
                            this.mErrorMessage = "Invalid escape sequence: '\\" + aTccnCharstring.substring(octStart, pointer) + "'";
                            this.mErrorneous = true;
                            return null;
                        }
                        sb.append((char)octInt);
                        continue;
                    }
                    this.mErrorMessage = "Invalid escape sequence: '\\" + c2 + "'";
                    this.mErrorneous = true;
                    return null;
                }
                sb.append(aTccnCharstring.charAt(pointer));
                ++pointer;
                continue;
            }
            sb.append(aTccnCharstring.charAt(pointer));
            ++pointer;
        }
        return sb.toString();
    }

    private static boolean isHexDigit(char aChar) {
        return aChar >= '0' && aChar <= '9' || aChar >= 'a' && aChar <= 'f' || aChar >= 'A' && aChar <= 'F';
    }

    private static boolean isOctDigit(char aChar) {
        return aChar >= '0' && aChar <= '7';
    }
}

