/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.templates;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.templates.NamedParameter;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class NamedParameters
extends ASTNode
implements ILocateableNode,
IIncrementallyUpdateable {
    private final List<NamedParameter> namedParams = new ArrayList<NamedParameter>();
    private Location location = NULL_Location.INSTANCE;

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        int size = this.namedParams.size();
        for (int i = 0; i < size; ++i) {
            this.namedParams.get(i).setMyScope(scope);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        int size = this.namedParams.size();
        for (int i = 0; i < size; ++i) {
            if (this.namedParams.get(i) != child) continue;
            return builder.append("[").append(String.valueOf(i + 1)).append("]");
        }
        return builder;
    }

    public String createStringRepresentation() {
        StringBuilder sb = new StringBuilder();
        for (NamedParameter n : this.namedParams) {
            sb.append(n.createStringRepresentation() + ", ");
        }
        if (!this.namedParams.isEmpty()) {
            sb.setLength(sb.length() - 2);
        }
        return sb.toString();
    }

    public void addParameter(NamedParameter parameter) {
        if (parameter != null && parameter.getName() != null) {
            this.namedParams.add(parameter);
            parameter.setFullNameParent(this);
        }
    }

    public int getNofParams() {
        return this.namedParams.size();
    }

    public NamedParameter getParamByIndex(int index) {
        return this.namedParams.get(index);
    }

    @Override
    public void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        int size = this.namedParams.size();
        for (int i = 0; i < size; ++i) {
            NamedParameter parameter = this.namedParams.get(i);
            parameter.updateSyntax(reparser, false);
            reparser.updateLocation(parameter.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.namedParams == null) {
            return;
        }
        for (NamedParameter namedParam : this.namedParams) {
            namedParam.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.namedParams != null) {
            for (NamedParameter np : this.namedParams) {
                if (np.accept(v)) continue;
                return false;
            }
        }
        return true;
    }
}

