/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.templates;

import java.text.MessageFormat;
import java.util.Set;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.TTCN3.TemplateRestriction;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TTCN3Template;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class AnyOrOmit_Template
extends TTCN3Template {
    private static final String MANDATORYWARNING = "Using `*' for a mandatory field";
    private static final String SIGNATUREERROR = "Generic wildcard `*'' cannot be used for signature `{0}''";

    @Override
    public ITTCN3Template.Template_type getTemplatetype() {
        return ITTCN3Template.Template_type.ANY_OR_OMIT;
    }

    @Override
    public String getTemplateTypeName() {
        if (this.isErroneous) {
            return "erroneous any or omit";
        }
        return "any or omit";
    }

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder("*");
        if (this.lengthRestriction != null) {
            builder.append(this.lengthRestriction.createStringRepresentation());
        }
        if (this.isIfpresent) {
            builder.append("ifpresent");
        }
        return builder.toString();
    }

    @Override
    public void checkSpecificValue(CompilationTimeStamp timestamp, boolean allowOmit) {
        this.getLocation().reportSemanticError("A specific value expected instead of an any or omit");
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
    }

    @Override
    public void checkThisTemplateGeneric(CompilationTimeStamp timestamp, IType type, boolean isModified, boolean allowOmit, boolean allowAnyOrOmit, boolean subCheck, boolean implicitOmit) {
        IType last;
        if (!allowAnyOrOmit) {
            this.location.reportSemanticWarning(MANDATORYWARNING);
        }
        if (!this.getIsErroneous(timestamp) && IType.Type_type.TYPE_SIGNATURE.equals((Object)(last = type.getTypeRefdLast(timestamp)).getTypetype())) {
            this.location.reportSemanticError(MessageFormat.format(SIGNATUREERROR, last.getFullName()));
            this.setIsErroneous(true);
        }
        this.checkLengthRestriction(timestamp, type);
        if (!allowOmit && this.isIfpresent) {
            this.location.reportSemanticError("`ifpresent' is not allowed here");
        }
        if (subCheck) {
            type.checkThisTemplateSubtype(timestamp, this);
        }
    }

    @Override
    public boolean chkRestrictionNamedListBaseTemplate(CompilationTimeStamp timestamp, String definitionName, Set<String> checkedNames, int neededCheckedCnt, Location usageLocation) {
        usageLocation.reportSemanticError(MessageFormat.format("Restriction on {0} does not allow usage of `{1}''", definitionName, this.getTemplateTypeName()));
        return false;
    }

    @Override
    public boolean checkPresentRestriction(CompilationTimeStamp timestamp, String definitionName, Location usageLocation) {
        this.checkRestrictionCommon(timestamp, definitionName, TemplateRestriction.Restriction_type.TR_PRESENT, usageLocation);
        usageLocation.reportSemanticError(MessageFormat.format("Restriction on {0} does not allow usage of `{1}''", definitionName, this.getTemplateTypeName()));
        return false;
    }
}

