/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.metrics.topview;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.titanium.metrics.AltstepMetric;
import org.eclipse.titanium.metrics.FunctionMetric;
import org.eclipse.titanium.metrics.IMetricEnum;
import org.eclipse.titanium.metrics.ModuleMetric;
import org.eclipse.titanium.metrics.TestcaseMetric;

class MetricSelectorDialog
implements Runnable {
    private Set<IMetricEnum> used = new HashSet<IMetricEnum>();
    private Map<IMetricEnum, Button> bs = new HashMap<IMetricEnum, Button>();

    @Override
    public void run() {
        Display disp = Display.getDefault();
        final Shell shell = new Shell(disp, 1264);
        shell.setText("Choose metrics");
        shell.setLayout((Layout)new GridLayout());
        ScrolledComposite sc = new ScrolledComposite((Composite)shell, 512);
        sc.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite content = new Composite((Composite)sc, 0);
        sc.setContent((Control)content);
        GridLayout l = new GridLayout();
        l.numColumns = 2;
        content.setLayout((Layout)l);
        content.setSize(200, 300);
        this.createSection(content, "Module", ModuleMetric.values());
        this.createSection(content, "Function", FunctionMetric.values());
        this.createSection(content, "Altstep", AltstepMetric.values());
        this.createSection(content, "Testcase", TestcaseMetric.values());
        Button button = new Button((Composite)shell, 8);
        button.setText("Ok");
        button.setLayoutData((Object)new GridData(131072, 1024, false, false));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MetricSelectorDialog.this.okPressed();
                shell.dispose();
            }
        });
        shell.pack();
        content.setSize(content.computeSize(-1, -1));
        shell.open();
        while (!shell.isDisposed()) {
            if (disp.readAndDispatch()) continue;
            disp.sleep();
        }
    }

    public Set<IMetricEnum> getUsed() {
        return this.used;
    }

    protected void okPressed() {
        for (IMetricEnum m : this.bs.keySet()) {
            if (!this.bs.get(m).getSelection()) continue;
            this.used.add(m);
        }
    }

    private void createSection(Composite content, String title, IMetricEnum[] metrics) {
        Label header = new Label(content, 0);
        header.setText(title);
        GridData headerData = new GridData();
        headerData.horizontalSpan = 2;
        header.setLayoutData((Object)headerData);
        Composite padding = new Composite(content, 0);
        padding.setLayoutData((Object)new GridData(25, 0));
        Composite inner = new Composite(content, 0);
        inner.setLayout((Layout)new GridLayout());
        for (IMetricEnum metric : metrics) {
            Button b = new Button(inner, 32);
            b.setText(metric.getName());
            b.setToolTipText(metric.getHint());
            this.bs.put(metric, b);
        }
    }
}

