/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.graph.gui.windows;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import javax.swing.JPanel;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.titanium.graph.gui.common.CustomSatelliteViewer;
import org.eclipse.titanium.graph.gui.windows.GraphEditor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class SatelliteView
extends ViewPart {
    private JPanel satView = new JPanel();
    private Frame window;
    private Dimension windowSize;
    private CustomSatelliteViewer satelliteGraph;
    private GraphEditor editor;
    public static final String ID = "org.eclipse.titanium.graph.gui.windows.SatelliteView";

    public SatelliteView() {
        this.satView.setBackground(Color.white);
    }

    public void createPartControl(final Composite parent) {
        Composite temp = new Composite(parent, 0x1040000);
        this.window = SWT_AWT.new_Frame((Composite)temp);
        this.windowSize = new Dimension(parent.getSize().x, parent.getSize().y);
        this.window.add(this.satView);
        parent.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                Point tmpSize = parent.getSize();
                SatelliteView.this.windowSize = new Dimension(tmpSize.x, tmpSize.y);
                if (SatelliteView.this.satelliteGraph == null) {
                    SatelliteView.this.window.setPreferredSize(SatelliteView.this.windowSize);
                    SatelliteView.this.window.repaint();
                } else {
                    SatelliteView.this.satelliteGraph.changeSize(SatelliteView.this.windowSize);
                }
            }
        });
        IEditorPart tmpEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (tmpEditor instanceof GraphEditor) {
            this.editor = (GraphEditor)tmpEditor;
            this.editor.setSatellite(this);
        }
    }

    public void init(IViewSite site) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
    }

    public void setFocus() {
    }

    public void dispose() {
        super.dispose();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SatelliteView.this.window.dispose();
            }
        });
        IWorkbenchWindow actWind = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (actWind == null) {
            return;
        }
        IWorkbenchPage actPage = actWind.getActivePage();
        if (actPage == null) {
            return;
        }
        IEditorPart tmpEditor = actPage.getActiveEditor();
        if (tmpEditor != null && tmpEditor instanceof GraphEditor) {
            ((GraphEditor)tmpEditor).setSatellite(null);
        }
    }

    public void add(CustomSatelliteViewer satGraph) {
        if (satGraph == null || this.satView == null) {
            return;
        }
        this.satelliteGraph = satGraph;
        this.satelliteGraph.setPreferredSize(this.windowSize);
        this.satelliteGraph.changeSize(this.windowSize);
        this.satView.removeAll();
        this.satView.add((Component)((Object)this.satelliteGraph));
        this.satelliteGraph.setPreferredSize(this.windowSize);
        this.satView.repaint();
        this.satView.revalidate();
    }

    public Dimension getSize() {
        return this.windowSize;
    }

    public void setSize(Dimension size) {
        this.windowSize = size;
        this.window.setSize(this.windowSize);
        this.satView.setPreferredSize(this.windowSize);
        this.satelliteGraph.changeSize(this.windowSize);
        this.satView.repaint();
    }

    public void repaint() {
        this.satView.repaint();
    }

    public void clear() {
        this.satView.removeAll();
        this.satView.repaint();
    }

    public void setEditor(GraphEditor editor) {
        this.editor = editor;
    }
}

