/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.ecore.formalml.datatype;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum PrimitiveTypeKind implements Enumerator
{
    BOOLEAN(0, "boolean", "boolean"),
    INT(1, "int", "int"),
    INTEGER(2, "integer", "integer"),
    RAT(3, "rat", "rat"),
    RATIONAL(4, "rational", "rational"),
    FLOAT(5, "float", "float"),
    DOUBLE(6, "double", "double"),
    REAL(7, "real", "real"),
    TIME(8, "time", "time"),
    UINT(9, "uint", "uint"),
    UINTEGER(10, "uinteger", "uinteger"),
    URAT(11, "urat", "urat"),
    URATIONAL(12, "urational", "urational"),
    UFLOAT(13, "ufloat", "ufloat"),
    UDOUBLE(14, "udouble", "udouble"),
    UREAL(15, "ureal", "ureal"),
    CHAR(16, "char", "char"),
    STRING(17, "string", "string"),
    BUFFER(18, "buffer", "buffer"),
    MESSAGE(19, "message", "message"),
    PORT(20, "port", "port"),
    MACHINE(21, "machine", "machine");

    public static final int BOOLEAN_VALUE = 0;
    public static final int INT_VALUE = 1;
    public static final int INTEGER_VALUE = 2;
    public static final int RAT_VALUE = 3;
    public static final int RATIONAL_VALUE = 4;
    public static final int FLOAT_VALUE = 5;
    public static final int DOUBLE_VALUE = 6;
    public static final int REAL_VALUE = 7;
    public static final int TIME_VALUE = 8;
    public static final int UINT_VALUE = 9;
    public static final int UINTEGER_VALUE = 10;
    public static final int URAT_VALUE = 11;
    public static final int URATIONAL_VALUE = 12;
    public static final int UFLOAT_VALUE = 13;
    public static final int UDOUBLE_VALUE = 14;
    public static final int UREAL_VALUE = 15;
    public static final int CHAR_VALUE = 16;
    public static final int STRING_VALUE = 17;
    public static final int BUFFER_VALUE = 18;
    public static final int MESSAGE_VALUE = 19;
    public static final int PORT_VALUE = 20;
    public static final int MACHINE_VALUE = 21;
    private static final PrimitiveTypeKind[] VALUES_ARRAY;
    public static final List<PrimitiveTypeKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new PrimitiveTypeKind[]{BOOLEAN, INT, INTEGER, RAT, RATIONAL, FLOAT, DOUBLE, REAL, TIME, UINT, UINTEGER, URAT, URATIONAL, UFLOAT, UDOUBLE, UREAL, CHAR, STRING, BUFFER, MESSAGE, PORT, MACHINE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static PrimitiveTypeKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PrimitiveTypeKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PrimitiveTypeKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PrimitiveTypeKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PrimitiveTypeKind get(int value) {
        switch (value) {
            case 0: {
                return BOOLEAN;
            }
            case 1: {
                return INT;
            }
            case 2: {
                return INTEGER;
            }
            case 3: {
                return RAT;
            }
            case 4: {
                return RATIONAL;
            }
            case 5: {
                return FLOAT;
            }
            case 6: {
                return DOUBLE;
            }
            case 7: {
                return REAL;
            }
            case 8: {
                return TIME;
            }
            case 9: {
                return UINT;
            }
            case 10: {
                return UINTEGER;
            }
            case 11: {
                return URAT;
            }
            case 12: {
                return URATIONAL;
            }
            case 13: {
                return UFLOAT;
            }
            case 14: {
                return UDOUBLE;
            }
            case 15: {
                return UREAL;
            }
            case 16: {
                return CHAR;
            }
            case 17: {
                return STRING;
            }
            case 18: {
                return BUFFER;
            }
            case 19: {
                return MESSAGE;
            }
            case 20: {
                return PORT;
            }
            case 21: {
                return MACHINE;
            }
        }
        return null;
    }

    private PrimitiveTypeKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

