/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zgrviewer;

import fr.inria.zvtm.engine.SwingWorker;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import net.claribole.zgrviewer.ConfigManager;
import net.claribole.zgrviewer.GraphicsManager;
import net.claribole.zgrviewer.ZGRViewer;

class CallBox
extends JDialog
implements ActionListener {
    static int FRAME_WIDTH = 400;
    static int FRAME_HEIGHT = 150;
    static String CMD_LINE = "";
    ZGRViewer application;
    GraphicsManager grMngr;
    JComboBox cmdLineCbb;
    JTextField srcFileTf;
    JButton brwBt;
    JButton openBt;
    JButton cancelBt;

    CallBox(ZGRViewer app, GraphicsManager gm) {
        super((Frame)gm.mainView.getFrame());
        this.application = app;
        this.grMngr = gm;
        Container cpane = this.getContentPane();
        GridBagLayout gridBag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        cpane.setLayout(gridBag);
        constraints.fill = 2;
        constraints.anchor = 17;
        JLabel lb1 = new JLabel("Command line (use %s for source and %t for target)");
        CallBox.buildConstraints(constraints, 0, 0, 2, 1, 70, 15);
        gridBag.setConstraints(lb1, constraints);
        cpane.add(lb1);
        constraints.fill = 0;
        constraints.anchor = 13;
        JButton helpBt = new JButton("?");
        CallBox.buildConstraints(constraints, 2, 0, 1, 1, 30, 0);
        gridBag.setConstraints(helpBt, constraints);
        cpane.add(helpBt);
        ActionListener a0 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(CallBox.this, "Use %s for source and %t for target:\ne.g. twopi -Tsvg -o %t %s");
            }
        };
        helpBt.addActionListener(a0);
        constraints.fill = 2;
        constraints.anchor = 17;
        this.cmdLineCbb = new JComboBox(ConfigManager.LAST_COMMANDS);
        this.cmdLineCbb.setEditable(true);
        this.cmdLineCbb.setMaximumRowCount(ConfigManager.COMMAND_LIMIT);
        CallBox.buildConstraints(constraints, 0, 1, 3, 1, 100, 23);
        gridBag.setConstraints(this.cmdLineCbb, constraints);
        cpane.add(this.cmdLineCbb);
        JLabel lb2 = new JLabel("Source file");
        CallBox.buildConstraints(constraints, 0, 2, 3, 1, 100, 15);
        gridBag.setConstraints(lb2, constraints);
        cpane.add(lb2);
        this.srcFileTf = new JTextField();
        CallBox.buildConstraints(constraints, 0, 3, 2, 1, 70, 23);
        gridBag.setConstraints(this.srcFileTf, constraints);
        cpane.add(this.srcFileTf);
        constraints.fill = 0;
        constraints.anchor = 13;
        this.brwBt = new JButton("Browse...");
        CallBox.buildConstraints(constraints, 2, 3, 1, 1, 30, 0);
        gridBag.setConstraints(this.brwBt, constraints);
        cpane.add(this.brwBt);
        this.cancelBt = new JButton("Cancel");
        CallBox.buildConstraints(constraints, 0, 4, 2, 1, 70, 24);
        gridBag.setConstraints(this.cancelBt, constraints);
        cpane.add(this.cancelBt);
        constraints.anchor = 17;
        this.openBt = new JButton("Open");
        CallBox.buildConstraints(constraints, 2, 4, 1, 1, 30, 0);
        gridBag.setConstraints(this.openBt, constraints);
        cpane.add(this.openBt);
        this.brwBt.addActionListener(this);
        this.openBt.addActionListener(this);
        this.cancelBt.addActionListener(this);
        WindowAdapter w0 = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                CallBox.this.dispose();
            }
        };
        this.addWindowListener(w0);
        this.setTitle("Open");
        this.setSize(FRAME_WIDTH, FRAME_HEIGHT);
        this.setLocationRelativeTo(this.grMngr.mainView.getFrame());
        this.setResizable(false);
        this.setVisible(true);
        this.cmdLineCbb.getEditor().getEditorComponent().requestFocus();
    }

    void chooseSourceFile() {
        File f;
        JFileChooser fc = new JFileChooser(ConfigManager.m_LastDir != null ? ConfigManager.m_LastDir : ConfigManager.m_PrjDir);
        fc.setFileSelectionMode(0);
        fc.setDialogTitle("Find Source File");
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == 0 && (f = fc.getSelectedFile()).exists()) {
            ConfigManager.m_LastDir = f.getParentFile();
            this.srcFileTf.setText(f.getAbsolutePath());
        }
    }

    void execCommand() {
        final String cmd = CMD_LINE;
        if (cmd.indexOf("%s") != -1 && cmd.indexOf("%t") != -1) {
            if (this.srcFileTf.getText() != null && this.srcFileTf.getText().length() > 0) {
                SwingWorker worker = new SwingWorker(){

                    public Object construct() {
                        CallBox.this.setVisible(false);
                        CallBox.this.application.gvLdr.load(cmd, CallBox.this.srcFileTf.getText());
                        CallBox.this.dispose();
                        return null;
                    }
                };
                worker.start();
            } else {
                JOptionPane.showMessageDialog(this, "The source file has not been specified", "Source file not specified", 0);
            }
        } else {
            JOptionPane.showMessageDialog(this, "Command line expression is missing %s or %t.\n\nUse %s for source and %t for target:\ne.g. twopi -Tsvg -o %t %s", "Ill-formed command line", 0);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.brwBt) {
            this.chooseSourceFile();
        } else if (o == this.openBt) {
            CMD_LINE = (String)this.cmdLineCbb.getSelectedItem();
            ZGRViewer.cfgMngr.rememberCommandLine(CMD_LINE);
            this.execCommand();
        } else if (o == this.cancelBt) {
            this.setVisible(false);
            this.dispose();
        }
    }

    static void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }
}

