/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.execution.configuration.common.ui.page.expert;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.efm.execution.configuration.common.ui.api.AbstractConfigurationPage;
import org.eclipse.efm.execution.configuration.common.ui.api.AbstractConfigurationProfile;
import org.eclipse.efm.execution.configuration.common.ui.api.IWidgetToolkit;
import org.eclipse.efm.execution.configuration.common.ui.editors.BooleanFieldEditor;
import org.eclipse.efm.execution.configuration.common.ui.editors.IntegerFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;

public class ExpertTransitionCoverageConfigurationProfile
extends AbstractConfigurationProfile {
    public static final String SCOPE_COMBO_ITEM_MODEL = "MODEL";
    public static final String SCOPE_COMBO_ITEM_INSTANCE = "INSTANCE";
    public static final String SCOPE_COMBO_ITEM_DETAILS = "DETAILS";
    public static final String[] SCOPE_COMBO_ITEMS = new String[]{"MODEL", "INSTANCE", "DETAILS"};
    private static final String HEURISTIC_START_COMBO_ITEM_BASIC = "BASIC";
    private static final String HEURISTIC_START_COMBO_ITEM_NAIVE = "NAIVE";
    private static final String HEURISTIC_START_COMBO_ITEM_SMART = "SMART";
    private static final String HEURISTIC_START_COMBO_ITEM_AGRESSIVE = "AGRESSIVE";
    private static final String[] HEURISTIC_START_COMBO_ITEMS = new String[]{"BASIC", "NAIVE", "SMART", "AGRESSIVE"};
    private static final String DIRECTIVE_TRACE_HEURISTIC_COMBO_ITEM_BASIC = "BASIC";
    private static final String DIRECTIVE_TRACE_HEURISTIC_COMBO_ITEM_NAIVE = "NAIVE";
    private static final String DIRECTIVE_TRACE_HEURISTIC_COMBO_ITEM_SMART = "SMART";
    private static final String DIRECTIVE_TRACE_HEURISTIC_COMBO_ITEM_AGRESSIVE = "AGRESSIVE";
    private static final String[] DIRECTIVE_TRACE_HEURISTIC_COMBO_ITEMS = new String[]{"BASIC", "NAIVE", "SMART", "AGRESSIVE"};
    private IntegerFieldEditor fTCBeginStep;
    private BooleanFieldEditor fTCStop;
    private BooleanFieldEditor fTCMinimize;
    private BooleanFieldEditor fTCSlice;
    private BooleanFieldEditor fTCHeuristic;
    private Combo fTCScopeCombo = null;
    private String fTCScope = "MODEL";
    private Combo fTCHeuristicStartCombo = null;
    private String fTCHeuristicStart = "BASIC";
    private IntegerFieldEditor fTCHeuristicTrials;
    private IntegerFieldEditor fTCObjectiveRate;
    private IntegerFieldEditor fTCObjectiveRest;
    private Combo fTCDirectiveTraceHeuristicCombo = null;
    private String fTCDirectiveTraceHeuristic = "SMART";
    private IntegerFieldEditor fTCDirectiveTraceCountLimit;
    private IntegerFieldEditor fTCDirectiveTraceSizeLimit;
    private IntegerFieldEditor fTCCoverageHeight;
    private IntegerFieldEditor fTCCoverageHeightReachedLimit;
    private BooleanFieldEditor fTCHitStronglyRandom;
    private IntegerFieldEditor fTCHitStronglyCount;
    private BooleanFieldEditor fTCHitWeaklyRandom;
    private IntegerFieldEditor fTCHitWeaklyCount;
    private BooleanFieldEditor fTCHitOtherRandom;
    private IntegerFieldEditor fTCHitOtherCount;
    private TabListener fListener = new TabListener();

    public ExpertTransitionCoverageConfigurationProfile(AbstractConfigurationPage configurationPage) {
        super(configurationPage);
    }

    private void handleScopeSelectionChange() {
        this.fTCScope = this.fTCScopeCombo.getText();
        this.fConfigurationPage.propagateGUIupdate();
    }

    private void handleHeuristicStartSelectionChange() {
        this.fTCHeuristicStart = this.fTCHeuristicStartCombo.getText();
        this.fConfigurationPage.propagateGUIupdate();
    }

    private void handleDirectiveTraceHeuristicSelectionChange() {
        this.fTCDirectiveTraceHeuristic = this.fTCDirectiveTraceHeuristicCombo.getText();
        this.fConfigurationPage.propagateGUIupdate();
    }

    @Override
    public String getSectionTitle() {
        return "Transition Coverage Configuration";
    }

    @Override
    public String getSectionDescription() {
        return "Transition Coverage, heuristic (expert) configuration section";
    }

    @Override
    protected void createContent(Composite parent, IWidgetToolkit widgetToolkit) {
        Group groupTCProperty = widgetToolkit.createGroup(parent, "Section PROPERTY", 1, 1, 768);
        Composite comp = widgetToolkit.createComposite((Composite)groupTCProperty, 1, 1, 768);
        this.fTCBeginStep = new IntegerFieldEditor(this.fConfigurationPage, "org.eclipse.efm.execution.core.ATTR_TRANSITION_COVERAGE_BEGIN_STEP", "&Begin Step :", comp, 0);
        this.fTCBeginStep.setToolTipText("Number of \"cumulated\" steps before begining the verification cover");
        this.fTCBeginStep.setEnabled(false);
        this.addField(this.fTCBeginStep);
        Group groupCommon = widgetToolkit.createGroup((Composite)groupTCProperty, "&Common Coverage Configuration", 4, 2, 768);
        Composite compCommon = widgetToolkit.createComposite((Composite)groupCommon, 1, 1, 768);
        this.fTCHeuristic = new BooleanFieldEditor(this.fConfigurationPage, "org.eclipse.efm.execution.core.ATTR_TRANSITION_COVERAGE_HEURISTIC", "&Heuristic", compCommon, true);
        this.fTCHeuristic.setToolTipText("Activate the use of heuristics");
        this.addField(this.fTCHeuristic);
        compCommon = widgetToolkit.createComposite((Composite)groupCommon, 1, 1, 768);
        this.fTCStop = new BooleanFieldEditor(this.fConfigurationPage, "org.eclipse.efm.execution.core.ATTR_TRANSITION_COVERAGE_STOP", "&Stop", compCommon, true);
        this.fTCStop.setToolTipText("Stop the symbolic excution as soon as the coverage is completed");
        this.addField(this.fTCStop);
        compCommon = widgetToolkit.createComposite((Composite)groupCommon, 1, 1, 768);
        this.fTCSlice = new BooleanFieldEditor(this.fConfigurationPage, "org.eclipse.efm.execution.core.ATTR_TRANSITION_COVERAGE_SLICE", "&Slice", compCommon, true);
        this.fTCSlice.setToolTipText("Pruning symbolic execution graph at the end of the analysis");
        this.addField(this.fTCSlice);
        compCommon = widgetToolkit.createComposite((Composite)groupCommon, 1, 1, 768);
        this.fTCMinimize = new BooleanFieldEditor(this.fConfigurationPage, "org.eclipse.efm.execution.core.ATTR_TRANSITION_COVERAGE_MINIMIZE", "&Minimize", compCommon, true);
        this.fTCMinimize.setToolTipText("Stop the symbolic execution at the earliest");
        this.addField(this.fTCMinimize);
        Composite comp3 = widgetToolkit.createComposite((Composite)groupTCProperty, 2, 1, 768);
        widgetToolkit.createLabel(comp3, "&Scope :", 1);
        this.fTCScopeCombo = widgetToolkit.createCombo(comp3, 12, 1, SCOPE_COMBO_ITEMS);
        this.fTCScopeCombo.addSelectionListener((SelectionListener)this.fListener);
        Group groupTCHeuristic = widgetToolkit.createGroup(parent, "First Heuristic Configuration", 2, 1, 768);
        Group group = widgetToolkit.createGroup((Composite)groupTCHeuristic, "&Configuration", 1, 1, 768);
        comp = widgetToolkit.createComposite((Composite)group, 2, 1, 768);
        widgetToolkit.createLabel(comp, "&Start :", 1);
        this.fTCHeuristicStartCombo = widgetToolkit.createCombo(comp, 12, 1, HEURISTIC_START_COMBO_ITEMS);
        this.fTCHeuristicStartCombo.addSelectionListener((SelectionListener)this.fListener);
        this.fTCHeuristicTrials = new IntegerFieldEditor(this.fConfigurationPage, "org.eclipse.efm.execution.core.ATTR_TRANSITION_COVERAGE_HEURISTIC_TRIALS", "&Trials :", comp, -1);
        this.fTCHeuristicTrials.widthInChars = 10;
        this.addField(this.fTCHeuristicTrials);
        group = widgetToolkit.createGroup((Composite)groupTCHeuristic, "&Target Objective", 1, 1, 768);
        comp = widgetToolkit.createComposite((Composite)group, 2, 1, 768);
        this.fTCObjectiveRate = new IntegerFieldEditor(this.fConfigurationPage, "org.eclipse.efm.execution.core.ATTR_TRANSITION_COVERAGE_OBJECTIVE_RATE", "&Rate :", comp, 100);
        this.fTCObjectiveRate.setTextLimit(3);
        this.addField(this.fTCObjectiveRate);
        this.fTCObjectiveRest = new IntegerFieldEditor(this.fConfigurationPage, "org.eclipse.efm.execution.core.ATTR_TRANSITION_COVERAGE_OBJECTIVE_REST", "&Rest :", comp, 0);
        this.fTCObjectiveRest.setTextLimit(3);
        this.addField(this.fTCObjectiveRest);
        group = widgetToolkit.createGroup((Composite)groupTCHeuristic, "&Lookahead Scope", 1, 2, 768);
        comp = widgetToolkit.createComposite((Composite)group, 2, 1, 768);
        this.fTCCoverageHeight = new IntegerFieldEditor(this.fConfigurationPage, "org.eclipse.efm.execution.core.ATTR_TRANSITION_COVERAGE_LOOKAHEAD_DEPTH", "&Depth :", comp, 7);
        this.addField(this.fTCCoverageHeight);
        this.fTCCoverageHeightReachedLimit = new IntegerFieldEditor(this.fConfigurationPage, "org.eclipse.efm.execution.core.ATTR_TRANSITION_COVERAGE_LOOKAHEAD_WIDTH", "&Width :", comp, 42);
        this.addField(this.fTCCoverageHeightReachedLimit);
        Group groupStrategy = widgetToolkit.createGroup((Composite)groupTCHeuristic, "Strategy of Selection of Contexts in the Queue w.r.t. the number of Fireable transitions", 3, 2, 768);
        group = widgetToolkit.createGroup((Composite)groupStrategy, "&Strongly Fireable Transition Selection", 1, 1, 768);
        Composite compGroup = widgetToolkit.createComposite((Composite)group, 2, 1, 768);
        comp = widgetToolkit.createComposite(compGroup, 1, 2, 768);
        this.fTCHitStronglyRandom = new BooleanFieldEditor(this.fConfigurationPage, "org.eclipse.efm.execution.core.ATTR_TRANSITION_COVERAGE_HIT_STRONGLY_RANDOM", "&Hit Random", comp, false);
        this.addField(this.fTCHitStronglyRandom);
        this.fTCHitStronglyCount = new IntegerFieldEditor(this.fConfigurationPage, "org.eclipse.efm.execution.core.ATTR_TRANSITION_COVERAGE_HIT_STRONGLY_COUNT", "&Hit Count :", compGroup, 1);
        this.addField(this.fTCHitStronglyCount);
        group = widgetToolkit.createGroup((Composite)groupStrategy, "&Weakly Fireable Transition Selection", 1, 1, 768);
        compGroup = widgetToolkit.createComposite((Composite)group, 2, 1, 768);
        comp = widgetToolkit.createComposite(compGroup, 1, 2, 768);
        this.fTCHitWeaklyRandom = new BooleanFieldEditor(this.fConfigurationPage, "org.eclipse.efm.execution.core.ATTR_TRANSITION_COVERAGE_HIT_WEAKLY_RANDOM", "&Hit Random", comp, false);
        this.addField(this.fTCHitWeaklyRandom);
        this.fTCHitWeaklyCount = new IntegerFieldEditor(this.fConfigurationPage, "org.eclipse.efm.execution.core.ATTR_TRANSITION_COVERAGE_HIT_WEAKLY_COUNT", "&Hit Count :", compGroup, 1);
        this.addField(this.fTCHitWeaklyCount);
        group = widgetToolkit.createGroup((Composite)groupStrategy, "&Other Fireable Transition Selection", 1, 1, 768);
        compGroup = widgetToolkit.createComposite((Composite)group, 2, 1, 768);
        comp = widgetToolkit.createComposite(compGroup, 1, 2, 768);
        this.fTCHitOtherRandom = new BooleanFieldEditor(this.fConfigurationPage, "org.eclipse.efm.execution.core.ATTR_TRANSITION_COVERAGE_HIT_OTHER_RANDOM", "&Hit Random", comp, false);
        this.addField(this.fTCHitOtherRandom);
        this.fTCHitOtherCount = new IntegerFieldEditor(this.fConfigurationPage, "org.eclipse.efm.execution.core.ATTR_TRANSITION_COVERAGE_HIT_OTHER_COUNT", "&Hit Count :", compGroup, 1);
        this.addField(this.fTCHitOtherCount);
        groupTCHeuristic = widgetToolkit.createGroup(parent, "Second Heuristic Configuration", 2, 1, 768);
        group = widgetToolkit.createGroup((Composite)groupTCHeuristic, "&Directive Trace: Strategy & Limit", 1, 1, 768);
        comp = widgetToolkit.createComposite((Composite)group, 1, 1, 768);
        widgetToolkit.createLabel(comp, "&Heuristic :", 1);
        this.fTCDirectiveTraceHeuristicCombo = widgetToolkit.createCombo(comp, 12, 1, DIRECTIVE_TRACE_HEURISTIC_COMBO_ITEMS);
        this.fTCDirectiveTraceHeuristicCombo.addSelectionListener((SelectionListener)this.fListener);
        this.fTCDirectiveTraceCountLimit = new IntegerFieldEditor(this.fConfigurationPage, "org.eclipse.efm.execution.core.ATTR_TRANSITION_COVERAGE_DIRECTIVE_TRACE_COUNT_LIMIT", "&Count :", comp, 8);
        this.addField(this.fTCDirectiveTraceCountLimit);
        this.fTCDirectiveTraceSizeLimit = new IntegerFieldEditor(this.fConfigurationPage, "org.eclipse.efm.execution.core.ATTR_TRANSITION_COVERAGE_DIRECTIVE_TRACE_SIZE_LIMIT", "&Size :", comp, 8);
        this.addField(this.fTCDirectiveTraceSizeLimit);
    }

    @Override
    protected void setDefaultsImpl(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_TRANSITION_COVERAGE_BEGIN_STEP", 0);
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_TRANSITION_COVERAGE_STOP", true);
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_TRANSITION_COVERAGE_MINIMIZE", true);
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_TRANSITION_COVERAGE_SLICE", true);
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_TRANSITION_COVERAGE_HEURISTIC", true);
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_TRANSITION_COVERAGE_SCOPE", SCOPE_COMBO_ITEM_MODEL);
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_TRANSITION_COVERAGE_HEURISTIC_START", "BASIC");
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_TRANSITION_COVERAGE_HEURISTIC_TRIALS", -1);
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_TRANSITION_COVERAGE_OBJECTIVE_RATE", 100);
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_TRANSITION_COVERAGE_OBJECTIVE_REST", 0);
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_TRANSITION_COVERAGE_DIRECTIVE_TRACE_HEURISTIC", "SMART");
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_TRANSITION_COVERAGE_DIRECTIVE_TRACE_COUNT_LIMIT", 8);
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_TRANSITION_COVERAGE_DIRECTIVE_TRACE_SIZE_LIMIT", 8);
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_TRANSITION_COVERAGE_LOOKAHEAD_DEPTH", 7);
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_TRANSITION_COVERAGE_LOOKAHEAD_WIDTH", 42);
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_TRANSITION_COVERAGE_HIT_STRONGLY_RANDOM", false);
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_TRANSITION_COVERAGE_HIT_STRONGLY_COUNT", 1);
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_TRANSITION_COVERAGE_HIT_WEAKLY_RANDOM", false);
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_TRANSITION_COVERAGE_HIT_WEAKLY_COUNT", 1);
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_TRANSITION_COVERAGE_HIT_OTHER_RANDOM", false);
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_TRANSITION_COVERAGE_HIT_OTHER_COUNT", 1);
    }

    @Override
    protected void initializeFromImpl(ILaunchConfiguration configuration) {
        try {
            this.fTCScope = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_TRANSITION_COVERAGE_SCOPE", SCOPE_COMBO_ITEM_MODEL);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        try {
            if (configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_ENABLED_TRANSITION_COVERAGE_DETAILS_SELECTION", false)) {
                this.fTCScope = SCOPE_COMBO_ITEM_DETAILS;
            } else if (this.fTCScope.equals(SCOPE_COMBO_ITEM_DETAILS)) {
                this.fTCScope = SCOPE_COMBO_ITEM_MODEL;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        switch (this.fTCScope) {
            case "MODEL": {
                this.fTCScopeCombo.select(0);
                break;
            }
            case "INSTANCE": {
                this.fTCScopeCombo.select(1);
                break;
            }
            case "DETAILS": {
                this.fTCScopeCombo.select(2);
                break;
            }
            default: {
                this.fTCScopeCombo.select(0);
            }
        }
        try {
            this.fTCHeuristicStart = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_TRANSITION_COVERAGE_HEURISTIC_START", "BASIC");
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        switch (this.fTCHeuristicStart) {
            case "BASIC": {
                this.fTCHeuristicStartCombo.select(0);
                break;
            }
            case "NAIVE": {
                this.fTCHeuristicStartCombo.select(1);
                break;
            }
            case "SMART": {
                this.fTCHeuristicStartCombo.select(2);
                break;
            }
            case "AGRESSIVE": {
                this.fTCHeuristicStartCombo.select(3);
                break;
            }
            default: {
                this.fTCHeuristicStartCombo.select(0);
            }
        }
        try {
            this.fTCDirectiveTraceHeuristic = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_TRANSITION_COVERAGE_DIRECTIVE_TRACE_HEURISTIC", "SMART");
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        switch (this.fTCDirectiveTraceHeuristic) {
            case "BASIC": {
                this.fTCDirectiveTraceHeuristicCombo.select(0);
                break;
            }
            case "NAIVE": {
                this.fTCDirectiveTraceHeuristicCombo.select(1);
                break;
            }
            case "SMART": {
                this.fTCDirectiveTraceHeuristicCombo.select(2);
                break;
            }
            case "AGRESSIVE": {
                this.fTCDirectiveTraceHeuristicCombo.select(3);
                break;
            }
            default: {
                this.fTCDirectiveTraceHeuristicCombo.select(0);
            }
        }
    }

    @Override
    protected void performApplyImpl(ILaunchConfigurationWorkingCopy configuration) {
        try {
            if (configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_ENABLED_TRANSITION_COVERAGE_DETAILS_SELECTION", false)) {
                this.fTCScope = SCOPE_COMBO_ITEM_DETAILS;
            } else if (this.fTCScope.equals(SCOPE_COMBO_ITEM_DETAILS)) {
                this.fTCScope = SCOPE_COMBO_ITEM_MODEL;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_TRANSITION_COVERAGE_SCOPE", this.fTCScope);
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_TRANSITION_COVERAGE_HEURISTIC_START", this.fTCHeuristicStart);
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_TRANSITION_COVERAGE_DIRECTIVE_TRACE_HEURISTIC", this.fTCDirectiveTraceHeuristic);
    }

    @Override
    protected boolean isValidImpl(ILaunchConfiguration launchConfig) {
        if (!this.fTCBeginStep.isValid()) {
            this.setErrorMessage("Begin Step is not a valid integer");
            return false;
        }
        if (!this.fTCHeuristicTrials.isValid()) {
            this.setErrorMessage("Heuristic Trials is not a valid integer");
            return false;
        }
        if (!this.fTCObjectiveRate.isValid()) {
            this.setErrorMessage("Objective Rate is not a valid integer");
            return false;
        }
        if (!this.fTCObjectiveRest.isValid()) {
            this.setErrorMessage("Objective Rest is not a valid integer");
            return false;
        }
        if (!this.fTCDirectiveTraceCountLimit.isValid()) {
            this.setErrorMessage("Directive Trace Count Limit is not a valid integer");
            return false;
        }
        if (!this.fTCDirectiveTraceSizeLimit.isValid()) {
            this.setErrorMessage("Directive Trace Size Limit is not a valid integer");
            return false;
        }
        if (!this.fTCCoverageHeight.isValid()) {
            this.setErrorMessage("Coverage Height is not a valid integer");
            return false;
        }
        if (!this.fTCCoverageHeightReachedLimit.isValid()) {
            this.setErrorMessage("Coverage Height Reached Limit is not a valid integer");
            return false;
        }
        if (!this.fTCHitStronglyCount.isValid()) {
            this.setErrorMessage("Hit Strongly Count is not a valid integer");
            return false;
        }
        if (!this.fTCHitWeaklyCount.isValid()) {
            this.setErrorMessage("Hit Weakly Count is not a valid integer");
            return false;
        }
        if (!this.fTCHitOtherCount.isValid()) {
            this.setErrorMessage("Hit Other Count is not a valid integer");
            return false;
        }
        return true;
    }

    @Override
    public void handleConfigurationPropertyChange(PropertyChangeEvent event) {
        switch (event.getProperty()) {
            case "org.eclipse.efm.execution.core.ATTR_ENABLED_TRANSITION_COVERAGE_DETAILS_SELECTION": {
                if (!(event.getNewValue() instanceof Boolean)) break;
                if (((Boolean)event.getNewValue()).booleanValue()) {
                    this.fTCScopeCombo.select(2);
                    break;
                }
                this.fTCScopeCombo.select(0);
                break;
            }
        }
    }

    private class TabListener
    extends SelectionAdapter
    implements ModifyListener {
        private TabListener() {
        }

        public void modifyText(ModifyEvent e) {
            ExpertTransitionCoverageConfigurationProfile.this.fConfigurationPage.propagateGUIupdate();
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.getSource() == ExpertTransitionCoverageConfigurationProfile.this.fTCScopeCombo) {
                ExpertTransitionCoverageConfigurationProfile.this.handleScopeSelectionChange();
            } else if (e.getSource() == ExpertTransitionCoverageConfigurationProfile.this.fTCHeuristicStartCombo) {
                ExpertTransitionCoverageConfigurationProfile.this.handleHeuristicStartSelectionChange();
            } else if (e.getSource() == ExpertTransitionCoverageConfigurationProfile.this.fTCDirectiveTraceHeuristicCombo) {
                ExpertTransitionCoverageConfigurationProfile.this.handleDirectiveTraceHeuristicSelectionChange();
            }
        }
    }
}

