/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.lens;

import fr.inria.zvtm.engine.Camera;
import fr.inria.zvtm.engine.View;
import fr.inria.zvtm.engine.ViewPanel;
import fr.inria.zvtm.engine.VirtualSpaceManager;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;

public abstract class Lens {
    public static float MM_FLOOR = 0.001f;
    protected ViewPanel owningView;
    public int w;
    public int h;
    public int sw;
    public int sh;
    public int mbw;
    float hmbw;
    public int mbh;
    float hmbh;
    public int lx = 0;
    public int ly = 0;
    boolean initialized = false;
    public int lensWidth = 0;
    public int lensHeight = 0;
    public BufferedImage mbi;
    public Graphics2D magnifiedGraphics;
    int imageType = 3;
    int transferType = 3;
    int[] oPixelsI;
    int[] mPixelsI;
    int[] tPixelsI;
    short[] oPixelsS;
    short[] mPixelsS;
    short[] tPixelsS;
    byte[] oPixelsB;
    byte[] mPixelsB;
    byte[] tPixelsB;
    float[] gain = new float[2];
    int[] lurd = new int[4];
    public volatile float MM = 2.0f;
    protected float mSwitchThreshold = 1.0f;
    int dx = 0;
    int dy = 0;

    public abstract void setLensBuffer(ViewPanel var1);

    public abstract void gf(float var1, float var2, float[] var3);

    public void setMaximumMagnification(float mm) {
        this.setMaximumMagnification(mm, true);
    }

    public void setMaximumMagnification(float mm, boolean forceRaster) {
        this.MM = mm;
        this.updateMagBufferWorkingDimensions();
        if (forceRaster) {
            this.setMagRasterDimensions(this.mbw, this.mbh);
        }
        this.owningView.parent.repaint();
    }

    public float getMaximumMagnification() {
        return this.MM;
    }

    public float getActualMaximumMagnification() {
        return this.MM;
    }

    public void setBufferThreshold(float t) {
        this.mSwitchThreshold = t;
        this.owningView.parent.repaint();
    }

    public float getBufferThreshold() {
        return this.mSwitchThreshold;
    }

    void initBuffers(int mainBufferSize, int magBufferSize) {
        switch (this.transferType) {
            case 3: {
                this.oPixelsI = new int[mainBufferSize];
                this.mPixelsI = new int[magBufferSize];
                this.tPixelsI = new int[mainBufferSize];
                this.initialized = true;
                break;
            }
            case 1: {
                this.oPixelsS = new short[mainBufferSize];
                this.mPixelsS = new short[magBufferSize];
                this.tPixelsS = new short[mainBufferSize];
                this.initialized = true;
                break;
            }
            case 0: {
                this.oPixelsB = new byte[mainBufferSize];
                this.mPixelsB = new byte[magBufferSize];
                this.tPixelsB = new byte[mainBufferSize];
                this.initialized = true;
                break;
            }
            case 2: {
                this.oPixelsS = new short[mainBufferSize];
                this.mPixelsS = new short[magBufferSize];
                this.tPixelsS = new short[mainBufferSize];
                this.initialized = true;
                break;
            }
            default: {
                this.oPixelsI = new int[mainBufferSize];
                this.mPixelsI = new int[magBufferSize];
                this.tPixelsI = new int[mainBufferSize];
                this.initialized = true;
            }
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void transform(BufferedImage sbi) {
        block8: {
            try {
                switch (this.transferType) {
                    case 3: {
                        this.transformI(sbi.getRaster(), this.mbi.getRaster());
                        break;
                    }
                    case 1: {
                        this.transformS(sbi.getRaster(), this.mbi.getRaster());
                        break;
                    }
                    case 0: {
                        this.transformB(sbi.getRaster(), this.mbi.getRaster());
                        break;
                    }
                    case 2: {
                        this.transformS(sbi.getRaster(), this.mbi.getRaster());
                        break;
                    }
                    default: {
                        this.transformI(sbi.getRaster(), this.mbi.getRaster());
                        break;
                    }
                }
            }
            catch (Exception ex) {
                if (!VirtualSpaceManager.debugModeON()) break block8;
                System.err.println("Lens error probably due to an unsupported screen color depth.");
                ex.printStackTrace();
            }
        }
    }

    abstract void transformI(WritableRaster var1, WritableRaster var2);

    abstract void transformS(WritableRaster var1, WritableRaster var2);

    abstract void transformB(WritableRaster var1, WritableRaster var2);

    public abstract void setAbsolutePosition(int var1, int var2);

    public abstract int getRadius();

    void updateMagBufferWorkingDimensions() {
        this.hmbw = (float)this.getRadius() * this.MM;
        this.hmbh = (float)this.getRadius() * this.MM;
        this.mbw = Math.round(2.0f * this.hmbw);
        this.mbh = Math.round(2.0f * this.hmbh);
    }

    public void setMagRasterDimensions(int size) {
        this.setMagRasterDimensions(size, size);
    }

    public void setMagRasterDimensions(int w, int h) {
        switch (this.transferType) {
            case 3: {
                this.mPixelsI = new int[w * h];
                break;
            }
            case 1: {
                this.mPixelsS = new short[w * h];
                break;
            }
            case 0: {
                this.mPixelsB = new byte[w * h];
                break;
            }
            case 2: {
                this.mPixelsS = new short[w * h];
                break;
            }
            default: {
                this.mPixelsI = new int[w * h];
            }
        }
        this.resetMagnificationBuffer();
        this.mbi = new BufferedImage(w, h, this.imageType);
        this.magnifiedGraphics = this.mbi.createGraphics();
    }

    public void resetMagnificationBuffer() {
        if (this.mbi != null) {
            this.mbi.flush();
            this.mbi = null;
        }
        if (this.magnifiedGraphics != null) {
            this.magnifiedGraphics.dispose();
            this.magnifiedGraphics = null;
        }
    }

    public Graphics2D getMagnificationGraphics() {
        if (this.mbi == null) {
            this.mbi = new BufferedImage(this.mbw, this.mbh, this.imageType);
        }
        if (this.magnifiedGraphics == null) {
            this.magnifiedGraphics = this.mbi.createGraphics();
        }
        return this.magnifiedGraphics;
    }

    public void dispose() {
        this.resetMagnificationBuffer();
    }

    public View getOwningView() {
        return this.owningView.parent;
    }

    public long[] getVisibleRegion(Camera c, long[] res) {
        float uncoef = (float)((c.focal + c.altitude) / c.focal);
        res[0] = (long)(c.vx + (double)((float)(this.lx - this.lensWidth / 2) * uncoef));
        res[1] = (long)(c.vy + (double)((float)(-this.ly + this.lensHeight / 2) * uncoef));
        res[2] = (long)(c.vx + (double)((float)(this.lx + this.lensWidth / 2) * uncoef));
        res[3] = (long)(c.vy + (double)((float)(-this.ly - this.lensHeight / 2) * uncoef));
        return res;
    }

    public void drawBoundary(Graphics2D g2d) {
    }

    public void setXfocusOffset(int x) {
        this.dx = x;
    }

    public void setYfocusOffset(int y) {
        this.dy = y;
    }

    public int getXfocusOffset() {
        return this.dx;
    }

    public int getYfocusOffset() {
        return this.dy;
    }

    public abstract void setFocusControlled(boolean var1, short var2);

    public abstract void setFocusControlled(boolean var1);

    public abstract void moveLensBy(int var1, int var2, long var3);
}

