/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.execution.configuration.common.ui.api;

import org.eclipse.core.runtime.Assert;
import org.eclipse.efm.execution.configuration.common.ui.api.AbstractSectionPart;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public interface IWidgetToolkit {
    public void setVisibleAndEnabled(Composite var1, boolean var2);

    default public void propagateVisibility(Composite aComposite, boolean visible) {
        aComposite.setVisible(visible);
        Object gd = aComposite.getLayoutData();
        if (gd instanceof GridData) {
            GridData data = (GridData)gd;
            data.exclude = !visible;
            aComposite.requestLayout();
        }
    }

    public void createSectionPart(AbstractSectionPart var1, Composite var2, int var3, IToolBarManager var4);

    public CTabFolder createTabFolder(Composite var1, int var2);

    public Composite newComposite(Composite var1);

    public Composite newComposite(Composite var1, int var2);

    default public Composite createComposite(Composite parent) {
        return this.createComposite(parent, 1, 1, 768);
    }

    default public Composite createComposite(Composite parent, int style) {
        return this.createComposite(parent, style, 1, 1, 768);
    }

    default public Composite createComposite(Composite parent, int columns, int hspan, int fill) {
        Composite composite = this.newComposite(parent);
        composite.setLayout((Layout)new GridLayout(columns, false));
        composite.setFont(parent.getFont());
        GridData gd = new GridData(fill);
        gd.horizontalSpan = hspan;
        composite.setLayoutData((Object)gd);
        return composite;
    }

    default public Composite createComposite(Composite parent, int style, int columns, int hspan, int fill) {
        Composite composite = this.newComposite(parent, style);
        composite.setLayout((Layout)new GridLayout(columns, false));
        composite.setFont(parent.getFont());
        GridData gd = new GridData(fill);
        gd.horizontalSpan = hspan;
        composite.setLayoutData((Object)gd);
        return composite;
    }

    default public Composite createComposite(Composite parent, Font font, int columns, int hspan, int fill) {
        Composite gcomposite = this.newComposite(parent);
        gcomposite.setLayout((Layout)new GridLayout(columns, false));
        gcomposite.setFont(font);
        GridData gd = new GridData(fill);
        gd.horizontalSpan = hspan;
        gcomposite.setLayoutData((Object)gd);
        return gcomposite;
    }

    default public Composite createComposite(Composite parent, Font font, int columns, int hspan, int fill, int marginwidth, int marginheight) {
        Composite composite = this.newComposite(parent);
        GridLayout layout = new GridLayout(columns, false);
        layout.marginWidth = marginwidth;
        layout.marginHeight = marginheight;
        composite.setLayout((Layout)layout);
        composite.setFont(font);
        GridData gd = new GridData(fill);
        gd.horizontalSpan = hspan;
        composite.setLayoutData((Object)gd);
        return composite;
    }

    default public Composite createComposite(Composite parent, int style, Font font, int columns, int hspan, int fill, int marginwidth, int marginheight) {
        Composite composite = this.newComposite(parent, style);
        GridLayout layout = new GridLayout(columns, false);
        layout.marginWidth = marginwidth;
        layout.marginHeight = marginheight;
        composite.setLayout((Layout)layout);
        composite.setFont(font);
        GridData gd = new GridData(fill);
        gd.horizontalSpan = hspan;
        composite.setLayoutData((Object)gd);
        return composite;
    }

    public ScrolledComposite newScrolledComposite(Composite var1, int var2);

    default public ScrolledComposite createScrolledComposite(Composite parent) {
        ScrolledComposite scrolledComposite = this.newScrolledComposite(parent, 768);
        scrolledComposite.setFont(parent.getFont());
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setShowFocusedControl(true);
        return scrolledComposite;
    }

    default public ViewForm createViewForm(Composite parent, int style) {
        ViewForm viewForm = new ViewForm(parent, 0x800800);
        viewForm.setLayoutData((Object)new GridData(1808));
        return viewForm;
    }

    default public Group newGroup(Composite parent) {
        return this.newGroup(parent, parent.getStyle());
    }

    public Group newGroup(Composite var1, int var2);

    default public Group createGroup(Composite parent, String text, int columns, int hspan, int fill) {
        Group group = this.newGroup(parent, parent.getStyle());
        group.setLayout((Layout)new GridLayout(columns, false));
        if (text != null) {
            group.setText(text);
        }
        group.setFont(parent.getFont());
        GridData gd = new GridData(fill);
        gd.horizontalSpan = hspan;
        group.setLayoutData((Object)gd);
        return group;
    }

    public Button newButton(Composite var1, String var2, int var3);

    default public int getButtonWidthHint(Button button) {
        PixelConverter converter = new PixelConverter((Control)button);
        int widthHint = converter.convertHorizontalDLUsToPixels(61);
        return Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
    }

    default public void setButtonDimensionHint(Button button) {
        Assert.isNotNull((Object)button);
        Object gd = button.getLayoutData();
        if (gd instanceof GridData) {
            ((GridData)gd).widthHint = this.getButtonWidthHint(button);
            ((GridData)gd).horizontalAlignment = 4;
        }
    }

    default public Button createRadioButton(Composite parent, String text) {
        Button button = this.newButton(parent, text, 16);
        button.setFont(parent.getFont());
        GridData gd = new GridData();
        button.setLayoutData((Object)gd);
        this.setButtonDimensionHint(button);
        return button;
    }

    default public Button createPushButton(Composite parent, String text, Image image) {
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        if (image != null) {
            button.setImage(image);
        }
        if (text != null) {
            button.setText(text);
        }
        GridData gd = new GridData();
        button.setLayoutData((Object)gd);
        this.setButtonDimensionHint(button);
        return button;
    }

    public Combo newCombo(Composite var1, int var2);

    default public Combo createCombo(Composite parent, int style, int hspan, String[] items) {
        Combo combo = this.newCombo(parent, style);
        combo.setFont(parent.getFont());
        GridData gd = new GridData(768);
        gd.horizontalSpan = hspan;
        combo.setLayoutData((Object)gd);
        if (items != null) {
            combo.setItems(items);
        }
        combo.setVisibleItemCount(30);
        combo.select(0);
        return combo;
    }

    public Label newLabel(Composite var1, String var2);

    public Label newLabel(Composite var1, String var2, int var3);

    default public Label createLabel(Composite parent, String text, int hspan) {
        Label label = this.newLabel(parent, text);
        label.setFont(parent.getFont());
        if (text != null) {
            label.setText(text);
        }
        GridData gd = new GridData(768);
        gd.horizontalSpan = hspan;
        gd.grabExcessHorizontalSpace = false;
        label.setLayoutData((Object)gd);
        return label;
    }

    public Text newText(Composite var1, String var2, int var3);

    default public Text createText(Composite parent, int style, int hspan) {
        Text text = this.newText(parent, null, style);
        text.setFont(parent.getFont());
        GridData gd = new GridData(768);
        gd.horizontalSpan = hspan;
        text.setLayoutData((Object)gd);
        return text;
    }

    default public Text createSingleText(Composite parent, int hspan) {
        Text t = this.newText(parent, null, 2052);
        t.setFont(parent.getFont());
        GridData gd = new GridData(768);
        gd.horizontalSpan = hspan;
        t.setLayoutData((Object)gd);
        return t;
    }
}

