/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.krazo.binding.convert;

import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.mvc.MvcContext;
import jakarta.mvc.binding.BindingError;
import jakarta.mvc.binding.MvcBinding;
import jakarta.ws.rs.CookieParam;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.MatrixParam;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.ext.ParamConverter;
import jakarta.ws.rs.ext.ParamConverterProvider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.stream.Stream;
import org.eclipse.krazo.binding.BindingErrorImpl;
import org.eclipse.krazo.binding.BindingResultImpl;
import org.eclipse.krazo.binding.convert.ConverterRegistry;
import org.eclipse.krazo.binding.convert.ConverterResult;
import org.eclipse.krazo.binding.convert.MvcConverter;

@Priority(value=0)
public class MvcConverterProvider
implements ParamConverterProvider {
    @Inject
    private ConverterRegistry converterRegistry;
    @Inject
    private MvcContext mvcContext;
    @Inject
    private BindingResultImpl bindingResult;

    public <T> ParamConverter<T> getConverter(final Class<T> rawType, Type genericType, final Annotation[] annotations) {
        MvcConverter<T> mvcConverter;
        MvcBinding mvcBinding = Stream.of(annotations != null ? annotations : new Annotation[]{}).filter(a -> a.annotationType().equals(MvcBinding.class)).findFirst().orElse(null);
        if (mvcBinding != null && (mvcConverter = this.converterRegistry.lookup(rawType, annotations)) != null) {
            return new ParamConverter<T>(){

                public T fromString(String value) {
                    ConverterResult result = mvcConverter.convert(value, rawType, annotations, MvcConverterProvider.this.mvcContext.getLocale());
                    result.getError().map(error -> new BindingErrorImpl((String)error, MvcConverterProvider.getParamName(annotations), value)).ifPresent(bindingError -> MvcConverterProvider.this.bindingResult.addBindingError((BindingError)bindingError));
                    return result.getValue();
                }

                public String toString(T value) {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return null;
    }

    private static String getParamName(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (annotation instanceof QueryParam) {
                return ((QueryParam)annotation).value();
            }
            if (annotation instanceof PathParam) {
                return ((PathParam)annotation).value();
            }
            if (annotation instanceof FormParam) {
                return ((FormParam)annotation).value();
            }
            if (annotation instanceof MatrixParam) {
                return ((MatrixParam)annotation).value();
            }
            if (!(annotation instanceof CookieParam)) continue;
            return ((CookieParam)annotation).value();
        }
        return null;
    }
}

