/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.InjectionCapable;
import com.sun.enterprise.deployment.InjectionTarget;
import com.sun.enterprise.deployment.MetadataSource;
import com.sun.enterprise.deployment.runtime.application.wls.ApplicationParam;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.web.ContextParameter;
import com.sun.enterprise.deployment.web.EnvironmentEntry;
import com.sun.enterprise.deployment.web.InitializationParameter;
import com.sun.enterprise.deployment.web.WebDescriptor;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.glassfish.deployment.common.Descriptor;
import org.glassfish.internal.api.RelativePathResolver;

public class EnvironmentProperty
extends Descriptor
implements InitializationParameter,
ContextParameter,
ApplicationParam,
WebDescriptor,
EnvironmentEntry,
InjectionCapable {
    private String value;
    private String type;
    private Object valueObject;
    private boolean setValueCalled = false;
    private Set<InjectionTarget> injectionTargets;
    private static Class[] allowedTypes = new Class[]{Integer.TYPE, Boolean.TYPE, Double.TYPE, Float.TYPE, Long.TYPE, Short.TYPE, Byte.TYPE, Character.TYPE, String.class, Boolean.class, Integer.class, Double.class, Byte.class, Short.class, Long.class, Float.class, Character.class, Class.class};
    static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(EnvironmentProperty.class);
    protected String mappedName;
    protected String lookupName;

    public EnvironmentProperty() {
    }

    public EnvironmentProperty(String name, String value, String description) {
        this(name, value, description, null);
    }

    public EnvironmentProperty(String name, String value, String description, String type) {
        super(name, description);
        this.value = value;
        this.checkType(type);
        this.type = type;
    }

    @Override
    public String getValue() {
        if (this.value == null) {
            this.value = "";
        }
        return this.value;
    }

    public String getResolvedValue() {
        return RelativePathResolver.resolvePath((String)this.getValue());
    }

    public Object getResolvedValueObject() {
        if (this.valueObject == null) {
            this.valueObject = "";
        }
        return this.getObjectFromString(this.getResolvedValue(), this.getValueType());
    }

    private void checkType(String type) {
        if (type != null) {
            Class<?> typeClass = null;
            try {
                typeClass = Class.forName(type, true, Thread.currentThread().getContextClassLoader());
            }
            catch (Throwable t) {
                if (Descriptor.isBoundsChecking()) {
                    throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptiontypenotallowedpropertytype", "{0} is not an allowed property value type", new Object[]{type}));
                }
                return;
            }
            boolean allowedType = false;
            for (Class allowedType2 : allowedTypes) {
                if (!allowedType2.equals(typeClass)) continue;
                allowedType = true;
                break;
            }
            if (typeClass != null && typeClass.isEnum()) {
                allowedType = true;
            }
            if (Descriptor.isBoundsChecking() && !allowedType) {
                throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptiontypenotallowedprprtytype", "{0} is not an allowed property value type", new Object[]{type}));
            }
        }
    }

    public Object getValueObject() {
        if (this.valueObject == null) {
            this.valueObject = "";
        }
        return this.getObjectFromString(this.getValue(), this.getValueType());
    }

    public Class getValueType() {
        if (this.type == null) {
            return String.class;
        }
        try {
            return Class.forName(this.type, true, Thread.currentThread().getContextClassLoader());
        }
        catch (Throwable t) {
            return null;
        }
    }

    @Override
    public void setType(String type) {
        this.checkType(type);
        this.type = type;
    }

    private String convertPrimitiveTypes(String type) {
        if (type == null) {
            return type;
        }
        if (type.equals("int")) {
            return "java.lang.Integer";
        }
        if (type.equals("boolean")) {
            return "java.lang.Boolean";
        }
        if (type.equals("double")) {
            return "java.lang.Double";
        }
        if (type.equals("float")) {
            return "java.lang.Float";
        }
        if (type.equals("long")) {
            return "java.lang.Long";
        }
        if (type.equals("short")) {
            return "java.lang.Short";
        }
        if (type.equals("byte")) {
            return "java.lang.Byte";
        }
        if (type.equals("char")) {
            return "java.lang.Character";
        }
        return type;
    }

    @Override
    public String getType() {
        if (this.type == null && Descriptor.isBoundsChecking()) {
            return String.class.getName();
        }
        this.type = this.convertPrimitiveTypes(this.type);
        return this.type;
    }

    public void setMappedName(String mName) {
        this.mappedName = mName;
    }

    public String getMappedName() {
        return this.mappedName != null ? this.mappedName : "";
    }

    public void setLookupName(String lName) {
        this.lookupName = lName;
    }

    public String getLookupName() {
        return this.lookupName != null ? this.lookupName : "";
    }

    public boolean hasLookupName() {
        return this.lookupName != null && this.lookupName.length() > 0;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
        this.setValueCalled = true;
    }

    public boolean isSetValueCalled() {
        return this.setValueCalled;
    }

    public boolean hasAValue() {
        return this.setValueCalled || this.hasLookupName() || this.getMappedName().length() > 0;
    }

    public boolean equals(Object other) {
        return other instanceof EnvironmentProperty && this.getName().equals(((EnvironmentProperty)other).getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public void print(StringBuffer toStringBuffer) {
        toStringBuffer.append("Env-Prop: ").append(super.getName()).append("@");
        this.printInjectableResourceInfo(toStringBuffer);
        toStringBuffer.append("@").append(this.getType()).append("@").append(this.getValue()).append("@").append("@").append(super.getDescription());
    }

    private Object getObjectFromString(String string, Class type) {
        Object obj;
        if (type == null && !Descriptor.isBoundsChecking() && (obj = this.getValueObjectUsingAllowedTypes(string)) != null) {
            return obj;
        }
        if (string == null || "".equals(string) && !type.equals(String.class)) {
            return null;
        }
        try {
            if (String.class.equals((Object)type)) {
                return string;
            }
            if (Boolean.class.equals((Object)type)) {
                return Boolean.valueOf(string);
            }
            if (Integer.class.equals((Object)type)) {
                return Integer.valueOf(string);
            }
            if (Double.class.equals((Object)type)) {
                return Double.valueOf(string);
            }
            if (Float.class.equals((Object)type)) {
                return Float.valueOf(string);
            }
            if (Short.class.equals((Object)type)) {
                return Short.valueOf(string);
            }
            if (Byte.class.equals((Object)type)) {
                return Byte.valueOf(string);
            }
            if (Long.class.equals((Object)type)) {
                return Long.valueOf(string);
            }
            if (Character.class.equals((Object)type)) {
                if (string.length() != 1) {
                    throw new IllegalArgumentException();
                }
                return Character.valueOf(string.charAt(0));
            }
            if (Class.class.equals((Object)type)) {
                return Class.forName(string, true, Thread.currentThread().getContextClassLoader());
            }
            if (type != null && type.isEnum()) {
                return Enum.valueOf(type, string);
            }
        }
        catch (Throwable t) {
            throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptioncouldnotcreateinstancetype", "Could not create instance of {0} from {1}\n reason: {2}" + t, new Object[]{type, string, t}));
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionillegaltypeenvproperty", "Illegal type for environment properties: {0}", new Object[]{type}));
    }

    private Object getValueObjectUsingAllowedTypes(String string) throws IllegalArgumentException {
        if (this.type.equals(Integer.TYPE.getName())) {
            return Integer.valueOf(string);
        }
        if (this.type.equals(Long.TYPE.getName())) {
            return Long.valueOf(string);
        }
        if (this.type.equals(Short.TYPE.getName())) {
            return Short.valueOf(string);
        }
        if (this.type.equals(Boolean.TYPE.getName())) {
            return Boolean.valueOf(string);
        }
        if (this.type.equals(Float.TYPE.getName())) {
            return Float.valueOf(string);
        }
        if (this.type.equals(Double.TYPE.getName())) {
            return Double.valueOf(string);
        }
        if (this.type.equals(Byte.TYPE.getName())) {
            return Byte.valueOf(string);
        }
        if (this.type.equals(Character.TYPE.getName())) {
            if (string.length() != 1) {
                throw new IllegalArgumentException();
            }
            return Character.valueOf(string.charAt(0));
        }
        return null;
    }

    public boolean isConflict(EnvironmentProperty other) {
        return this.getName().equals(other.getName()) && (!DOLUtils.equals(this.getType(), other.getType()) || !this.getValue().equals(other.getValue()) || this.isConflictResourceGroup(other));
    }

    protected boolean isConflictResourceGroup(EnvironmentProperty other) {
        return !this.getLookupName().equals(other.getLookupName()) || !this.getMappedName().equals(other.getMappedName());
    }

    @Override
    public void addInjectionTarget(InjectionTarget target) {
        if (this.injectionTargets == null) {
            this.injectionTargets = new HashSet<InjectionTarget>();
        }
        boolean found = false;
        for (InjectionTarget injTarget : this.injectionTargets) {
            if (!injTarget.equals(target)) continue;
            found = true;
            break;
        }
        if (!found) {
            this.injectionTargets.add(target);
        }
    }

    @Override
    public Set<InjectionTarget> getInjectionTargets() {
        return this.injectionTargets != null ? this.injectionTargets : new HashSet<InjectionTarget>();
    }

    @Override
    public boolean isInjectable() {
        return this.injectionTargets != null && this.injectionTargets.size() > 0;
    }

    public boolean hasInjectionTargetFromXml() {
        boolean fromXml;
        block1: {
            InjectionTarget injTarget;
            fromXml = false;
            if (this.injectionTargets == null) break block1;
            Iterator<InjectionTarget> iterator = this.injectionTargets.iterator();
            while (iterator.hasNext() && !(fromXml = MetadataSource.XML == (injTarget = iterator.next()).getMetadataSource())) {
            }
        }
        return fromXml;
    }

    @Override
    public String getComponentEnvName() {
        return this.getName();
    }

    @Override
    public String getInjectResourceType() {
        return this.type;
    }

    @Override
    public void setInjectResourceType(String resourceType) {
        this.type = this.convertPrimitiveTypes(resourceType);
    }

    public StringBuffer printInjectableResourceInfo(StringBuffer toStringBuffer) {
        if (this.isInjectable()) {
            for (InjectionTarget target : this.getInjectionTargets()) {
                if (target.isFieldInjectable()) {
                    toStringBuffer.append("Field-Injectable Resource. Class name = ").append(target.getClassName()).append(" Field name=").append(target.getFieldName());
                    continue;
                }
                toStringBuffer.append("Method-Injectable Resource. Class name =").append(target.getClassName()).append(" Method =").append(target.getMethodName());
            }
        } else {
            toStringBuffer.append("Non-Injectable Resource");
        }
        return toStringBuffer;
    }
}

