/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.internal.toolkit.util;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ClassDocCatalog {
    private Set packageSet;
    private Map allClasses;
    private Map ordinaryClasses;
    private Map exceptions;
    private Map enums;
    private Map annotationTypes;
    private Map errors;
    private Map interfaces;

    public ClassDocCatalog(ClassDoc[] classDocArray) {
        this.init();
        for (int i = 0; i < classDocArray.length; ++i) {
            this.addClassDoc(classDocArray[i]);
        }
    }

    public ClassDocCatalog() {
        this.init();
    }

    private void init() {
        this.allClasses = new HashMap();
        this.ordinaryClasses = new HashMap();
        this.exceptions = new HashMap();
        this.enums = new HashMap();
        this.annotationTypes = new HashMap();
        this.errors = new HashMap();
        this.interfaces = new HashMap();
        this.packageSet = new HashSet();
    }

    public void addClassDoc(ClassDoc classDoc) {
        if (classDoc == null) {
            return;
        }
        this.addClass(classDoc, this.allClasses);
        if (classDoc.isOrdinaryClass()) {
            this.addClass(classDoc, this.ordinaryClasses);
        } else if (classDoc.isException()) {
            this.addClass(classDoc, this.exceptions);
        } else if (classDoc.isEnum()) {
            this.addClass(classDoc, this.enums);
        } else if (classDoc.isAnnotationType()) {
            this.addClass(classDoc, this.annotationTypes);
        } else if (classDoc.isError()) {
            this.addClass(classDoc, this.errors);
        } else if (classDoc.isInterface()) {
            this.addClass(classDoc, this.interfaces);
        }
    }

    private void addClass(ClassDoc classDoc, Map map) {
        PackageDoc packageDoc = classDoc.containingPackage();
        if (packageDoc.isIncluded()) {
            return;
        }
        String string = Util.getPackageName(packageDoc);
        HashSet<ClassDoc> hashSet = (HashSet<ClassDoc>)map.get(string);
        if (hashSet == null) {
            this.packageSet.add(string);
            hashSet = new HashSet<ClassDoc>();
        }
        hashSet.add(classDoc);
        map.put(string, hashSet);
    }

    private ClassDoc[] getArray(Map map, String string) {
        Set set = (Set)map.get(string);
        if (set == null) {
            return new ClassDoc[0];
        }
        return set.toArray(new ClassDoc[0]);
    }

    public ClassDoc[] allClasses(PackageDoc packageDoc) {
        return packageDoc.isIncluded() ? packageDoc.allClasses() : this.getArray(this.allClasses, Util.getPackageName(packageDoc));
    }

    public ClassDoc[] allClasses(String string) {
        return this.getArray(this.allClasses, string);
    }

    public String[] packageNames() {
        return this.packageSet.toArray(new String[0]);
    }

    public boolean isKnownPackage(String string) {
        return this.packageSet.contains(string);
    }

    public ClassDoc[] errors(String string) {
        return this.getArray(this.errors, string);
    }

    public ClassDoc[] exceptions(String string) {
        return this.getArray(this.exceptions, string);
    }

    public ClassDoc[] enums(String string) {
        return this.getArray(this.enums, string);
    }

    public ClassDoc[] annotationTypes(String string) {
        return this.getArray(this.annotationTypes, string);
    }

    public ClassDoc[] interfaces(String string) {
        return this.getArray(this.interfaces, string);
    }

    public ClassDoc[] ordinaryClasses(String string) {
        return this.getArray(this.ordinaryClasses, string);
    }
}

