/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.python.py4j.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.ease.AbstractScriptEngine;
import org.eclipse.ease.Logger;
import org.eclipse.ease.Script;
import org.eclipse.ease.ScriptEngineException;
import org.eclipse.ease.ScriptExecutionException;
import org.eclipse.ease.lang.python.PythonHelper;
import org.eclipse.ease.lang.python.py4j.internal.Activator;
import org.eclipse.ease.lang.python.py4j.internal.IInteractiveReturn;
import org.eclipse.ease.lang.python.py4j.internal.IPythonSideEngine;
import org.eclipse.ease.tools.RunnableWithResult;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;
import py4j.ClientServer;
import py4j.JavaServer;

public class Py4jScriptEngine
extends AbstractScriptEngine {
    public static final String ENGINE_ID = "org.eclipse.ease.lang.python.py4j.engine";
    private static final int PYTHON_STARTUP_TIMEOUT_SECONDS = 10;
    private static final int PYTHON_SHUTDOWN_TIMEOUT_SECONDS = 10;
    private static final String PYSRC_EASE_PY4J_MAIN_PY = "/pysrc/ease_py4j_main.py";
    private static final String PY4J_PYTHON_BUNDLE_ID = "py4j-python";
    private ClientServer fGatewayServer;
    protected IPythonSideEngine fPythonSideEngine;
    private Process fPythonProcess;
    private Thread fInputGobbler;
    private Thread fErrorGobbler;
    private CountDownLatch fPythonStartupComplete;

    public Py4jScriptEngine() {
        super("Python (Py4J)");
    }

    protected void setupEngine() throws ScriptEngineException {
        try {
            this.fPythonStartupComplete = new CountDownLatch(1);
            this.fGatewayServer = new ClientServer.ClientServerBuilder((Object)this).javaPort(0).pythonPort(0).build();
            this.fGatewayServer.startServer(true);
            int javaListeningPort = ((JavaServer)this.fGatewayServer.getJavaServer()).getListeningPort();
            this.fPythonProcess = this.startPythonProcess(javaListeningPort);
            this.fInputGobbler = new Thread((Runnable)new StreamGobbler(this.fPythonProcess.getInputStream(), this.getOutputStream(), "stdout"), "EASE py4j engine output stream gobbler");
            this.fInputGobbler.start();
            this.fErrorGobbler = new Thread((Runnable)new StreamGobbler(this.fPythonProcess.getErrorStream(), this.getErrorStream(), "stderr"), "EASE py4j engine error stream gobbler");
            this.fErrorGobbler.start();
            if (!this.fPythonStartupComplete.await(10L, TimeUnit.SECONDS)) {
                throw new ScriptEngineException("Python process did not start within 10 seconds");
            }
        }
        catch (ScriptEngineException e) {
            this.teardownEngine();
            throw e;
        }
        catch (Exception e) {
            this.teardownEngine();
            throw new ScriptEngineException("Failed to start Python process. Please check the setting for the Python interpreter in Preferences -> Scripting -> Python Scripting:\n" + e.getMessage(), (Throwable)e);
        }
    }

    private Process startPythonProcess(int javaListeningPort) throws IOException, MalformedURLException, URISyntaxException, CoreException {
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.environment().put("PYTHONPATH", this.getPy4jPythonSrc().toString());
        String interpreter = Activator.getDefault().getPreferenceStore().getString("org.eclipse.ease.lang.python.py4j.INTERPRETER");
        IStringVariableManager variableManager = VariablesPlugin.getDefault().getStringVariableManager();
        interpreter = variableManager.performStringSubstitution(interpreter);
        pb.command().add(interpreter);
        pb.command().add("-u");
        pb.command().add(this.getPy4jEaseMainPy().toString());
        pb.command().add(Integer.toString(javaListeningPort));
        Process start = pb.start();
        return start;
    }

    private File getPy4jPythonSrc() throws IOException {
        File py4jPythonBundleFile = FileLocator.getBundleFile((Bundle)Platform.getBundle((String)PY4J_PYTHON_BUNDLE_ID));
        File py4jPythonSrc = new File(py4jPythonBundleFile, "/src");
        File py4j = new File(py4jPythonSrc, "py4j");
        if (!py4j.exists() || !py4j.isDirectory()) {
            throw new IOException("Failed to find py4j python directory, expected it here: " + py4j);
        }
        return py4jPythonSrc;
    }

    private File getPy4jEaseMainPy() throws MalformedURLException, IOException, URISyntaxException {
        URL url = new URL("platform:/plugin/org.eclipse.ease.lang.python.py4j/pysrc/ease_py4j_main.py");
        URL fileURL = FileLocator.toFileURL((URL)url);
        File py4jEaseMain = new File(URIUtil.toURI((URL)fileURL));
        if (!py4jEaseMain.exists()) {
            throw new IOException("Failed to find /pysrc/ease_py4j_main.py, expected it here: " + py4jEaseMain);
        }
        return py4jEaseMain;
    }

    public void pythonStartupComplete(int pythonPort, IPythonSideEngine pythonSideEngine) {
        JavaServer javaServer = (JavaServer)this.fGatewayServer.getJavaServer();
        javaServer.resetCallbackClient(javaServer.getCallbackClient().getAddress(), pythonPort);
        this.fPythonSideEngine = pythonSideEngine;
        this.fPythonStartupComplete.countDown();
    }

    protected Object execute(final Script script, Object reference, final String fileName, boolean uiThread) throws Throwable {
        if (uiThread) {
            RunnableWithResult<Object> runnable = new RunnableWithResult<Object>(){

                public void runWithTry() throws Throwable {
                    this.setResult(Py4jScriptEngine.this.internalExecute(script, fileName));
                }
            };
            Display.getDefault().syncExec((Runnable)runnable);
            return runnable.getResultFromTry();
        }
        return this.internalExecute(script, fileName);
    }

    private Object internalExecute(Script script, String fileName) throws Throwable, Exception {
        IInteractiveReturn interactiveReturn;
        if (script.isShellMode()) {
            interactiveReturn = this.fPythonSideEngine.executeInteractive(script.getCode());
        } else {
            String code = script.getCode();
            interactiveReturn = this.fPythonSideEngine.executeScript(code, fileName);
        }
        Object exception = interactiveReturn.getException();
        if (exception instanceof Throwable) {
            throw (Throwable)exception;
        }
        if (exception != null) {
            throw new ScriptExecutionException(exception.toString(), 0, null, null, Collections.emptyList(), null);
        }
        return interactiveReturn.getResult();
    }

    public void terminateCurrent() {
        if (this.fPythonProcess != null) {
            this.fPythonProcess.destroyForcibly();
        }
    }

    protected void teardownEngine() throws ScriptEngineException {
        if (this.fPythonProcess != null) {
            this.fPythonProcess.destroy();
            try {
                this.fPythonProcess.waitFor(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
        if (this.fGatewayServer != null) {
            this.fGatewayServer.shutdown();
        }
        if (this.fPythonProcess != null) {
            this.fPythonProcess.destroyForcibly();
        }
        try {
            if (this.fInputGobbler != null) {
                this.fInputGobbler.join();
            }
            if (this.fErrorGobbler != null) {
                this.fErrorGobbler.join();
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    public String getSaveVariableName(String name) {
        return PythonHelper.getSaveName((String)name);
    }

    public void registerJar(URL url) {
        throw new UnsupportedOperationException();
    }

    protected Object internalGetVariable(String name) {
        return this.fPythonSideEngine.internalGetVariable(name);
    }

    protected Map<String, Object> internalGetVariables() {
        return this.fPythonSideEngine.internalGetVariables();
    }

    protected boolean internalHasVariable(String name) {
        return this.fPythonSideEngine.internalHasVariable(name);
    }

    protected void internalSetVariable(String name, Object content) {
        this.fPythonSideEngine.internalSetVariable(name, content);
    }

    protected Object internalRemoveVariable(String name) {
        throw new UnsupportedOperationException();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isInstance(this.fPythonProcess)) {
            return (T)this.fPythonProcess;
        }
        return (T)super.getAdapter(adapter);
    }

    private static class StreamGobbler
    implements Runnable {
        private final InputStream fReader;
        private final OutputStream fWriter;
        private String fStreamName;

        public StreamGobbler(InputStream stream, OutputStream output, String streamName) {
            this.fReader = stream;
            this.fWriter = output;
            this.fStreamName = streamName;
        }

        @Override
        public void run() {
            try {
                int readCount;
                byte[] bytes = new byte[512];
                while ((readCount = this.fReader.read(bytes)) >= 0) {
                    try {
                        this.fWriter.write(bytes, 0, readCount);
                    }
                    catch (IOException e) {
                        Logger.error((String)"org.eclipse.ease.lang.python.py4j", (String)("Failed to write data read from Python's " + this.fStreamName + " stream."), (Throwable)e);
                    }
                }
            }
            catch (IOException e) {
                Logger.error((String)"org.eclipse.ease.lang.python.py4j", (String)("Failed to read data from Python's " + this.fStreamName + " stream."), (Throwable)e);
            }
        }
    }
}

