/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.python.jython;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ease.AbstractScriptEngine;
import org.eclipse.ease.Script;
import org.eclipse.ease.ScriptEngineException;
import org.eclipse.ease.lang.python.PythonHelper;
import org.eclipse.ease.lang.python.jython.Activator;
import org.eclipse.ease.lang.python.jython.JythonTracer;
import org.eclipse.ease.tools.RunnableWithResult;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.python.core.CompileMode;
import org.python.core.CompilerFlags;
import org.python.core.Py;
import org.python.core.PyBoolean;
import org.python.core.PyFloat;
import org.python.core.PyFunction;
import org.python.core.PyIgnoreMethodTag;
import org.python.core.PyInteger;
import org.python.core.PyJavaPackage;
import org.python.core.PyJavaType;
import org.python.core.PyList;
import org.python.core.PyLong;
import org.python.core.PyNone;
import org.python.core.PyObject;
import org.python.core.PyObjectDerived;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.util.InteractiveInterpreter;

public class JythonScriptEngine
extends AbstractScriptEngine {
    protected InteractiveInterpreter mEngine;
    private PyObject mResult;

    public JythonScriptEngine() {
        super("Jython");
    }

    public void terminateCurrent() {
        Job terminationJob = new Job("Termination Jython script"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    JythonScriptEngine.this.getEngine().getSystemState().callExitFunc();
                }
                catch (PyIgnoreMethodTag e) {
                    throw new RuntimeException(e);
                }
                return Status.OK_STATUS;
            }
        };
        terminationJob.setSystem(true);
        terminationJob.schedule();
    }

    protected void setupEngine() throws ScriptEngineException {
        this.mEngine = new InteractiveInterpreter();
        DisplayHook displayHook = new DisplayHook();
        this.getEngine().getSystemState().__displayhook__ = displayHook;
        this.getEngine().getSystemState().__dict__.__setitem__("displayhook", (PyObject)displayHook);
        this.getEngine().getSystemState().__setattr__("_jy_interpreter", Py.java2py((Object)this.getEngine()));
        this.getEngine().getSystemState().path.insert(0, (PyObject)Py.EmptyString);
        this.setOutputStream(this.getOutputStream());
        this.setInputStream(this.getInputStream());
        this.setErrorStream(this.getErrorStream());
        for (String libraryPath : this.getPythonLibraries()) {
            PyString element;
            PyList systemPath;
            if (libraryPath == null || libraryPath.isEmpty() || (systemPath = this.getEngine().getSystemState().path).contains((Object)(element = new PyString(libraryPath)))) continue;
            systemPath.add(0, (Object)element);
        }
        this.getEngine().getSystemState().settrace((PyObject)new JythonTracer());
    }

    protected void teardownEngine() throws ScriptEngineException {
    }

    protected Object execute(final Script script, final Object reference, final String fileName, boolean uiThread) throws Throwable {
        if (uiThread) {
            RunnableWithResult<Object> runnable = new RunnableWithResult<Object>(){

                public void runWithTry() throws Throwable {
                    this.setResult(JythonScriptEngine.this.internalExecute(script, reference, fileName));
                }
            };
            Display.getDefault().syncExec((Runnable)runnable);
            return runnable.getResultFromTry();
        }
        return this.internalExecute(script, reference, fileName);
    }

    protected Object internalExecute(Script script, Object reference, String fileName) throws Exception {
        this.mResult = Py.None;
        PyObject code = Py.compile_command_flags((String)script.getCode(), (String)"(none)", (CompileMode)CompileMode.exec, (CompilerFlags)new CompilerFlags(), (boolean)true);
        if (code == Py.None) {
            throw new RuntimeException("Could not compile code");
        }
        Object file = script.getFile();
        File f = null;
        if (file instanceof IFile) {
            f = ((IFile)file).getLocation().toFile();
        } else if (file instanceof File) {
            f = (File)file;
        }
        PyString newString = null;
        if (f != null) {
            String absolutePath = f.getAbsolutePath();
            this.setVariable("__file__", absolutePath);
            String containerPart = f.getParent();
            newString = Py.newString((String)containerPart);
            Py.getSystemState().path.insert(0, (PyObject)newString);
        }
        Py.exec((PyObject)code, (PyObject)this.getEngine().getLocals(), null);
        if (newString != null) {
            Py.getSystemState().path.remove(newString);
        }
        return JythonScriptEngine.toJava(this.mResult);
    }

    private static Object toJava(PyObject result) {
        if (result instanceof PyNone) {
            return null;
        }
        if (result instanceof PyObjectDerived) {
            return result.__tojava__(Object.class);
        }
        if (result instanceof PyBoolean) {
            return ((PyBoolean)result).getBooleanValue();
        }
        if (result instanceof PyInteger) {
            return ((PyInteger)result).getValue();
        }
        if (result instanceof PyFloat) {
            return ((PyFloat)result).getValue();
        }
        if (result instanceof PyLong) {
            return ((PyLong)result).getValue();
        }
        if (result instanceof PyString) {
            return ((PyString)result).getString();
        }
        if (result instanceof PyInteger) {
            return ((PyInteger)result).getValue();
        }
        return result;
    }

    public void setOutputStream(OutputStream outputStream) {
        super.setOutputStream(outputStream);
        if (this.getEngine() != null) {
            this.getEngine().setOut((OutputStream)this.getOutputStream());
        }
    }

    public void setInputStream(InputStream inputStream) {
        super.setInputStream(inputStream);
        if (this.getEngine() != null) {
            this.getEngine().setIn(this.getInputStream());
        }
    }

    public void setErrorStream(OutputStream errorStream) {
        super.setErrorStream(errorStream);
        if (this.getEngine() != null) {
            this.getEngine().setErr((OutputStream)this.getErrorStream());
        }
    }

    protected Collection<String> getPythonLibraries() {
        String[] libs;
        ArrayList<String> result = new ArrayList<String>();
        IPreferenceStore preferences = Activator.getDefault().getPreferenceStore();
        String libraries = preferences.getString("org.eclipse.eclipsemonkey.lang.python");
        String[] stringArray = libs = libraries.split(";");
        int n = libs.length;
        int n2 = 0;
        while (n2 < n) {
            String lib = stringArray[n2];
            result.add(lib);
            ++n2;
        }
        return result;
    }

    public String getSaveVariableName(String name) {
        return PythonHelper.getSaveName((String)name);
    }

    public void registerJar(URL url) {
        throw new RuntimeException("Registering JARs is not supported for python");
    }

    protected InteractiveInterpreter getEngine() {
        return this.mEngine;
    }

    protected Object internalGetVariable(String name) {
        Object value = this.getEngine().get(name);
        if (value instanceof PyObjectDerived) {
            value = ((PyObjectDerived)value).__tojava__(Object.class);
        }
        return value;
    }

    protected Map<String, Object> internalGetVariables() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        PyObject locals = this.getEngine().getLocals();
        PyList keys = ((PyStringMap)locals).keys();
        for (Object key : keys) {
            Object value = this.internalGetVariable(key.toString());
            if (value instanceof PyFunction || value instanceof PyJavaPackage || value instanceof PyJavaType) continue;
            variables.put(key.toString(), this.internalGetVariable(key.toString()));
        }
        return variables;
    }

    protected boolean internalHasVariable(String name) {
        return this.getEngine().get(name) != null;
    }

    protected void internalSetVariable(String name, Object content) {
        if (!PythonHelper.isSaveName((String)name)) {
            throw new RuntimeException("\"" + name + "\" is not a valid Python variable name");
        }
        this.getEngine().set(name, content);
    }

    protected Object internalRemoveVariable(String name) {
        throw new RuntimeException("not supported");
    }

    private class DisplayHook
    extends PyObject {
        private static final long serialVersionUID = -6793040471701923706L;

        private DisplayHook() {
        }

        public PyObject __call__(PyObject arg0) {
            JythonScriptEngine.this.mResult = arg0;
            return Py.None;
        }
    }
}

