/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.expressions.utilities;

import com.google.common.base.Objects;
import java.util.Arrays;
import java.util.List;
import org.eclipse.comma.expressions.expression.Expression;
import org.eclipse.comma.expressions.expression.ExpressionAny;
import org.eclipse.comma.expressions.expression.ExpressionBinary;
import org.eclipse.comma.expressions.expression.ExpressionBracket;
import org.eclipse.comma.expressions.expression.ExpressionBulkData;
import org.eclipse.comma.expressions.expression.ExpressionConstantBool;
import org.eclipse.comma.expressions.expression.ExpressionConstantInt;
import org.eclipse.comma.expressions.expression.ExpressionConstantReal;
import org.eclipse.comma.expressions.expression.ExpressionConstantString;
import org.eclipse.comma.expressions.expression.ExpressionEnumLiteral;
import org.eclipse.comma.expressions.expression.ExpressionFunctionCall;
import org.eclipse.comma.expressions.expression.ExpressionMap;
import org.eclipse.comma.expressions.expression.ExpressionMapRW;
import org.eclipse.comma.expressions.expression.ExpressionQuantifier;
import org.eclipse.comma.expressions.expression.ExpressionRecord;
import org.eclipse.comma.expressions.expression.ExpressionRecordAccess;
import org.eclipse.comma.expressions.expression.ExpressionUnary;
import org.eclipse.comma.expressions.expression.ExpressionVariable;
import org.eclipse.comma.expressions.expression.ExpressionVector;
import org.eclipse.comma.expressions.expression.Field;
import org.eclipse.comma.expressions.expression.MapRWContext;
import org.eclipse.comma.expressions.expression.Pair;
import org.eclipse.comma.expressions.expression.Variable;
import org.eclipse.comma.types.types.MapTypeConstructor;
import org.eclipse.comma.types.types.RecordTypeDecl;
import org.eclipse.comma.types.types.TypeDecl;
import org.eclipse.comma.types.types.TypeReference;
import org.eclipse.comma.types.types.VectorTypeConstructor;
import org.eclipse.comma.types.utilities.TypesComparator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class ExpressionsComparator
extends TypesComparator {
    protected boolean _compare(Variable v1, Variable v2) {
        return Objects.equal((Object)v1.getName(), (Object)v2.getName()) && this.sameAs((EObject)v1.getType(), (EObject)v2.getType());
    }

    protected boolean _compare(ExpressionBinary exp1, ExpressionBinary exp2) {
        return this.sameAs(exp1.getLeft(), exp2.getLeft()) && this.sameAs(exp1.getRight(), exp2.getRight());
    }

    protected boolean _compare(ExpressionUnary exp1, ExpressionUnary exp2) {
        return this.sameAs(exp1.getSub(), exp2.getSub());
    }

    protected boolean _compare(ExpressionRecordAccess exp1, ExpressionRecordAccess exp2) {
        return this.sameAs(exp1.getRecord(), exp2.getRecord()) && exp1.getField() == exp2.getField();
    }

    protected boolean _compare(ExpressionBracket exp1, ExpressionBracket exp2) {
        return this.sameAs(exp1.getSub(), exp2.getSub());
    }

    protected boolean _compare(ExpressionConstantBool exp1, ExpressionConstantBool exp2) {
        boolean _isValue_1;
        boolean _isValue = exp1.isValue();
        return _isValue == (_isValue_1 = exp2.isValue());
    }

    protected boolean _compare(ExpressionConstantInt exp1, ExpressionConstantInt exp2) {
        long _value_1;
        long _value = exp1.getValue();
        return _value == (_value_1 = exp2.getValue());
    }

    protected boolean _compare(ExpressionConstantReal exp1, ExpressionConstantReal exp2) {
        double _value_1;
        double _value = exp1.getValue();
        return _value == (_value_1 = exp2.getValue());
    }

    protected boolean _compare(ExpressionConstantString exp1, ExpressionConstantString exp2) {
        String _value = exp1.getValue();
        String _value_1 = exp2.getValue();
        return Objects.equal((Object)_value, (Object)_value_1);
    }

    protected boolean _compare(ExpressionEnumLiteral exp1, ExpressionEnumLiteral exp2) {
        return exp1.getType() == exp2.getType() && exp1.getLiteral() == exp2.getLiteral();
    }

    protected boolean _compare(ExpressionVariable exp1, ExpressionVariable exp2) {
        return this.sameAs((EObject)exp1.getVariable(), (EObject)exp2.getVariable());
    }

    protected boolean _compare(ExpressionRecord exp1, ExpressionRecord exp2) {
        RecordTypeDecl _type_1;
        boolean _tripleNotEquals;
        boolean _xblockexpression = false;
        RecordTypeDecl _type = exp1.getType();
        boolean bl = _tripleNotEquals = _type != (_type_1 = exp2.getType());
        if (_tripleNotEquals) {
            return false;
        }
        Functions.Function1<Field, Expression> _function = new Functions.Function1<Field, Expression>(){

            public Expression apply(Field it) {
                return it.getExp();
            }
        };
        Functions.Function1<Field, Expression> _function_1 = new Functions.Function1<Field, Expression>(){

            public Expression apply(Field it) {
                return it.getExp();
            }
        };
        _xblockexpression = this.compareLists(ListExtensions.map(exp1.getFields(), (Functions.Function1)_function), ListExtensions.map(exp2.getFields(), (Functions.Function1)_function_1));
        return _xblockexpression;
    }

    protected boolean _compare(ExpressionVector exp1, ExpressionVector exp2) {
        boolean _not;
        boolean _xblockexpression = false;
        boolean _sameAs = this.sameAs((EObject)exp1.getTypeAnnotation().getType(), (EObject)exp2.getTypeAnnotation().getType());
        boolean bl = _not = !_sameAs;
        if (_not) {
            return false;
        }
        _xblockexpression = this.compareLists((List)exp1.getElements(), (List)exp2.getElements());
        return _xblockexpression;
    }

    protected boolean _compare(ExpressionMap exp1, ExpressionMap exp2) {
        boolean _not;
        boolean _xblockexpression = false;
        boolean _sameAs = this.sameAs((EObject)exp1.getTypeAnnotation().getType(), (EObject)exp2.getTypeAnnotation().getType());
        boolean bl = _not = !_sameAs;
        if (_not) {
            return false;
        }
        _xblockexpression = this.compareLists((List)exp1.getPairs(), (List)exp2.getPairs());
        return _xblockexpression;
    }

    protected boolean _compare(Pair exp1, Pair exp2) {
        return this.sameAs(exp1.getKey(), exp2.getKey()) && this.sameAs(exp1.getValue(), exp2.getValue());
    }

    protected boolean _compare(ExpressionMapRW exp1, ExpressionMapRW exp2) {
        boolean _sameAs_2;
        boolean _and = false;
        boolean _and_1 = false;
        boolean _and_2 = false;
        if (!this.sameAs(exp1.getMap(), exp2.getMap()) || !this.sameAs(exp1.getKey(), exp2.getKey())) {
            _and_2 = false;
        } else {
            boolean _sameAs;
            MapRWContext _context = exp1.getContext();
            Expression _collection = null;
            if (_context != null) {
                _collection = _context.getCollection();
            }
            MapRWContext _context_1 = exp2.getContext();
            Expression _collection_1 = null;
            if (_context_1 != null) {
                _collection_1 = _context_1.getCollection();
            }
            _and_2 = _sameAs = this.sameAs(_collection, _collection_1);
        }
        if (!_and_2) {
            _and_1 = false;
        } else {
            boolean _sameAs_1;
            MapRWContext _context_2 = exp1.getContext();
            Variable _iterator = null;
            if (_context_2 != null) {
                _iterator = _context_2.getIterator();
            }
            MapRWContext _context_3 = exp2.getContext();
            Variable _iterator_1 = null;
            if (_context_3 != null) {
                _iterator_1 = _context_3.getIterator();
            }
            _and_1 = _sameAs_1 = this.sameAs((EObject)_iterator, (EObject)_iterator_1);
        }
        _and = !_and_1 ? false : (_sameAs_2 = this.sameAs(exp1.getValue(), exp2.getValue()));
        return _and;
    }

    protected boolean _compare(ExpressionBulkData exp1, ExpressionBulkData exp2) {
        int _size_1;
        int _size = exp1.getSize();
        return _size == (_size_1 = exp2.getSize());
    }

    protected boolean _compare(ExpressionAny exp1, ExpressionAny exp2) {
        return true;
    }

    protected boolean _compare(ExpressionFunctionCall exp1, ExpressionFunctionCall exp2) {
        String _functionName_1;
        boolean _notEquals;
        boolean _xblockexpression = false;
        String _functionName = exp1.getFunctionName();
        boolean bl = _notEquals = !Objects.equal((Object)_functionName, (Object)(_functionName_1 = exp2.getFunctionName()));
        if (_notEquals) {
            return false;
        }
        _xblockexpression = this.compareLists((List)exp1.getArgs(), (List)exp2.getArgs());
        return _xblockexpression;
    }

    protected boolean _compare(ExpressionQuantifier exp1, ExpressionQuantifier exp2) {
        return exp1.getQuantifier() == exp2.getQuantifier() && this.sameAs((EObject)exp1.getIterator(), (EObject)exp2.getIterator()) && this.sameAs(exp1.getCollection(), exp2.getCollection()) && this.sameAs(exp1.getCondition(), exp2.getCondition());
    }

    public boolean compare(EObject exp1, EObject exp2) {
        if (exp1 instanceof ExpressionBracket && exp2 instanceof ExpressionBracket) {
            return this._compare((ExpressionBracket)exp1, (ExpressionBracket)exp2);
        }
        if (exp1 instanceof ExpressionAny && exp2 instanceof ExpressionAny) {
            return this._compare((ExpressionAny)exp1, (ExpressionAny)exp2);
        }
        if (exp1 instanceof ExpressionBinary && exp2 instanceof ExpressionBinary) {
            return this._compare((ExpressionBinary)exp1, (ExpressionBinary)exp2);
        }
        if (exp1 instanceof ExpressionBulkData && exp2 instanceof ExpressionBulkData) {
            return this._compare((ExpressionBulkData)exp1, (ExpressionBulkData)exp2);
        }
        if (exp1 instanceof ExpressionConstantBool && exp2 instanceof ExpressionConstantBool) {
            return this._compare((ExpressionConstantBool)exp1, (ExpressionConstantBool)exp2);
        }
        if (exp1 instanceof ExpressionConstantInt && exp2 instanceof ExpressionConstantInt) {
            return this._compare((ExpressionConstantInt)exp1, (ExpressionConstantInt)exp2);
        }
        if (exp1 instanceof ExpressionConstantReal && exp2 instanceof ExpressionConstantReal) {
            return this._compare((ExpressionConstantReal)exp1, (ExpressionConstantReal)exp2);
        }
        if (exp1 instanceof ExpressionConstantString && exp2 instanceof ExpressionConstantString) {
            return this._compare((ExpressionConstantString)exp1, (ExpressionConstantString)exp2);
        }
        if (exp1 instanceof ExpressionEnumLiteral && exp2 instanceof ExpressionEnumLiteral) {
            return this._compare((ExpressionEnumLiteral)exp1, (ExpressionEnumLiteral)exp2);
        }
        if (exp1 instanceof ExpressionFunctionCall && exp2 instanceof ExpressionFunctionCall) {
            return this._compare((ExpressionFunctionCall)exp1, (ExpressionFunctionCall)exp2);
        }
        if (exp1 instanceof ExpressionMap && exp2 instanceof ExpressionMap) {
            return this._compare((ExpressionMap)exp1, (ExpressionMap)exp2);
        }
        if (exp1 instanceof ExpressionMapRW && exp2 instanceof ExpressionMapRW) {
            return this._compare((ExpressionMapRW)exp1, (ExpressionMapRW)exp2);
        }
        if (exp1 instanceof ExpressionQuantifier && exp2 instanceof ExpressionQuantifier) {
            return this._compare((ExpressionQuantifier)exp1, (ExpressionQuantifier)exp2);
        }
        if (exp1 instanceof ExpressionRecord && exp2 instanceof ExpressionRecord) {
            return this._compare((ExpressionRecord)exp1, (ExpressionRecord)exp2);
        }
        if (exp1 instanceof ExpressionRecordAccess && exp2 instanceof ExpressionRecordAccess) {
            return this._compare((ExpressionRecordAccess)exp1, (ExpressionRecordAccess)exp2);
        }
        if (exp1 instanceof ExpressionUnary && exp2 instanceof ExpressionUnary) {
            return this._compare((ExpressionUnary)exp1, (ExpressionUnary)exp2);
        }
        if (exp1 instanceof ExpressionVariable && exp2 instanceof ExpressionVariable) {
            return this._compare((ExpressionVariable)exp1, (ExpressionVariable)exp2);
        }
        if (exp1 instanceof ExpressionVector && exp2 instanceof ExpressionVector) {
            return this._compare((ExpressionVector)exp1, (ExpressionVector)exp2);
        }
        if (exp1 instanceof Variable && exp2 instanceof Variable) {
            return this._compare((Variable)exp1, (Variable)exp2);
        }
        if (exp1 instanceof MapTypeConstructor && exp2 instanceof MapTypeConstructor) {
            return this._compare((MapTypeConstructor)exp1, (MapTypeConstructor)exp2);
        }
        if (exp1 instanceof TypeDecl && exp2 instanceof TypeDecl) {
            return this._compare((TypeDecl)exp1, (TypeDecl)exp2);
        }
        if (exp1 instanceof TypeReference && exp2 instanceof TypeReference) {
            return this._compare((TypeReference)exp1, (TypeReference)exp2);
        }
        if (exp1 instanceof VectorTypeConstructor && exp2 instanceof VectorTypeConstructor) {
            return this._compare((VectorTypeConstructor)exp1, (VectorTypeConstructor)exp2);
        }
        if (exp1 instanceof Pair && exp2 instanceof Pair) {
            return this._compare((Pair)exp1, (Pair)exp2);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(exp1, exp2).toString());
    }
}

