/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw3d.ConnectionLayerFactory;
import org.eclipse.draw3d.Figure3DHelper;
import org.eclipse.draw3d.IFigure3D;

public class DispatchingConnectionLayerHelper {
    public static final String CONSTRAINT_LAYER = "CONSTRAINT_LAYER";
    private static final Logger log = Logger.getLogger(DispatchingConnectionLayerHelper.class.getName());
    private final Map<IFigure3D, ConnectionLayer> distributedLayersMap = new HashMap<IFigure3D, ConnectionLayer>();
    private final ConnectionLayerFactory factory;
    private final ConnectionLayer host;
    private final Map<Connection, ConnectionConstraints> pendingConnections = new HashMap<Connection, ConnectionConstraints>();
    private IFigure pendingParent;

    public DispatchingConnectionLayerHelper(ConnectionLayer i_host, ConnectionLayerFactory i_factory) {
        this.host = i_host;
        this.factory = i_factory;
        this.pendingParent = null;
    }

    public void setPendingParent(IFigure fig) {
        this.pendingParent = fig;
    }

    public boolean add(IFigure i_figure, Object i_constraint, int i_index) {
        if (i_constraint != CONSTRAINT_LAYER && i_figure instanceof Connection && !(i_figure instanceof IFigure3D)) {
            IFigure3D fig3DHost = this.findConectionLayerHost((Connection)i_figure);
            ConnectionLayer distributedLayer = this.getConnectionLayerOf3DHost(fig3DHost);
            if (distributedLayer != null) {
                distributedLayer.setConnectionRouter(this.host.getConnectionRouter());
                distributedLayer.add(i_figure, i_constraint, i_index);
                this.pendingConnections.remove(i_figure);
                fig3DHost.invalidateTree();
            } else {
                this.pendingConnections.put((Connection)i_figure, new ConnectionConstraints(i_constraint, i_index));
                if (this.pendingParent != null) {
                    this.pendingParent.add(i_figure);
                }
            }
            return true;
        }
        return false;
    }

    public void dispatchPendingConnections() {
        if (!this.pendingConnections.isEmpty()) {
            ArrayList<Connection> dispatchedConnections = new ArrayList<Connection>();
            for (Map.Entry<Connection, ConnectionConstraints> entry : this.pendingConnections.entrySet()) {
                Connection connection = entry.getKey();
                ConnectionConstraints cc = entry.getValue();
                IFigure3D fig3DHost = this.findConectionLayerHost(connection);
                ConnectionLayer distributedLayer = this.getConnectionLayerOf3DHost(fig3DHost);
                if (distributedLayer == null) continue;
                distributedLayer.setConnectionRouter(this.host.getConnectionRouter());
                dispatchedConnections.add(connection);
                distributedLayer.add((IFigure)connection, cc.constaint, cc.index);
                this.rewire((IFigure)connection);
                distributedLayer.validate();
                fig3DHost.invalidateTree();
            }
            for (IFigure iFigure : dispatchedConnections) {
                this.pendingConnections.remove(iFigure);
            }
        }
    }

    protected IFigure3D findConectionLayerHost(Connection i_connection) {
        IFigure3D targetAncestor3D;
        ConnectionAnchor anchor = i_connection.getSourceAnchor();
        IFigure source = anchor != null ? anchor.getOwner() : null;
        anchor = i_connection.getTargetAnchor();
        IFigure target = anchor != null ? anchor.getOwner() : null;
        IFigure3D sourceAncestor3D = Figure3DHelper.getAncestor3D(source);
        if (sourceAncestor3D != (targetAncestor3D = Figure3DHelper.getAncestor3D(target))) {
            log.severe("2D connections with different 3D ancestors");
            throw new IllegalArgumentException("Connection's anchors have different 3D ancestors");
        }
        return sourceAncestor3D;
    }

    private ConnectionLayer getConnectionLayerOf3DHost(IFigure3D fig3DHost) {
        if (fig3DHost == null) {
            return null;
        }
        ConnectionLayer layer = this.distributedLayersMap.get(fig3DHost);
        if (layer == null) {
            layer = fig3DHost.getConnectionLayer(this.factory);
            if (layer != null) {
                this.host.add((IFigure)layer, (Object)CONSTRAINT_LAYER);
                this.distributedLayersMap.put(fig3DHost, layer);
            } else {
                log.warning("Cannot create connection layer for figure " + fig3DHost);
            }
        }
        return layer;
    }

    public void paintChildren(Graphics i_graphics) {
        List children = this.host.getChildren();
        Rectangle clip = Rectangle.SINGLETON;
        for (IFigure child : children) {
            if (child instanceof ConnectionLayer || !child.isVisible() || !child.intersects(i_graphics.getClip(clip))) continue;
            i_graphics.clipRect(child.getBounds());
            child.paint(i_graphics);
            i_graphics.restoreState();
        }
    }

    public boolean remove(IFigure i_figure) {
        if (i_figure instanceof Connection && !(i_figure instanceof IFigure3D)) {
            IFigure3D fig3DHost;
            ConnectionLayer distributedLayer;
            if (this.pendingConnections.remove(i_figure) == null && (distributedLayer = this.getConnectionLayerOf3DHost(fig3DHost = this.findConectionLayerHost((Connection)i_figure))) != null) {
                distributedLayer.remove(i_figure);
                fig3DHost.invalidateTree();
            }
            return true;
        }
        return false;
    }

    private void rewire(IFigure figure) {
        if (figure instanceof Connection) {
            Connection conn = (Connection)figure;
            ConnectionAnchor sourceAnchor = conn.getSourceAnchor();
            ConnectionAnchor targetAnchor = conn.getTargetAnchor();
            conn.setSourceAnchor(null);
            conn.setTargetAnchor(null);
            conn.setSourceAnchor(sourceAnchor);
            conn.setTargetAnchor(targetAnchor);
        }
    }

    public void setConnectionRouter(ConnectionRouter i_router) {
        for (ConnectionLayer distributedLayer : this.distributedLayersMap.values()) {
            if (distributedLayer.getConnectionRouter() != null) continue;
            distributedLayer.setConnectionRouter(i_router);
        }
    }

    public void validate() {
        this.dispatchPendingConnections();
        for (ConnectionLayer layer : this.distributedLayersMap.values()) {
            layer.validate();
        }
    }

    public static class ConnectionConstraints {
        public Object constaint;
        public int index;

        public ConnectionConstraints(Object i_constaint, int i_index) {
            this.constaint = i_constaint;
            this.index = i_index;
        }
    }
}

