/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.ui.viewer;

import org.eclipse.draw3d.ui.camera.CameraInputHandler;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseWheelListener;

public class CameraInputListener
implements KeyListener,
MouseListener,
MouseMoveListener,
MouseWheelListener {
    private CameraInputHandler m_handler;

    public CameraInputListener(CameraInputHandler i_handler) {
        if (i_handler == null) {
            throw new NullPointerException("i_handler must not be null");
        }
        this.m_handler = i_handler;
    }

    public void keyPressed(KeyEvent i_event) {
        this.m_handler.keyDown(i_event);
    }

    public void keyReleased(KeyEvent i_event) {
        this.m_handler.keyUp(i_event);
    }

    public void mouseDoubleClick(MouseEvent i_e) {
    }

    public void mouseDown(MouseEvent i_event) {
        this.m_handler.buttonDown(i_event.button, i_event.stateMask, i_event.x, i_event.y);
    }

    public void mouseMove(MouseEvent i_event) {
        this.m_handler.mouseMove(i_event.stateMask, i_event.x, i_event.y);
    }

    public void mouseScrolled(MouseEvent i_mouseEvent) {
        this.m_handler.mouseWheelScrolled(i_mouseEvent.count);
    }

    public void mouseUp(MouseEvent i_event) {
        this.m_handler.buttonUp(i_event.button, i_event.stateMask, i_event.x, i_event.y);
    }
}

