/*
 * Decompiled with CFR 0.152.
 */
package nts.node;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import nts.base.Dimen;
import nts.io.Log;
import nts.io.Loggable;
import nts.node.BreakingCntx;
import nts.node.LinesShape;
import nts.node.NetDimen;
import nts.node.Node;
import nts.node.NodeEnum;
import nts.node.NodeList;

public abstract class Breaker {
    protected static final Break NULL_BREAK;
    protected static final Fitness NULL_FITNESS;
    protected static final int INF_BAD = 10000;
    protected static final int AWFUL_BAD = 0x3FFFFFFF;
    protected int minDem = 0x3FFFFFFF;
    protected final Fitness TIGHT;
    protected final Fitness DECENT;
    protected final Fitness LOOSE;
    protected final Fitness VERY_LOOSE;
    protected final Fitness FITNESS_HEAD;
    private NodeEnum nodeEnum;
    private int nodeCount;
    protected Node[] nodeList;
    protected LinesShape shape;
    protected int firstLineNo;
    protected int looseness;
    protected int linePen;
    protected int hyphPen;
    protected int exHyphPen;
    protected int adjDem;
    protected int dblHyphDem;
    protected int finHyphDem;
    protected NetDimen background;
    protected int threshold;
    protected boolean finPass;
    protected List breakList;
    private int maxSerial;
    protected Break[] lineBreaks;
    protected int currLineIndex;
    protected NodeEnum lastPostBreak;

    protected Fitness getFitness(int badness, boolean stretching) {
        if (stretching) {
            if (badness > 99) {
                return this.VERY_LOOSE;
            }
            if (badness > 12) {
                return this.LOOSE;
            }
        } else if (badness > 12) {
            return this.TIGHT;
        }
        return this.DECENT;
    }

    protected void resetDemerits() {
        this.minDem = 0x3FFFFFFF;
        Fitness fit = this.FITNESS_HEAD;
        while (fit != null) {
            fit.reset();
            fit = fit.next;
        }
    }

    public void refeed(NodeEnum nodeEnum) {
        this.nodeEnum = nodeEnum;
        this.nodeCount = 0;
    }

    protected final Node nodeAt(int i) {
        return this.nodeList[i];
    }

    protected final boolean stillNodeAt(int i) {
        while (this.nodeCount <= i) {
            if (!this.nodeEnum.hasMoreNodes()) {
                return false;
            }
            if (this.nodeList.length <= this.nodeCount) {
                int newLength = this.nodeList.length * 2;
                while (newLength <= this.nodeCount) {
                    newLength *= 2;
                }
                Node[] oldList = this.nodeList;
                this.nodeList = new Node[newLength];
                System.arraycopy(oldList, 0, this.nodeList, 0, this.nodeCount);
            }
            this.nodeList[this.nodeCount++] = this.nodeEnum.nextNode();
        }
        return true;
    }

    protected void reset() {
        this.breakList = new LinkedList();
        this.maxSerial = 0;
        this.lineBreaks = null;
        this.currLineIndex = 0;
        this.lastPostBreak = null;
        this.resetDemerits();
    }

    public void breakToLines(NetDimen background, int threshold, boolean finPass) {
        this.background = background;
        this.threshold = threshold > 10000 ? 10000 : threshold;
        this.finPass = finPass;
        this.reset();
        this.breakList.add(this.DECENT.makeFirst(this.firstLineNo));
        if (this.passNodes()) {
            this.tryBreak(this.nodeCount, -10000, true, Dimen.ZERO, true);
        }
        Break best = this.bestBreak();
        if (this.looseness != 0 && best != null) {
            best = this.bestBreak(best.lineNo);
        }
        int n = 0;
        Break brk = best;
        while (brk != null) {
            ++n;
            brk = brk.prev;
        }
        if (n > 0) {
            this.lineBreaks = new Break[n];
            this.currLineIndex = 1;
            brk = best;
            while (brk != null) {
                this.lineBreaks[--n] = brk;
                brk = brk.prev;
            }
        }
    }

    public boolean successfullyBroken() {
        return this.currLineIndex > 0;
    }

    public boolean hasMoreLines() {
        return this.currLineIndex > 0 && this.currLineIndex < this.lineBreaks.length;
    }

    public boolean nextLineWasHyphenated() {
        Break brk = this.lineBreaks[this.currLineIndex];
        return brk.hyphenated && brk.count > 0;
    }

    public NodeList getNextLine() {
        int i = this.currLineIndex++;
        return this.makeList(this.lineBreaks[i - 1], this.lineBreaks[i]);
    }

    protected NodeList makeList(Break before, Break after) {
        NodeList list;
        int beg = before.index + before.count;
        int end = after.index;
        if (this.lastPostBreak != null) {
            NodeList nodeList = new NodeList(this.lastPostBreak);
        } else {
            list = new NodeList(end - beg);
        }
        list.append(this.nodeList, beg, end - beg);
        if (after.count > 0) {
            Node node = this.nodeList[end];
            list.append(node.atBreakReplacement());
            this.lastPostBreak = node.postBreakNodes();
        } else {
            this.lastPostBreak = null;
        }
        return list;
    }

    protected Break bestBreak() {
        int fewestDem = 0x3FFFFFFF;
        Break best = null;
        ListIterator iterator = this.breakList.listIterator();
        while (iterator.hasNext()) {
            Break brk = (Break)iterator.next();
            if (brk.demerits >= fewestDem) continue;
            best = brk;
            fewestDem = brk.demerits;
        }
        return best;
    }

    protected Break bestBreak(int bestLineNo) {
        int desiredLineNo = bestLineNo + this.looseness;
        int fewestDem = 0x3FFFFFFF;
        Break best = null;
        ListIterator iterator = this.breakList.listIterator();
        while (iterator.hasNext()) {
            Break brk = (Break)iterator.next();
            if (bestLineNo < brk.lineNo && brk.lineNo <= desiredLineNo || bestLineNo > brk.lineNo && brk.lineNo >= desiredLineNo) {
                best = brk;
                fewestDem = brk.demerits;
                bestLineNo = brk.lineNo;
                continue;
            }
            if (brk.lineNo != bestLineNo || brk.demerits >= fewestDem) continue;
            best = brk;
            fewestDem = brk.demerits;
        }
        return bestLineNo == desiredLineNo || this.finPass ? best : null;
    }

    protected boolean passNodes() {
        Breaker breaker = this;
        if (breaker == null) {
            throw null;
        }
        BreakingContext brkContext = breaker.new BreakingContext();
        int i = 0;
        while (this.stillNodeAt(i)) {
            Node node = this.nodeAt(i);
            if (node.allowsSpaceBreaking()) {
                brkContext.space = true;
            } else if (node.forbidsSpaceBreaking()) {
                brkContext.space = false;
            }
            if (!node.isKernBreak() || this.stillNodeAt(i + 1) && this.nodeAt(i + 1).canFollowKernBreak()) {
                brkContext.atSkip = i > 0 && this.nodeAt(i - 1).canPrecedeSkipBreak();
                int pen = node.breakPenalty(brkContext);
                if (pen < 10000) {
                    Dimen preWidth = node.preBreakWidth();
                    this.actWidth().add(preWidth);
                    this.tryBreak(i, pen < -10000 ? -10000 : pen, node.isHyphenBreak(), preWidth, false);
                    if (this.breakList.isEmpty()) {
                        return false;
                    }
                    this.actWidth().sub(preWidth);
                }
            }
            this.checkShrinkage(node);
            Breaker.add(this.actWidth(), node);
            ++i;
        }
        return true;
    }

    private NetDimen actWidth() {
        return ((Break)this.breakList.get((int)0)).delta;
    }

    private void traceBreakList() {
        block1: {
            ListIterator iterator = this.breakList.listIterator();
            System.out.print(">");
            if (!iterator.hasNext()) break block1;
            while (true) {
                Break brk = (Break)iterator.next();
                System.out.print(" @" + brk.serial);
                if (!iterator.hasNext()) break;
                System.out.print(" ..");
            }
            System.out.println();
        }
    }

    protected void tryBreak(int idx, int pen, boolean hyphen, Dimen preWidth, boolean last) {
        NetDimen currWidth = new NetDimen(this.background);
        ListIterator iterator = this.breakList.listIterator();
        int oldLineNo = 0;
        while (iterator.hasNext()) {
            int dem;
            Fitness fitness;
            int badness;
            Break brk = (Break)iterator.next();
            if (brk.lineNo > oldLineNo) {
                if (this.looseness != 0 || !this.shape.isFinal(brk.lineNo)) {
                    oldLineNo = brk.lineNo;
                    if (this.minDem < 0x3FFFFFFF) {
                        iterator.previous();
                        this.createActive(idx, iterator, currWidth, hyphen, preWidth);
                        iterator.next();
                    }
                } else {
                    oldLineNo = Integer.MAX_VALUE;
                }
            }
            currWidth.add(brk.delta);
            Dimen diff = this.shape.getWidth(brk.lineNo).minus(currWidth.getNatural());
            if (diff.moreThan(0)) {
                badness = currWidth.getMaxStrOrder() > 0 ? 0 : diff.badness(currWidth.getStretch((byte)0));
                Fitness fitness2 = this.getFitness(badness, true);
            } else {
                badness = (diff = diff.negative()).moreThan(currWidth.getShrink()) ? 10001 : diff.badness(currWidth.getShrink());
                fitness = this.getFitness(badness, false);
            }
            if (badness > 10000 || pen == -10000) {
                if (this.finPass && this.minDem == 0x3FFFFFFF && this.breakList.size() == 1) {
                    this.traceBreak(idx, brk.serial, badness, pen, 0, true);
                    this.recordFeasible(brk, fitness, 0);
                } else if (badness <= this.threshold) {
                    dem = this.demerits(pen, badness) + this.demerits(brk, fitness, hyphen, last);
                    this.traceBreak(idx, brk.serial, badness, pen, dem, false);
                    this.recordFeasible(brk, fitness, dem);
                }
                iterator.remove();
                if (iterator.hasNext()) {
                    ((Break)iterator.next()).delta.add(brk.delta);
                    iterator.previous();
                }
                currWidth.sub(brk.delta);
                brk.delta = null;
                continue;
            }
            if (badness > this.threshold) continue;
            dem = this.demerits(pen, badness) + this.demerits(brk, fitness, hyphen, last);
            this.traceBreak(idx, brk.serial, badness, pen, dem, false);
            this.recordFeasible(brk, fitness, dem);
        }
        if (this.minDem < 0x3FFFFFFF) {
            this.createActive(idx, iterator, currWidth, hyphen, preWidth);
        }
    }

    protected void createActive(int idx, ListIterator iterator, NetDimen width, boolean hyphen, Dimen preWidth) {
        int absAdjDem = Math.abs(this.adjDem);
        int limit = 0x3FFFFFFF - this.minDem <= absAdjDem ? 0x3FFFFFFE : this.minDem + absAdjDem;
        int cnt = this.breakCount(idx);
        NetDimen delta = this.breakWidth(idx, cnt);
        delta.add(preWidth);
        delta.sub(width);
        Fitness fit = this.FITNESS_HEAD;
        while (fit != null) {
            if (fit.fits(limit)) {
                Break best;
                if (delta != null) {
                    best = fit.makeBest(idx, cnt, hyphen, delta);
                    iterator.add(best);
                    this.traceBreak(best);
                    if (iterator.hasNext()) {
                        ((Break)iterator.next()).delta.sub(best.delta);
                        iterator.previous();
                    }
                    width.add(delta);
                    delta = null;
                } else {
                    best = fit.makeBest(idx, cnt, hyphen, new NetDimen());
                    iterator.add(best);
                    this.traceBreak(best);
                }
            }
            fit.reset();
            fit = fit.next;
        }
        this.minDem = 0x3FFFFFFF;
    }

    protected int demerits(int pen, int badness) {
        int dem = Math.abs(this.linePen + badness);
        if (dem > 10000) {
            dem = 10000;
        }
        dem *= dem;
        if (pen != 0) {
            if (pen > 0) {
                dem += pen * pen;
            } else if (pen > -10000) {
                dem -= pen * pen;
            }
        }
        return dem;
    }

    protected int demerits(Break brk, Fitness fitness, boolean hyphen, boolean last) {
        int dem = 0;
        if (brk.hyphenated) {
            if (last) {
                dem += this.finHyphDem;
            } else if (hyphen) {
                dem += this.dblHyphDem;
            }
        }
        if (!fitness.adjoins(brk.fitness)) {
            dem += this.adjDem;
        }
        return dem;
    }

    protected void recordFeasible(Break brk, Fitness fitness, int dem) {
        fitness.update(dem += brk.demerits, brk);
        if (this.minDem > dem) {
            this.minDem = dem;
        }
    }

    protected int breakCount(int idx) {
        int j = idx;
        if (this.stillNodeAt(j) && this.nodeAt(j++).discardsAfter()) {
            while (this.stillNodeAt(j) && this.nodeAt(j).discardable()) {
                ++j;
            }
        }
        return j - idx;
    }

    protected NetDimen breakWidth(int idx, int cnt) {
        NetDimen netDim = new NetDimen(this.background);
        if (cnt > 0) {
            netDim.add(this.nodeAt(idx).postBreakWidth());
        }
        int j = 0;
        while (j < cnt) {
            Breaker.sub(netDim, this.nodeAt(idx + j));
            ++j;
        }
        return netDim;
    }

    protected static void add(NetDimen netDim, Node node) {
        netDim.add(node.getLeftX());
        netDim.add(node.getWidth());
        netDim.addShrink(node.getWshr());
        netDim.addStretch(node.getWstrOrd(), node.getWstr());
    }

    protected static void sub(NetDimen netDim, Node node) {
        netDim.sub(node.getLeftX());
        netDim.sub(node.getWidth());
        netDim.subShrink(node.getWshr());
        netDim.subStretch(node.getWstrOrd(), node.getWstr());
    }

    protected void checkShrinkage(Node node) {
    }

    protected abstract void traceBreak(int var1, int var2, int var3, int var4, int var5, boolean var6);

    protected abstract void traceBreak(Break var1);

    public Breaker(NodeEnum nodeEnum, LinesShape shape, int firstLineNo, int looseness, int linePen, int hyphPen, int exHyphPen, int adjDem, int dblHyphDem, int finHyphDem) {
        Breaker breaker = this;
        if (breaker == null) {
            throw null;
        }
        this.TIGHT = breaker.new Fitness(3, null);
        Breaker breaker2 = this;
        if (breaker2 == null) {
            throw null;
        }
        this.DECENT = breaker2.new Fitness(2, this.TIGHT);
        Breaker breaker3 = this;
        if (breaker3 == null) {
            throw null;
        }
        this.LOOSE = breaker3.new Fitness(1, this.DECENT);
        Breaker breaker4 = this;
        if (breaker4 == null) {
            throw null;
        }
        this.FITNESS_HEAD = this.VERY_LOOSE = breaker4.new Fitness(0, this.LOOSE);
        this.nodeCount = 0;
        this.nodeList = new Node[32];
        this.currLineIndex = 0;
        this.lastPostBreak = null;
        this.nodeEnum = nodeEnum;
        this.shape = shape;
        this.firstLineNo = firstLineNo;
        this.looseness = looseness;
        this.linePen = linePen;
        this.hyphPen = hyphPen;
        this.exHyphPen = exHyphPen;
        this.adjDem = adjDem;
        this.dblHyphDem = dblHyphDem;
        this.finHyphDem = finHyphDem;
    }

    protected static class Break {
        public final int index;
        public final int count;
        public final int lineNo;
        public final Fitness fitness;
        public final boolean hyphenated;
        public final int demerits;
        public final int serial;
        public final Break prev;
        public NetDimen delta;

        public Break(int index, int count, int lineNo, Fitness fitness, boolean hyphenated, int demerits, int serial, Break prev, NetDimen delta) {
            this.index = index;
            this.count = count;
            this.lineNo = lineNo;
            this.fitness = fitness;
            this.hyphenated = hyphenated;
            this.demerits = demerits;
            this.serial = serial;
            this.prev = prev;
            this.delta = delta;
        }
    }

    protected class Fitness
    implements Loggable {
        private final int code;
        public final Fitness next;
        private int minDem = 0x3FFFFFFF;
        private Break best = null;

        public void addOn(Log log) {
            log.add(this.code);
        }

        public boolean adjoins(Fitness other) {
            return this.equals(other) || other.equals(this.next) || this.equals(other.next);
        }

        public void update(int dem, Break brk) {
            if (this.minDem >= dem) {
                this.minDem = dem;
                this.best = brk;
            }
        }

        public void reset() {
            this.minDem = 0x3FFFFFFF;
            this.best = null;
        }

        public boolean fits(int limit) {
            return this.minDem <= limit;
        }

        public Break makeFirst(int lineNo) {
            Breaker breaker = Breaker.this;
            int n = breaker.maxSerial;
            breaker.maxSerial = n + 1;
            return new Break(0, 0, lineNo, this, false, 0, n, null, new NetDimen());
        }

        public Break makeBest(int idx, int cnt, boolean hyphenated, NetDimen delta) {
            if (this.best == null) {
                throw new RuntimeException("no best break");
            }
            int n = this.best.lineNo + 1;
            Breaker breaker = Breaker.this;
            int n2 = breaker.maxSerial;
            breaker.maxSerial = n2 + 1;
            return new Break(idx, cnt, n, this, hyphenated, this.minDem, n2, this.best, delta);
        }

        public String toString() {
            return Integer.toString(this.code);
        }

        public Fitness(int code, Fitness next) {
            this.code = code;
            this.next = next;
        }
    }

    protected class BreakingContext
    implements BreakingCntx {
        public boolean space = true;
        public boolean atSkip = true;

        public boolean spaceBreaking() {
            return this.space;
        }

        public boolean allowedAtSkip() {
            return this.atSkip;
        }

        public int hyphenPenalty() {
            return Breaker.this.hyphPen;
        }

        public int exHyphenPenalty() {
            return Breaker.this.exHyphPen;
        }

        BreakingContext() {
        }
    }
}

