unit VFDcl;
{$I option.pas}
interface
uses Dos;

const _Version = '1.3-a';

type float = extended;
type lword = record
             case boolean of
             false : (iwordlo, iwordhi : word);
             true  : (iint : longint);
             end;
type longword = record
             case boolean of
             false : (jwordlo, jwordhi : longint);
             true  : (iwordlo, iwordhi : lword);
             end;
const MaxWord = $10000;

const MaxBufSize = 8192;
type  BufRecord = array [1..MaxBufSize] of char;
type  ReadState = (OpenBrace, CloseBrace, CloseLex, EndFile);
                   {--- NextOpen,  NextClose ---}

const MaxFontNumber = 50;
const MaxCaseStruct = 50;
const MaxLoadStruct = 50;

type FaceString = string[3];
const FaceName : array [0..17] of FaceString =
   ('MRR','MIR','BRR','BIR','LRR','LIR',
    'MRC','MIC','BRC','BIC','LRC','LIC',
    'MRE','MIE','BRE','BIE','LRE','LIE');

type MonthString = string[10];
const MonthName : array [1..12] of MonthString =
   ('January ', 'Febriary ', 'March ',     'April ',   'May ',      'June ',
    'July ',    'August ',   'September ', 'October ', 'November ', 'December ');

type DayString = string[10];
const DayName : array [0..6] of DayString =
   ('Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday');

const Digit : array[0..15] of char =
   ('0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F');

type  MapFontModeType = (FModeNone,   FModeFull,
                         FMode7to8,   FMode8to7,
                         FModeHbit,   FModeLBit,
                         FModeJWNCyr, FModeAltGost);

type  VFontParamRec = record
           FontName      : string[127];
           FontTFMName   : string[127];
           FontArea      : string[127];
           CheckSum      : longint; {? unsigned}

           FontDSize     : float;
           FontDUnits    : float;

           FontAt        : float;

           IndexTFMFont  : byte;
           FlFontTFMData : byte; {0 - not def, 1 - mapchar, 2 - ichar}

           FlFontAutoWidth   : boolean;
           DefFontAutoWidth  : boolean;

           FlTraceLig    : byte;
           FlInclude     : byte;  { 0 - no include,
                                    1 - include lig + nextchar
                                    2 - include krn
                                    3 - includeboth
                                    4 - includeallchars
                                  }
           FlLigTable    : boolean;
           FlDiscIncl    : boolean;
           FlagNullDvi   : boolean;
           FlNoNextChar  : boolean;
           DefNullDvi    : boolean;
           DefNoNextChar : boolean;

           FlCheckSum    : boolean;
           FlFontDSize   : boolean;
           FlFontDUnits  : boolean;
           FlFontAt      : boolean;

           DefTraceLig   : boolean;
           DefInclude    : boolean;
           DefLigTable   : boolean;
           DefDiscIncl   : boolean;

           FlagFontUsed    : boolean;
           FlagFontInclude : boolean;
           FlagCheckSum    : boolean;
           MapFontMode     : MapFontModeType;

           end;

type  FontParamRec = record
                     FontCheckSum    : longint; {? unsigned}
                     FontFamily      : string;
                     FontFace        : integer;
                     FontCoding      : string;
                     FontDesignSize  : float;
                     FontDesignUnits : float;
                     BoundChar       : byte;
                     FlBoundChar     : boolean;
                     end;

type  FontDimenRec = record
                     Slant, Space, Stretch, Shrink,
                     XHeight, Quad, ExtraSpace,
                     Num1, Num2, Num3, Denom1, Denom2,
                     Sup1, Sup2, Sup3, Sub1, Sub2,
                     SupDrop, SubDrop, Delim1, Delim2,
                     AxisHeight : float;
                     end;

type  FontHeadFlags = record
                     FlFontCheckSum, FlFontFamily, FlFontFace,
                     FlFontCoding, FlFontDesignSize, FlFontDesignUnits,
                     FlBoundChar,
                     FlSlant, FlSpace, FlStretch, FlShrink,
                     FlXHeight, FlQuad, FlExtraSpace,
                     FlNum1, FlNum2, FlNum3, FlDenom1, FlDenom2,
                     FlSup1, FlSup2, FlSup3, FlSub1, FlSub2,
                     FlSupDrop, FlSubDrop, FlDelim1, FlDelim2,
                     FlAxisHeight : boolean;
                     end;

type TLigType       = (TLabel, TLabelBoundary, TKern, TStop, TSkip,
                       TLig, TSLig, TSLigH, TLigS, TLigSH,
                       TSLigS, TSLigSH, TSLigSHH);
type MarkLig        = (LigNotUsed, LigNotUsedM, LigDiscard,
                       LigUsed, LigUsedBound, LigAdded);
type ptrLigRecord   = ^ LigRecord;
     LigRecord      =   record
                        ptrNext : ptrLigRecord;
                        Marked  : MarkLig;
                        TTLig   : TLigType;
                        case TLigType of
                        TLabel : (LigChar : byte);
                        TLabelBoundary : ();
                        TKern : (KernChar : byte; DummyChar : byte;
                                 KernValue : float);
                        TStop : ();
                        TSkip : (SkipNum : byte);
                        TLig, TSLig, TSLigH, TLigS, TLigSH,
                        TSLigS, TSLigSH, TSLigSHH :
                             (NextChar, InsChar : byte);
                        end;

type DVIRecordType = (DVIFont, DVIChar, DVIRule,
                      DVIRight, DVILeft, DVIUp, DVIDown,
                      DVIPush, DVIPop,
                      DVISpec, DVISpecHex);

type ptrDVIRecord = ^ DVIRecord;
     DVIRecord    = record
                    ptrNext : ptrDVIRecord;
                    TDVI    : DVIRecordType;
                    Dummy   : byte;
                    case DVIRecordType of
                    DVIFont : (nfont : integer);
                    DVIChar : (nchar : byte;
                               ndummy : byte; {!! alignment !!}
                               cheight, cwidth, cdepth : float);
                    DVIRule : (height, width : float);
                    DVIRight, DVILeft,
                    DVIUp, DVIDown : (dist : float);
                    DVIPush, DVIPop : ();
                    DVISpec,
                    DVISpecHex : (spec : string);
                    end;

type CharMark   = (CharNotUsed, CharUsed, CharDVI,
                   CharDiscard);

type CharDataRec = record

     ptrDVI     : ptrDVIRecord;

     CharWD, CharHT, CharDP, CharIC : float;
     PKWidth : float;   {width correction}

     marked     : CharMark;
     tempbyte   : byte;

     FlAddParm  : byte; {0=none,1=NextLarger,2=VarChar,3=VarChar+REP,4=both}
     NextLarger : byte;
     Top, Mid, Bot, Rep : byte;

     FlCharWD, FlCharHT, FlCharDP, FlCharIC : boolean;

     FlVarChar, FlNextLarger : boolean;
     FlTop, FlMid, FlBot, FlRep : boolean;

     mapchar,  mapfont,
     sizechar, sizefont   : byte;

     DefSizechar, DefSizefont,
     DefMapchar, DefMapfont : boolean;

     FlTFMData : boolean;   {true for sizechar/sizefont}
     FlAutoWidth : boolean;

     DefAutoWidth : boolean;
     DefFlTFMData : boolean;

     DefPKWidth : boolean;
     tempbool   : boolean;

     FlPhantom : boolean;
     DefFlPhantom : boolean;

     defined    : boolean;
     traced     : boolean;
     included   : boolean;
     twork      : byte; {0 - none, 1 - include, 2 - discard}

     end;

type CharDataType = array [0..255] of CharDataRec;


type ptrCharReMap = ^ CharReMapRec;
     CharReMapRec = record
                    ptrNext : ptrCharReMap;
                    charmap : integer;
                    dummy   : integer;
                    end;
     CharReMapArr = array[0..255] of ptrCharReMap;

type ptrDiscardChar = ^ DiscardCharRec;
     DiscardCharRec = record
                      ptrNext : ptrDiscardChar;
                      charnum : integer;
                      fontnum : integer;
                      end;

type VarType      = (VarNone, VarChar, VarInt, VarReal, VarStr);
     svaltype     = string[127];
     ptrVarRecord = ^ VarRecord;
     VarRecord    = record
                    ptrNext : ptrVarRecord;
                    VName   : string[16];
                    VType   : VarType;
                    case VarType of
                    VarNone : ();
                    VarChar : (cval : integer); {!!!!!}
                    VarInt  : (jval : longint);
                    VarReal : (rval : float);
                    VarStr  : (psval : ^ svaltype);
                    end;

type CharUsedArr     = array [0..256] of boolean;

var  ptrDiscCharGlb  : ptrDiscardChar;

var ptrVariableGlb   : ptrVarRecord;

var CharDataGlb      : ^ CharDataType;


var FontNameGlb      : string[127];
    HeadNameGlb      : string[127];
    OutputDirFile    : string[127];

var IndHeadGlb       : integer;

var TableNameGlb     : string;

var SaveTableName    : string;
    FlagSaveUnknown  : boolean;
    FlagSaveDiscard  : boolean;

const MaxDirectory   = 20;
var   DefDirectory   : array [1..MaxDirectory] of string;
      NDirectory     : integer;

var VTitleGlb        : string;
var VParamGlb        : FontParamRec;
var HFlagsGlb        : FontHeadFlags;
var FontDimenGlb     : FontDimenRec;
    FlFontDimen      : boolean;
    FlCheckSumGlb    : boolean;
    FlNoNextCharGlb  : boolean;

type FontsParmType   = array [0..MaxFontNumber] of VFontParamRec;
var  FontsParm       : ^ FontsParmType;

var ptrLigMain, ptrLigBound, ptrLigTable : ptrLigRecord;

var UCharGlb         : CharUsedArr;
var CharIndexArr     : array [0..256] of ptrLigRecord;

var LigDesignUnitsGlb : float;
    LigDesignSizeGlb  : float;

var BoundCharGlb     : byte;
    FlBoundCharGlb   : boolean;

var IndexTFMFontGlb    : byte;
    FlFontTFMDataGlb   : byte; {0 - none, 1 - mapchar, 2 - ichar}
    FlFontAutoWidthGlb : boolean;

var fnLog            : text;
    FlagLog          : boolean;
    FlagLogOut       : boolean;
    FlagLogScr       : boolean;
    FlagError        : boolean;
    FlagSevere       : boolean;

var FlOutChar        : byte;
    FlOutByte        : byte;
    FlScreen         : boolean;

var FlTraceLigGlb    : byte;
    FlIncludeGlb     : byte;
    FlLigTableGlb    : boolean;
    FlDiscIncludeGlb : boolean;
    FlagTraceLig     : byte;
    FlagInclude      : byte;
    FlagLigTable     : boolean;
    FlagDiscInclude  : boolean;
    FlagNullDviGlb   : boolean;

procedure InitData;

procedure InitHeadFile(var FParam : FontParamRec;
                       var FDim   : FontDimenRec;
                       var HFlags : FontHeadFlags);

procedure InitCharData(var FChar : CharDataType);


implementation

procedure InitData;
{---- Initiate global variables which are not the arrays ------}
var i : integer;
begin

      FlOutChar:=2;  {0 - All Char, 1 - Alpha, 2 - Alpha+Num, 3 - No Char}
      FlOutByte:=1;  {0 - DEC, 1 - OCT, 2 - HEX}
      FlScreen:=false;
      FlTraceLigGlb:=0;
      FlIncludeGlb:=0;
      FlLigTableGlb:=true;
      FlagTraceLig:=0;
      FlagInclude:=0;
      FlagLigTable:=true;
      FlagNullDviGlb:=false;
      FlDiscIncludeGlb:=false;

      FontNameGlb:='';
      OutputDirFile:='';
      HeadNameGlb:='';
      IndHeadGlb:=-9999;
      FlCheckSumGlb:=false;
      FlNoNextCharGlb:=false;

      TableNameGlb:='';

      SaveTableName:='';
      FlagSaveUnknown:=false;
      FlagSaveDiscard:=true;

      IndexTFMFontGlb:=0;
      FlFontTFMDataGlb:=0;
      FlFontAutoWidthGlb:=false;

      for i:=1 to MaxDirectory do DefDirectory[i]:='';
      NDirectory:=0;

      for i:=0 to MaxFontNumber do
      with FontsParm^[i] do
      begin
           FontName:=''; FontTFMName:='';
           FontArea:=''; FontAt:=1.0;

           IndexTFMFont:=0; FlFontTFMData:=0;
           FlFontAutoWidth:=false; DefFontAutoWidth:=false;

           CheckSum:=0;  FontDSize:=10.0; FontDUnits:=1.0;

           FlTraceLig:=0;
           FlInclude:=0;
           FlLigTable:=true;
           FlDiscIncl:=false;
           FlagNullDvi:=false;
           FlNoNextChar:=false;
           DefNullDvi:=false;
           DefNoNextChar:=false;

           FlCheckSum:=false;
           FlFontDSize:=false;
           FlFontDUnits:=false;
           FlFontAt:=false;

           DefTraceLig:=false;
           DefInclude:=false;
           DefLigTable:=false;
           DefDiscIncl:=false;

           FlagFontUsed:=false;
           FlagFontInclude:=false;
           FlagCheckSum:=false;
           MapFontMode:=FModeNone;

      end;

      FlagLog:=false;
      FlagLogOut:=false;
      FlagLogScr:=true;
      FlagError:=false;
      FlagSevere:=false;

      InitCharData(CharDataGlb^);

      ptrLigMain:=nil;
      ptrLigBound:=nil;
      ptrLigTable:=nil;

      LigDesignUnitsGlb:=1.0;
      LigDesignSizeGlb:=1.0;

      for i:=0 to 256 do
      begin
           UCharGlb[i]:=false;
           CharIndexArr[i]:=nil;
      end;

      BoundCharGlb:=255;
      FlBoundCharGlb:=false;

      IndexTFMFontGlb:=0;
      FlFontTFMDataGlb:=0;
      FlFontAutoWidthGlb:=false;

      ptrDiscCharGlb:=nil;
      ptrVariableGlb:=nil;

      VTitleGlb:='Created by VFComb [(C) 1993,1996] (Version '+_Version+')';

      FlFontDimen:=false;
      FlCheckSumGlb:=false;

      InitHeadFile(VParamGlb, FontDimenGlb, HFlagsGlb);

end; {InitData}


procedure InitCharData(var FChar : CharDataType);
var i : integer;
begin
      for i:=0 to 255 do
      with FChar[i] do
      begin
           ptrDVI:=nil;
           CharWD:=0.0; CharHT:=0.0; CharDP:=0.0; CharIC:=0.0;
           PKWidth:=0.0;

           marked:=CharNotUsed;
           tempbyte:=0;

           FlAddParm:=0; NextLarger:=0;
           Top:=0; Mid:=0; Bot:=0; Rep:=0;

           FlCharWD:=false; FlCharHT:=false;
           FlCharDP:=false; FlCharIC:=false;

           FlVarChar:=false; FlNextLarger:=false;
           FlTop:=false; FlMid:=false; FlBot:=false; FlRep:=false;

           mapchar:=0;  mapfont:=0;
           sizechar:=0; sizefont:=0;

           DefSizechar:=false; DefSizefont:=false;
           DefMapchar:=false;  DefMapfont:=false;

           FlTFMData:=false; FlAutoWidth:=false; FlPhantom:=false;

           DefFlTFMData:=false; DefAutoWidth:=false;
           DefPKWidth:=false; DefFlPhantom:=false;
           tempbool:=false;

           defined:=false; traced:=false; included:=false;
           twork:=0; {0 - none, 1 - include, 2 - discard}

      end;
end; {InitCharData}

procedure InitHeadFile(var FParam : FontParamRec;
                       var FDim   : FontDimenRec;
                       var HFlags : FontHeadFlags);
begin
      with FDim do
      begin
          Slant:=0.0;  Space:=0.0;  Stretch:=0.0;  Shrink:=0.0;
          XHeight:=0.0;  Quad:=0.0;  ExtraSpace:=0.0;
          Num1:=0.0;  Num2:=0.0;  Num3:=0.0;  Denom1:=0.0;  Denom2:=0.0;
          Sup1:=0.0;  Sup2:=0.0;  Sup3:=0.0;  Sub1:=0.0;  Sub2:=0.0;
          SupDrop:=0.0;  SubDrop:=0.0;  Delim1:=0.0;  Delim2:=0.0;
          AxisHeight:=0.0;
      end;

      with FParam do
      begin
          FontCheckSum:=0;
          FontFamily:='UNSPECIFIED';
          FontFace:=0;
          FontCoding:='UNSPECIFIED';
          FontDesignSize:=10.0;
          FontDesignUnits:=1.0;
          BoundChar:=255;
          FlBoundChar:=false;
      end;

      with HFlags do
      begin
           FlFontCheckSum:=false; FlFontFamily:=false;
           FlFontFace:=false; FlFontCoding:=false;
           FlFontDesignSize:=false; FlFontDesignUnits:=false;
           FlBoundChar:=false;
           FlSlant:=false; FlSpace:=false; FlStretch:=false; FlShrink:=false;
           FlXHeight:=false; FlQuad:=false; FlExtraSpace:=false;
           FlNum1:=false; FlNum2:=false; FlNum3:=false;
           FlDenom1:=false; FlDenom2:=false;
           FlSup1:=false; FlSup2:=false; FlSup3:=false;
           FlSub1:=false; FlSub2:=false;
           FlSupDrop:=false; FlSubDrop:=false;
           FlDelim1:=false; FlDelim2:=false;
           FlAxisHeight:=false;
      end;

end; {InitHeadFile}


end.




