import java.io.*;
import java.awt.*;
import javax.swing.JFrame;

/**
 * <p>
 * Title: Generator for struktogram with Latex
 * </p>
 * 
 * <p>
 * Description: generates from a syntaktikal korrect method, formattet with
 * eclipse with the standard setting stored in a file nn.txt , a file nn.tex.
 * This file could be read and translated with Miktex (c). Erzeugt aus einer
 * syntaktisch korrekten Prozedur, formatiert in Eclipse mit den
 * Standardeinstellungen, die in einem File nn.txt abgespeichert wurde, ein File
 * nn.tex, welches z.B. von MikTex (c) eingelesen und interpretiert werden kann.
 * </p>
 * 
 * <p>
 * Copyright: Peter Lenser Copyright (c) 2006,2012
 * </p>
 * 
 * <p>
 * Company:
 * </p>
 * 
 * @author Peter Lenser
 * @version 1.0
 */

/*
 * Schlsselworte sind: if, else, switch, do, for, while, return
 */
/*
 * keywords are: if, else, switch, do, for, while, return
 */

public class Keyword_reader {
	private StringBuilder the_source = new StringBuilder(10000);
	private String name_source_file;
	private Line start;
	private final int parts_in_ifthenelse = 3;
	private int height_of_the_structogram = 0;
	private int height_of_a_box;
	private int width_of_the_structogram;
	private String headline;

	// reference to a linear list of line (output line)
	// der Startpointer auf eine lineare Liste von line (Ausgabezeile)
	// ifthenelse[height_of_a_box*2]{parts_in_ifthenelse}{parts_in_ifthenelse}

	public Keyword_reader(int pheight_of_a_box, int pwidth_of_a_structogram) {
		height_of_a_box = pheight_of_a_box;
		width_of_the_structogram = pwidth_of_a_structogram;
		/*
		 * generate first and last line
		 */
		/*
		 * generiere erste und letzte Zeile
		 */
		start = new Line("begin{struktogramm}(" + width_of_the_structogram
				+ ",");
		start.set_reference(new Line("end{struktogramm}\\\\ "));
	}

	public void mastermethod() {
		firstline();
		insert_structogram(the_source, start);
		start.appendText(height_of_the_structogram + ")" + headline);
	}

	/**
	 * searches for the next keyword and adds the right piece of the structogram
	 * sucht nach dem naechsten Schluesselwort und fuegt den hierzu gehoerenden
	 * Struktogrammteil ein
	 * 
	 * @param sB
	 *            StringBuffer contains the current Stringbuffer
	 * @param p
	 *            adds the structogram at this position in the linear list
	 * @return Line the new value of p
	 */
	private Line insert_structogram(StringBuilder sB, Line p) {
		while (sB.length() != 0) {
			// the buffer is not empty
			// es ist noch was im Puffer
			String keyword = find_keyword(sB, true);
			// true - removes the keyword from buffer
			// true - loesche das Wort
			if (keyword.equals("if")) {
				p = insert_line_in_latex("ifthenelse[" + 2 * height_of_a_box
						+ "]{" + parts_in_ifthenelse + "}{"
						+ parts_in_ifthenelse + "}{\\"
						+ search_clip_expression(sB) + "\\)}"
						+ "{\\sTrue}{\\sFalse}", p);
				height_of_the_structogram += 2 * height_of_a_box;
				p = insert_structogram(search_part_of_structogram(sB), p);
				p = insert_line_in_latex("change", p);
				String next_keyword = find_keyword(sB, false);
				// looking ahead to the next keyword without removing from
				// buffer
				// System.out.println(next_keyword);
				if (!next_keyword.equals("else")) {
					// if the next keyword is not "else", insert ifend
					// es kommt kein else, also ifend einfuegen
					p = insert_line_in_latex("ifend", p);
				}
			} else if (keyword.equals("else")) {
				p = insert_structogram(search_part_of_structogram(sB), p);
				p = insert_line_in_latex("ifend", p);

			} else if (keyword.equals("switch")) {
				int number_of_cases = 0;
				p = insert_line_in_latex("case[" + 2 * height_of_a_box + "]{",
						p);
				height_of_the_structogram += 2 * height_of_a_box;
				Line p_line_contains_case = p;
				Line p_current_line_case = null;
				String expression_after_switch = search_clip_expression(sB);
				expression_after_switch = expression_after_switch.substring(1);
				// System.out.println(expression_after_switch);
				StringBuilder text_after_switch = search_part_of_structogram(sB);
				/*
				 * text_after_switch contains the the text after switch (..)
				 * including brackets
				 */
				// System.out.println(text_after_switch);
				int pos_case_default = 0;
				int pos_colon = 0;
				boolean first_case = true;
				pos_case_default = text_after_switch.toString().indexOf("case");
				do {
					number_of_cases++;
					text_after_switch.delete(0, pos_case_default + 4);
					pos_colon = text_after_switch.toString().indexOf(":");
					String text_case = text_after_switch
							.substring(0, pos_colon);
					text_after_switch.delete(0, pos_colon + 1);
					p = insert_structogram(
							search_part_of_structogram(text_after_switch), p);
					if (first_case) {
						first_case = false;
						expression_after_switch = expression_after_switch
								+ "}{" + text_case;
					} else {
						p_current_line_case.appendText("{" + text_case + "}");
					}
					pos_case_default = text_after_switch.toString().indexOf(
							"case");
					if (pos_case_default > 0) {
						p = insert_line_in_latex("switch", p);
						p_current_line_case = p;
					}
				} while (pos_case_default > 0);
				String text_angle;
				if ((pos_case_default = text_after_switch.toString().indexOf(
						"default")) > 0) {
					p = insert_line_in_latex("switch", p);
					p_current_line_case = p;
					text_angle = "5";
					number_of_cases++;
					text_after_switch.delete(0, pos_case_default + 7);
					pos_colon = text_after_switch.toString().indexOf(":");
					String text_case = text_after_switch
							.substring(0, pos_colon);
					text_after_switch.delete(0, pos_colon + 1);
					p = insert_structogram(
							search_part_of_structogram(text_after_switch), p);
					p_current_line_case.appendText("{" + text_case + "}");
				} else {
					text_angle = "4";
				}
				expression_after_switch = text_angle + "}{" + number_of_cases
						+ "}{" + expression_after_switch + "}";
				p_line_contains_case.appendText(expression_after_switch);
				p = insert_line_in_latex("caseend", p);

			} else if (keyword.equals("do")) {
				p = insert_line_in_latex("until[" + height_of_a_box + "]{\\(",
						p);
				height_of_the_structogram += height_of_a_box;
				Line p_line_contains_do = p;
				p = insert_structogram(search_part_of_structogram(sB), p);
				p_line_contains_do.appendText(search_condition_do_while(sB)
						+ "\\)}");
				p = insert_line_in_latex("untilend", p);

			} else if (keyword.equals("for")) {
				p = insert_line_in_latex(
						"while[" + height_of_a_box + "]{\\(for \\ "
								+ search_clip_expression(sB) + ")\\)}", p);
				height_of_the_structogram += height_of_a_box;
				p = insert_structogram(search_part_of_structogram(sB), p);
				p = insert_line_in_latex("whileend", p);

			} else if (keyword.equals("while")) {
				p = insert_line_in_latex("while[" + height_of_a_box
						+ "]{\\(while \\ " + search_clip_expression(sB)
						+ ")\\)}", p);
				height_of_the_structogram += height_of_a_box;
				p = insert_structogram(search_part_of_structogram(sB), p);
				p = insert_line_in_latex("whileend", p);

			} else if (keyword.equals("return")) {
				p = insert_line_in_latex("assign["
						+ height_of_a_box
						+ "]{\\(\\gets  "
						+ format_text(new StringBuilder(until_semicolon(sB)
								.trim())) + "\\)}", p);
				height_of_the_structogram += height_of_a_box;

			} else if (keyword.equals("")) {
				// nothing to do
				// hier gibt es nichts zu tun!
			} else {
				p = insert_line_in_latex("assign[" + height_of_a_box + "]{\\("
						+ format_text(new StringBuilder(keyword)) + "\\ "
						+ until_semicolon(sB).trim() + "\\)}", p);
				height_of_the_structogram += height_of_a_box;
			}
		}
		return p;
	}

	/**
	 * fechtes the signature of the method and generates the headline
	 */
	private void firstline() {
		int i = the_source.indexOf("{");
		headline = "["
				+ format_text(new StringBuilder(the_source.substring(0, i)
						.trim())) + "]";
		the_source.delete(0, i);
	}

	/**
	 * insert_line_in_latex inserts in a linear list at the position p the line
	 * s
	 * 
	 * @param s
	 *            String
	 * @param p
	 *            Line
	 * @return Line contains the new position of p
	 */
	private Line insert_line_in_latex(String s, Line p) {
		Line h_p = new Line(s);
		h_p.set_reference(p.read_reference());
		p.set_reference(h_p);
		return h_p;
	}

	/*
	 * find_keyword sucht im Stringbuffer nach einem Wort und gibt das gefundene
	 * Wort zurueck. Falls es kein Schluesselwort war, wird ein Teil einer
	 * Anweisungszeile zurueck gegeben. loesche true -> Loeschen des gefundenen
	 * Teils
	 */
	/**
	 * find_keyword searches for a word in the stringbuffer and gives the word
	 * back. If it was not a keyword, the method gives a part of this line back.
	 * If delete is true, the method deletes the part of the stringbuffer it
	 * gives back.
	 * 
	 * @param sB
	 *            StringBuffer
	 * @param delete
	 *            boolean
	 * @return String
	 */
	private String find_keyword(StringBuilder sB, boolean delete) {
		int i = 0;
		int length = sB.length();
		String keyword;
		/*
		 * brackets {}, space and semikolon do not belong to a keyword
		 */
		/*
		 * ffnende Klammern {, Klammerpaare { }, Leerzeichen und Semikolon
		 * gehoeren nicht zu einem Schluesselwort
		 */
		while ((i < length)
				&& ((sB.charAt(i) == '{') || (sB.charAt(i) == '}')
						|| (sB.charAt(i) == ' ') || (sB.charAt(i) == ';'))) {
			i++;
		}
		// now it searches the end of the word
		// jetzt wird das Ende des Wortes gesucht
		int j = i;
		while ((j < length) && (sB.charAt(j) != ' ')) {
			j++;
		}
		// a semikolon at the end belongs not to the word
		// Falls am Ende ; steht, gehoert ; nicht zum Wort!
		if ((j < length) && (sB.charAt(j - 1) == ';')) {
			keyword = sB.substring(i, j - 1);
			if (delete) {
				sB = sB.delete(0, j - 1);
			}
		} else {
			keyword = sB.substring(i, j);
			if (delete) {
				sB = sB.delete(0, j);
			}
		}
		/*
		 * System.out.println("**keyword: " + keyword + " **lenght: " + length +
		 * " " + sB);
		 */
		return keyword;
	}

	/**
	 * format_text chance := in <- "\gets" ; inserts blanks, insert \ bevore &,
	 * _ , { , } , # , $ ; chance  ,  ,  ,  , "
	 * 
	 * @param sB
	 *            StringBuffer
	 * @return String contains the modified string
	 */
	private String format_text(StringBuilder sB) {
		char token;
		int i = 0;
		sB.append(' ');
		// for simplify the alorithm
		boolean quotation_mark = false;
		while (i < sB.length() - 1) {
			token = sB.charAt(i);
			if (token == ' ') {
				if (sB.charAt(i + 1) == ' ') {
					/*
					 * more then one blank --> delete one blank
					 */
					sB.delete(i, i + 1);
				} else {
					/*
					 * one blank in Latex --> "\ "
					 */
					sB.insert(i, '\\');
					i = i + 2;
				}
			} else if ((token == '&') || (token == '_') || (token == '{')
					|| (token == '#') || (token == '}') || (token == '$')) {
				/*
				 * in Latex we need \ in front of this tokens
				 */
				sB.insert(i, '\\');
				i = i + 2;
			} else if (token == '"') {
				quotation_mark = !quotation_mark;
				sB.delete(i, i + 1);
				sB.insert(i, "``");
				i = i + 2;
			} else if ((quotation_mark) && (token == '\\')) {
				sB.delete(i, i + 1);
				sB.insert(i, "\\backslash ");
				i = i + 11;
			} else if ((token == '')) {// ae
				sB.delete(i, i + 1);
				sB.insert(i, "\"a");
				i = i + 2;
			} else if ((token == '')) {// oe
				sB.delete(i, i + 1);
				sB.insert(i, "\"o");
				i = i + 2;
			} else if ((token == '')) {// ue
				sB.delete(i, i + 1);
				sB.insert(i, "\"u");
				i = i + 2;
			} else if ((token == '')) {// ss
				sB.delete(i, i + 1);
				sB.insert(i, "\\ss");
				i = i + 3;
			}
			/*
			 * looks for assignment; problems: != , == , <= and >= compares
			 */
			else if (token == '=') {
				if (sB.charAt(i + 1) == '=') {
					/*
					 * found ==
					 */
					i = i + 2;
				} else {
					if ((i == 0)
							|| ((i > 0) && (sB.charAt(i - 1) != '!')
									&& (sB.charAt(i - 1) != '<') && (sB
									.charAt(i - 1) != '>'))) {
						/*
						 * it was not "!="; "<=" or ">=", it inserts \gets
						 */
						sB.delete(i, i + 1);
						sB.insert(i, " \\gets ");
						i = i + 8;
					} else {
						i++;
					}
				}
			} else {
				i++;
			}
		}
		// System.out.println("---" + sB + "**");
		return sB.toString().trim();
	}

	/**
	 * search_clip_expression
	 * 
	 * @param sB
	 *            StringBuffer
	 * @return String
	 */
	private String search_clip_expression(StringBuilder sB) {
		int i = 0;
		int open_brace = 1;
		int length = sB.length();
		while ((i < length) && (sB.charAt(i) == ' ')) {
			i++;
		}
		// der Stringbuffer beginnt mit einer Klammer (
		// sB starts with a bracket (
		i++;
		String expression;
		while ((i < length) && (open_brace > 0)) {
			if (sB.charAt(i) == '(') {
				open_brace++;
			} else if (sB.charAt(i) == ')') {
				open_brace--;
			}
			i++;
		}
		expression = format_text(new StringBuilder(sB.substring(1, i - 1)));
		sB = sB.delete(0, i);
		// System.out.println("-->" + expression);
		// System.out.println(sB);
		return expression;
	}

	/*
	 * jump_over prft ob in sB als nchstes ein String oder ein Literal kommt
	 * und gibt die nchste Position nach dem String bzw Literal zurck
	 */
	/*
	 * jump_over checks sB whether in the next position in Sb starts a string or
	 * a literal. Jump over gives the next position after the string or the
	 * literal back
	 */
	/**
	 * jump_over
	 * 
	 * @param sB
	 * @param j
	 * @param length
	 * @return
	 */
	private int jump_over(StringBuilder sB, int j, int length) {
		if (sB.charAt(j) == '\"') {
			// ueberspringen eines Strings
			/*
			 * jumps over a string. Remember strings starts with ". Stops at the
			 * length or at the next
			 * ", but \" is not the end of a string and \\" is the end of a
			 * string!
			 */
			j++;
			while ((j < length)
					&& ((sB.charAt(j) != '\"') || ((sB.charAt(j) == '\"')
							&& (sB.charAt(j - 1) == '\\') && (sB.charAt(j - 2) != '\\')))) {
				j++;
			}
			j++;
		}
		if (sB.charAt(j) == '\'') {
			// ueberspringen eines Literals
			// jumps over a literal
			j++;
			while ((j < length)
					&& ((sB.charAt(j) != '\'') || ((sB.charAt(j) == '\'')
							&& (sB.charAt(j - 1) == '\\') && (sB.charAt(j - 2) != '\\')))) {
				j++;
			}
			j++;
		}
		return j;
	}

	/*
	 * search_part_of_struktogram sucht Teilstruktogramme z.B. in if {_hier_}
	 * else {_hier_};
	 */
	/*
	 * search_part_of_struktogram searches parts of structograms for example in
	 * if {_here_} else {_here_};
	 */
	/**
	 * 
	 * search_part_of_struktogram
	 * 
	 * @param sB
	 *            StringBuffer
	 * @return StringBuffer
	 */
	private StringBuilder search_part_of_structogram(StringBuilder sB) {
		int i = 0;
		int length = sB.length();
		if (length == 0) {
			return new StringBuilder();
		}
		StringBuilder partSb;
		while ((i < length) && sB.charAt(i) == ' ') {
			/*
			 * Leerzeichen sind unwichtig
			 */
			/*
			 * space doesn't care
			 */
			i++;
		}
		if (sB.charAt(i) == '{') {
			/*
			 * Der Ausdruck beginnt mit {
			 */
			/*
			 * the term starts with {
			 */
			int j = i + 1;
			int brace = 1;
			while ((j < length) && (brace > 0)) {
				j = jump_over(sB, j, length);
				if (sB.charAt(j) == '{') {
					brace++;
				} else if (sB.charAt(j) == '}') {
					brace--;
				}
				j++;
			}
			partSb = new StringBuilder(sB.subSequence(i, j).toString().trim());
			sB = sB.delete(0, j);
		} else if (sB.substring(i, i + 2).equals("if")) {
			int j = i + 2;
			while ((j < length) && (sB.charAt(j) != '{')) {
				j = jump_over(sB, j, length);
				j++;
			}
			int number_of_open_brace = 1;
			while ((j < length) && (number_of_open_brace > 0)) {
				j = jump_over(sB, j, length);
				if (sB.charAt(j) == '{') {
					number_of_open_brace++;
				} else if (sB.charAt(j) == '}') {
					number_of_open_brace--;
				}
				j++;
			}
			partSb = new StringBuilder(sB.subSequence(i, j).toString().trim());
			sB = sB.delete(0, j + 1);
		} else {
			/*
			 * Der Ausdruck beginnt nicht mit {
			 */
			/*
			 * the term does not starts with {
			 */
			int j = i;
			while ((j < length) && (sB.charAt(j) != ';')) {
				j = jump_over(sB, j, length);
				j++;
			}
			partSb = new StringBuilder(sB.subSequence(0, j + 1).toString()
					.trim());
			sB = sB.delete(0, j + 1);
		}
		// System.out.println("Part of structogram: " + partSb + "**");
		// System.out.println(sB);
		return partSb;
	}

	/*
	 * search_condition_do_while wird nur bei do...while benoetigt, da hier die
	 * Bedingung nach while steht, aber in Struktex beim Schleifenstart mit
	 * einer Referenz eingefuegt wird
	 */
	/*
	 * search the condition in a do while statement. The condition will be
	 * append to the correct line using a reference to the line
	 */
	/**
	 * @param sB
	 *            StringBuilder
	 * 
	 * @return String
	 */
	private String search_condition_do_while(StringBuilder sB) {
		int pos = sB.indexOf("while");
		sB.delete(0, pos + 6);
		String text = search_clip_expression(sB);
		// System.out.println(text);
		return text;
	}

	/*
	 * until_semicolon findet den Rest der Anweisung, falls das Wort kein
	 * Schluesselwort kein Schlsselwort war.
	 */
	/*
	 * until_semicolon searches for the rest of the assignment in case of having
	 * no keyword yet
	 */
	/**
	 * @param sB
	 *            StringBuilder
	 * @return String
	 */
	private String until_semicolon(StringBuilder sB) {
		int i = 0;
		int length = sB.length();
		String word;
		while ((i < length) && (sB.charAt(i) != ';')) {
			i++;
		}
		word = format_text(new StringBuilder(sB.substring(0, i)));
		sB = sB.delete(0, i + 1);
		return word;
	}

	/**
	 * read_file 
	 * 
	 * @param gui
	 *            JFrame
	 * @param path_absolute
	 *            String
	 * @returns the chosen path
	 */
	public String read_file(JFrame gui, String path_absolute) {
		String s;
		int pos_singleline_comment;
		/*
		 * pos_singleline_comment = -1: in this line is no comment
		 * pos_singleline_comment = 0: the comment starts in the first position
		 * pos_singleline_comment = +1: the comment starts in a position > 0
		 */
		boolean multiline_comment = false;
		BufferedReader f = null;
		FileDialog fd = new FileDialog(gui, "choose the file to read",
				FileDialog.LOAD);
		fd.setDirectory(path_absolute);
		fd.setVisible(true);
		if (fd.getFile() != null) {
			try {
				name_source_file = fd.getFile();
				name_source_file = name_source_file.substring(0,
						name_source_file.length() - 4);
				// remove .txt
				// .txt wird abgeschnitten
				path_absolute = fd.getDirectory();
				f = new BufferedReader(new FileReader(fd.getDirectory()
						+ fd.getFile()));
				while ((s = f.readLine()) != null) {
					s = s.replace('\t', ' ');
					// change tab to space
					// Tabulator durch Leerzeichen ersetzen
					if (!multiline_comment) {
						/*
						 * remove remarks; after finding /* multiline_comment is
						 * true
						 */
						/*
						 * Kommentare entfernen; multiline_comment ist true,
						 * wenn bereits /* entdeckt wurde
						 */
						if (s.indexOf("/*") > -1) {
							multiline_comment = true;
							s = s.substring(0, s.indexOf("/*")).trim();
							if (s.length() > 0) {
								the_source.append(s);
							}
						} else {
							pos_singleline_comment = s.indexOf("//");
							switch (pos_singleline_comment) {
							case -1: {
								the_source.append(s);
								break;
							}
							case 0:
								break;
							default: {
								s = s.substring(0, pos_singleline_comment);
								the_source.append(s);
								break;
							}
							}
						}
					} else {
						if (s.indexOf("*/") != -1) {
							multiline_comment = false;
							s = s.substring(s.indexOf("*/"), s.length());
							the_source.append(s);
						}
					}
					// System.out.println(the_source);
				}
			} catch (IOException e2) {
				NewJDialog dialog = new NewJDialog(gui, "Error reading file");
				dialog.setVisible(true);

			} finally {
				try {
					if (f != null) {
						f.close();
					}
				} catch (IOException e) {
				}
			}
			return fd.getDirectory();
		} else
			return null;
	}

	/**
	 * store_file
	 * 
	 * @param gui
	 *            JFrame
	 * @param path_absolute
	 *            String
	 * @param portrait
	 *            boolean
	 * @param font_height
	 *            String
	 * 
	 */
	public void store_file(JFrame gui, String path_absolute, boolean portrait,
			String font_height) {
		String s;
		Line p = start;
		BufferedWriter f = null;
		FileDialog fd = new FileDialog(gui, "choose the filename",
				FileDialog.SAVE);
		fd.setFile(name_source_file + ".tex");
		fd.setDirectory(path_absolute);
		fd.setVisible(true);
		if (fd.getFile() != null) {
			try {
				s = fd.getFile().toLowerCase();
				// or with endswith(".tex")
				// oder mit endswith(".tex")
				if (s.indexOf(".tex") == -1) {
					s = s + ".tex";
				}
				f = new BufferedWriter(new FileWriter(fd.getDirectory() + s));
				if (portrait) {
					f.write("\\documentclass[a4paper,11pt]{letter}" + "\r\n");
				} else {
					f.write("\\documentclass[landscape,11pt]{letter}" + "\r\n");
				}
				;
				BufferedReader fr = null;
				try {
					fr = new BufferedReader(new FileReader("firstlines.txt"));
				} catch (FileNotFoundException e) {
					NewJDialog dialog = new NewJDialog(gui,
							"Error reading firstline.txt");
					dialog.setVisible(true);
					e.printStackTrace();
				}
				try {
					while ((s = fr.readLine()) != null) {
						f.write(s + "\r\n");
					}
					fr.close();
				} catch (IOException e) {
					NewJDialog dialog = new NewJDialog(gui,
							"Error writing file");
					dialog.setVisible(true);
					e.printStackTrace();
				}
				f.write("\\begin{document}" + "\r\n");
				f.write("\\" + font_height + "\r\n");
				while (p != null) {
					f.write(p.toString());
					p = p.read_reference();
				}
				f.write("\\end{document}" + "\r\n");
			} catch (IOException e2) {
				NewJDialog dialog = new NewJDialog(gui, "Error writing file");
				dialog.setVisible(true);

			} finally {
				try {
					if (f != null) {
						f.close();
					}
				} catch (IOException e) {
				}
			}
		}
	}

}
