/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.nlctdoc;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.GenericCommand;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.latex.FrameBox;
import com.dickimawbooks.texparserlib.latex.FrameBoxEnv;
import com.dickimawbooks.texparserlib.latex.glossaries.GlossariesSty;
import com.dickimawbooks.texparserlib.latex.glossaries.GlossaryEntry;
import com.dickimawbooks.texparserlib.latex.glossaries.GlsLabel;
import com.dickimawbooks.texparserlib.latex.nlctdoc.StandaloneDef;
import com.dickimawbooks.texparserlib.latex.nlctdoc.TaggedColourBox;
import java.io.IOException;

public class CmdDef
extends StandaloneDef {
    public CmdDef(FrameBoxEnv frameBoxEnv, FrameBox frameBox, FrameBox frameBox2, GlossariesSty glossariesSty) {
        this("cmddef", frameBoxEnv, frameBox, frameBox2, glossariesSty);
    }

    public CmdDef(String string, FrameBoxEnv frameBoxEnv, FrameBox frameBox, FrameBox frameBox2, GlossariesSty glossariesSty) {
        super(string, frameBoxEnv, frameBox, frameBox2, glossariesSty);
    }

    @Override
    public Object clone() {
        return new CmdDef(this.getName(), this.outerBox, this.rightBox, this.noteBox, this.getSty());
    }

    @Override
    protected void addPostEntryName(TeXObjectList teXObjectList, GlsLabel glsLabel, TeXParser teXParser) {
        TeXObject teXObject = glsLabel.getField("syntax");
        if (teXObject != null) {
            teXObjectList.add(teXObject, true);
        }
    }

    @Override
    protected void postArgHook(GlsLabel glsLabel, TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        if (this.outerBox instanceof TaggedColourBox) {
            String string;
            TaggedColourBox taggedColourBox = (TaggedColourBox)this.outerBox;
            TeXObject teXObject = glsLabel.getField("status");
            TeXObjectList teXObjectList2 = null;
            if (teXObject != null && !(string = teXParser.expandToString(teXObject, teXParser)).equals("default")) {
                teXObjectList2 = teXParser.getListener().createStack();
                teXObjectList2.add(teXParser.getListener().getControlSequence("icon"));
                teXObjectList2.add(teXParser.getListener().createGroup(string));
            }
            if (teXObjectList2 == null) {
                taggedColourBox.restoreTitle();
            } else {
                taggedColourBox.setTitle(teXObjectList2);
            }
        }
    }

    @Override
    protected void initHook(GlsLabel glsLabel, TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        teXParser.putControlSequence(true, new GenericCommand(true, "explTFsuffix", null, TeXParserUtils.createStack(teXParser, new TeXCsRef("@explboolsyntaxfmt"), teXParser.getListener().createGroup("TF"))));
    }

    @Override
    protected void preNote(TeXObjectList teXObjectList, GlsLabel glsLabel, TeXParser teXParser) throws IOException {
        TeXObject teXObject;
        GlossaryEntry glossaryEntry = glsLabel.getEntry();
        if (glossaryEntry != null && (teXObject = glossaryEntry.get("explsuffix")) != null && !teXObject.isEmpty()) {
            Group group = teXParser.getListener().createGroup();
            teXObjectList.add(group);
            group.add(teXParser.getListener().getControlSequence("def"));
            group.add(new TeXCsRef("explsuffix"));
            group.add(teXParser.getListener().createGroup(teXParser.expandToString(teXObject, teXParser)));
            group.add(teXParser.getListener().getControlSequence("def"));
            group.add(new TeXCsRef("explTFsuffix"));
            group.add(teXParser.getListener().createGroup());
            group.add(teXParser.getListener().getControlSequence("def"));
            group.add(new TeXCsRef("TFsuffix"));
            group.add(teXParser.getListener().createGroup());
            group.add(teXParser.getListener().getControlSequence("newline"));
            group.add(teXParser.getListener().getControlSequence("code"));
            group.add(TeXParserUtils.createGroup(teXParser, glossaryEntry.get("name"), glossaryEntry.get("syntax")));
        }
    }

    @Override
    protected ControlSequence getNoteFmt(TeXParser teXParser) {
        return teXParser.getControlSequence("cmdnotefmt");
    }
}

