/*
 * Decompiled with CFR 0.152.
 */
package de.nm.ant.ipdf.range;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;

public class PageRange {
    private static final String WRONG_EXPRESSION = "page range: wrong expression ";
    private int maxPage = Integer.MAX_VALUE;
    private ArrayList<Integer> notlist = null;
    private String pages = null;
    private ArrayList<Range> parr = null;

    public PageRange(String pagerange) {
        this.pages = pagerange;
    }

    public PageRange() {
        this.pages = null;
    }

    public PageRange(String pagerange, int maxpage) {
        this.pages = pagerange;
        this.maxPage = maxpage;
    }

    public int getMaxPage() {
        return this.maxPage;
    }

    public boolean isPageinRange(int page) {
        if (this.pages == null) {
            return true;
        }
        this.parsePages();
        if (this.notlist != null && this.notlist.contains(page)) {
            return false;
        }
        for (Range r : this.parr) {
            if (!r.check(page)) continue;
            return true;
        }
        return false;
    }

    private void parseNot(String part) throws BuildException {
        String nstring = part.replace("!", "");
        try {
            int n = Integer.parseInt(nstring);
            if (this.notlist == null) {
                this.notlist = new ArrayList();
            }
            this.notlist.add(n);
        }
        catch (NumberFormatException e) {
            throw new BuildException(WRONG_EXPRESSION + this.pages);
        }
    }

    private void parseNumber(String part) throws BuildException {
        try {
            int n = part.equals("*") || part.length() == 0 ? this.maxPage : Integer.parseInt(part);
            this.parr.add(new Range(n));
        }
        catch (NumberFormatException e) {
            throw new BuildException(WRONG_EXPRESSION + this.pages);
        }
    }

    private void parsePages() {
        if (this.parr == null) {
            this.parr = new ArrayList();
            StringTokenizer tok = new StringTokenizer(this.pages, ",");
            while (tok.hasMoreElements()) {
                String part = tok.nextToken().trim();
                if (part.matches("[\\d\\*oe!]+")) {
                    if (part.equalsIgnoreCase("o")) {
                        this.parr.add(new Range('o'));
                        continue;
                    }
                    if (part.equalsIgnoreCase("e")) {
                        this.parr.add(new Range('e'));
                        continue;
                    }
                    if (part.matches("!\\d+")) {
                        this.parseNot(part);
                        continue;
                    }
                    this.parseNumber(part);
                    continue;
                }
                if (part.matches("[\\d\\*]+\\s*-\\s*[\\d\\*]*")) {
                    this.parseRange(part);
                    continue;
                }
                throw new BuildException(WRONG_EXPRESSION + this.pages);
            }
        }
    }

    private void parseRange(String part) throws BuildException {
        String[] n = part.split("-", 2);
        int a = n[0].trim().equals("*") || n[0].trim().length() == 0 ? this.maxPage : Integer.parseInt(n[0]);
        int b = n[1].trim().equals("*") || n[1].trim().length() == 0 ? this.maxPage : Integer.parseInt(n[1]);
        this.parr.add(new Range(a, b));
    }

    public void setMaxPage(int maxPage) {
        this.maxPage = maxPage;
    }

    public String toString() {
        return this.pages == null ? "---" : this.pages;
    }

    private class Range {
        private Integer end = null;
        private Integer start = null;
        private char type = (char)32;

        public Range(char t) {
            this.type = t;
        }

        public Range(int s) {
            this.start = s;
        }

        public Range(int s, int e) {
            this.start = s;
            this.end = e;
        }

        public boolean check(int p) {
            if (p <= 0) {
                return false;
            }
            if (this.type == 'o') {
                return p % 2 == 1 && p <= PageRange.this.maxPage;
            }
            if (this.type == 'e') {
                return p % 2 == 0 && p <= PageRange.this.maxPage;
            }
            if (this.end == null && this.start == null) {
                return false;
            }
            if (this.end == null) {
                return this.start == p;
            }
            return p >= this.start && p <= this.end;
        }
    }
}

