/*
 * Decompiled with CFR 0.152.
 */
package de.nm.ant.files;

import de.nm.ant.AbstractWorkerTask;
import de.nm.file.XFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;

public class CopyNamespaceTask
extends AbstractWorkerTask {
    protected final List<FileSet> fileset = new ArrayList<FileSet>();
    private File toDir = null;
    private final boolean replace = false;

    public void addFileset(FileSet set) {
        this.fileset.add(set);
    }

    public void execute() {
        if (this.toDir == null) {
            throw new BuildException("'todir' not!");
        }
        this.logVerboseHeader("copy namespace files");
        try {
            for (FileSet fs : this.fileset) {
                DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
                String[] files = ds.getIncludedFiles();
                File dir = ds.getBasedir();
                for (String f : files) {
                    File src = this.createFile(dir, f);
                    File dest = this.createFile(this.toDir, f.replace('/', '_').replace('\\', '_'));
                    this.logVerbose(src, dest);
                    XFile.copy((File)src, (File)dest);
                }
            }
        }
        catch (IOException e) {
            this.throwBuildException(e);
        }
    }

    public void setToDir(File toDir) {
        this.toDir = toDir;
    }
}

