/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.geometry;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.DimenRegister;
import com.dickimawbooks.texparserlib.FixedUnit;
import com.dickimawbooks.texparserlib.TeXDimension;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.TeXUnit;
import com.dickimawbooks.texparserlib.UserDimension;
import com.dickimawbooks.texparserlib.latex.KeyValList;
import com.dickimawbooks.texparserlib.latex.LaTeXParserListener;
import com.dickimawbooks.texparserlib.latex.LaTeXSty;
import com.dickimawbooks.texparserlib.latex.LaTeXSyntaxException;
import com.dickimawbooks.texparserlib.latex.geometry.Geometry;
import java.awt.geom.Rectangle2D;
import java.io.IOException;

public class GeometrySty
extends LaTeXSty {
    boolean includehead = false;
    boolean includefoot = false;
    boolean includemp = false;

    public GeometrySty(KeyValList keyValList, LaTeXParserListener laTeXParserListener, boolean bl) throws IOException {
        super(keyValList, "geometry", laTeXParserListener, bl);
    }

    @Override
    public void addDefinitions() {
        TeXParser teXParser = this.getParser();
        this.defOrSetDimenReg(7, "paperwidth", 614.295f, TeXUnit.PT);
        this.defOrSetDimenReg(8, "paperheight", 794.97f, TeXUnit.PT);
        this.defOrSetDimenReg(2, "textwidth", 430.0046f, TeXUnit.PT);
        this.defOrSetDimenReg(4, "textheight", 556.47656f, TeXUnit.PT);
        this.defOrSetDimenReg(9, "marginparwidth", 65.0f, TeXUnit.PT);
        this.defOrSetDimenReg("marginparsep", 11.0f, TeXUnit.PT);
        this.defOrSetDimenReg("oddsidemargin", 19.8752f, TeXUnit.PT);
        this.defOrSetDimenReg("evensidemargin", 19.8752f, TeXUnit.PT);
        this.defOrSetDimenReg("topmargin", -13.87262f, TeXUnit.PT);
        this.defOrSetDimenReg("headheight", 12.0f, TeXUnit.PT);
        this.defOrSetDimenReg("headsep", 25.0f, TeXUnit.PT);
        this.defOrSetDimenReg("footskip", 30.0f, TeXUnit.PT);
        this.registerControlSequence(new Geometry(this));
    }

    protected void defOrSetDimenReg(String string, float f, TeXUnit teXUnit) {
        TeXParser teXParser = this.getParser();
        DimenRegister dimenRegister = teXParser.getDimenRegister(string);
        if (dimenRegister == null) {
            this.registerNewLength(string, f, teXUnit);
        } else {
            try {
                dimenRegister.setValue(this.getParser(), f, teXUnit);
            }
            catch (TeXSyntaxException teXSyntaxException) {
                this.getParser().warning(teXSyntaxException);
            }
        }
    }

    protected void defOrSetDimenReg(int n, String string, float f, TeXUnit teXUnit) {
        this.defOrSetDimenReg(string, f, teXUnit);
        try {
            this.listener.setPageDimension(n, teXUnit.toUnit(this.getParser(), f, FixedUnit.BP));
        }
        catch (TeXSyntaxException teXSyntaxException) {
            this.getParser().warning(teXSyntaxException);
        }
    }

    @Override
    public void processOptions(KeyValList keyValList) throws IOException {
        this.processOptions(keyValList, null);
    }

    public void processOptions(KeyValList keyValList, TeXObjectList teXObjectList) throws IOException {
        TeXDimension teXDimension;
        TeXObject teXObject;
        Object object;
        if (keyValList == null) {
            return;
        }
        TeXParser teXParser = this.getParser();
        Boolean bl = null;
        TeXDimension teXDimension2 = null;
        TeXDimension teXDimension3 = null;
        TeXDimension teXDimension4 = null;
        TeXDimension teXDimension5 = null;
        TeXDimension teXDimension6 = null;
        TeXDimension teXDimension7 = null;
        TeXDimension teXDimension8 = null;
        TeXDimension teXDimension9 = null;
        TeXDimension teXDimension10 = null;
        TeXDimension teXDimension11 = null;
        TeXDimension teXDimension12 = null;
        TeXDimension teXDimension13 = null;
        Object object2 = keyValList.getOrderedKeyIterator();
        while (object2.hasNext()) {
            object = object2.next();
            teXObject = (TeXObject)keyValList.get(object);
            if (((String)object).equals("paper") || ((String)object).equals("papername")) {
                this.setPaperSize(teXParser.expandToString(teXObject, teXObjectList));
                teXDimension2 = this.getPaperWidth();
                teXDimension3 = this.getPaperHeight();
                continue;
            }
            if (((String)object).equals("portrait")) {
                if (teXObject == null) {
                    bl = Boolean.TRUE;
                    continue;
                }
                bl = Boolean.valueOf(teXObject.toString(teXParser));
                continue;
            }
            if (((String)object).equals("landscape")) {
                if (teXObject == null) {
                    bl = Boolean.FALSE;
                    continue;
                }
                bl = Boolean.valueOf(teXObject.toString(teXParser)) == false;
                continue;
            }
            if (((String)object).equals("headheight") || ((String)object).equals("head")) {
                this.setDimension("headheight", TeXParserUtils.toTeXDimension(teXObject, teXParser, teXObjectList));
                continue;
            }
            if (((String)object).equals("headsep")) {
                this.setDimension("headsep", TeXParserUtils.toTeXDimension(teXObject, teXParser, teXObjectList));
                continue;
            }
            if (((String)object).equals("nohead")) {
                this.setDimension("headheight", new UserDimension(0.0f, (TeXUnit)FixedUnit.PT));
                this.setDimension("headsep", new UserDimension(0.0f, (TeXUnit)FixedUnit.PT));
                continue;
            }
            if (((String)object).equals("footskip") || ((String)object).equals("foot")) {
                this.setDimension("footskip", TeXParserUtils.toTeXDimension(teXObject, teXParser, teXObjectList));
                continue;
            }
            if (((String)object).equals("nofoot")) {
                this.setDimension("footskip", new UserDimension(0.0f, (TeXUnit)FixedUnit.PT));
                continue;
            }
            if (((String)object).equals("noheadfoot")) {
                this.setDimension("headheight", new UserDimension(0.0f, (TeXUnit)FixedUnit.PT));
                this.setDimension("headsep", new UserDimension(0.0f, (TeXUnit)FixedUnit.PT));
                this.setDimension("footskip", new UserDimension(0.0f, (TeXUnit)FixedUnit.PT));
                continue;
            }
            if (((String)object).equals("footnotesep")) continue;
            if (((String)object).equals("marginparwidth") || ((String)object).equals("marginpar")) {
                this.setDimension("marginparwidth", TeXParserUtils.toTeXDimension(teXObject, teXParser, teXObjectList));
                continue;
            }
            if (((String)object).equals("marginparsep")) {
                this.setDimension("marginparsep", TeXParserUtils.toTeXDimension(teXObject, teXParser, teXObjectList));
                continue;
            }
            if (((String)object).equals("nomarginpar")) {
                this.setDimension("marginparwidth", new UserDimension(0.0f, (TeXUnit)FixedUnit.PT));
                this.setDimension("marginparsep", new UserDimension(0.0f, (TeXUnit)FixedUnit.PT));
                continue;
            }
            if (((String)object).equals("columnsep")) {
                this.setDimension("columnsep", TeXParserUtils.toTeXDimension(teXObject, teXParser, teXObjectList));
                continue;
            }
            if (((String)object).equals("voffset")) {
                this.setDimension("voffset", TeXParserUtils.toTeXDimension(teXObject, teXParser, teXObjectList));
                continue;
            }
            if (((String)object).equals("hoffset")) {
                this.setDimension("hoffset", TeXParserUtils.toTeXDimension(teXObject, teXParser, teXObjectList));
                continue;
            }
            if (((String)object).equals("offset")) {
                teXDimension = TeXParserUtils.toTeXDimension(teXObject, teXParser, teXObjectList);
                this.setDimension("hoffset", teXDimension);
                this.setDimension("voffset", teXDimension);
                continue;
            }
            if (((String)object).equals("textwidth")) {
                teXDimension4 = TeXParserUtils.toTeXDimension(teXObject, teXParser, teXObjectList);
                continue;
            }
            if (((String)object).equals("textheight")) {
                teXDimension5 = TeXParserUtils.toTeXDimension(teXObject, teXParser, teXObjectList);
                continue;
            }
            if (((String)object).equals("width")) {
                teXDimension6 = TeXParserUtils.toTeXDimension(teXObject, teXParser, teXObjectList);
                continue;
            }
            if (((String)object).equals("height")) {
                teXDimension7 = TeXParserUtils.toTeXDimension(teXObject, teXParser, teXObjectList);
                continue;
            }
            if (((String)object).equals("totalwidth")) {
                teXDimension8 = TeXParserUtils.toTeXDimension(teXObject, teXParser, teXObjectList);
                continue;
            }
            if (((String)object).equals("totalheight")) {
                teXDimension9 = TeXParserUtils.toTeXDimension(teXObject, teXParser, teXObjectList);
                continue;
            }
            if (((String)object).equals("left") || ((String)object).equals("lmargin") || ((String)object).equals("inner")) {
                teXDimension10 = TeXParserUtils.toTeXDimension(teXObject, teXParser, teXObjectList);
                continue;
            }
            if (((String)object).equals("right") || ((String)object).equals("rmargin") || ((String)object).equals("outer")) {
                teXDimension11 = TeXParserUtils.toTeXDimension(teXObject, teXParser, teXObjectList);
                continue;
            }
            if (((String)object).equals("top") || ((String)object).equals("tmargin")) {
                teXDimension12 = TeXParserUtils.toTeXDimension(teXObject, teXParser, teXObjectList);
                continue;
            }
            if (((String)object).equals("bottom") || ((String)object).equals("bmargin")) {
                teXDimension13 = TeXParserUtils.toTeXDimension(teXObject, teXParser, teXObjectList);
                continue;
            }
            if (((String)object).equals("hmargin") || ((String)object).equals("vmargin") || ((String)object).equals("margin") || ((String)object).equals("hmarginratio") || ((String)object).equals("vmarginratio") || ((String)object).equals("marginratio") || ((String)object).equals("ratio") || ((String)object).equals("hcentering") || ((String)object).equals("vcentering") || ((String)object).equals("centering") || ((String)object).equals("reversemp") || ((String)object).equals("reversemarginpar") || ((String)object).equals("onecolumn") || ((String)object).equals("twocolumn") || ((String)object).equals("twoside") || ((String)object).equals("asymmetric") || ((String)object).equals("bindingoffset") || ((String)object).equals("hdivide") || ((String)object).equals("vdivide") || ((String)object).equals("divide")) continue;
            if (((String)object).equals("includehead")) {
                if (teXObject == null) {
                    this.includehead = true;
                    continue;
                }
                this.includehead = Boolean.parseBoolean(teXObject.toString(teXParser));
                continue;
            }
            if (((String)object).equals("includefoot")) {
                if (teXObject == null) {
                    this.includefoot = true;
                    continue;
                }
                this.includefoot = Boolean.parseBoolean(teXObject.toString(teXParser));
                continue;
            }
            if (((String)object).equals("includeheadfoot")) {
                this.includehead = teXObject == null ? true : Boolean.parseBoolean(teXObject.toString(teXParser));
                this.includefoot = this.includehead;
                continue;
            }
            if (((String)object).equals("includemp")) {
                if (teXObject == null) {
                    this.includemp = true;
                    continue;
                }
                this.includemp = Boolean.parseBoolean(teXObject.toString(teXParser));
                continue;
            }
            if (((String)object).equals("includeall")) {
                this.includehead = teXObject == null ? true : Boolean.parseBoolean(teXObject.toString(teXParser));
                this.includefoot = this.includehead;
                this.includemp = this.includehead;
                continue;
            }
            if (((String)object).equals("ignorehead")) {
                if (teXObject == null) {
                    this.includehead = false;
                    continue;
                }
                this.includehead = !Boolean.parseBoolean(teXObject.toString(teXParser));
                continue;
            }
            if (((String)object).equals("ignorefoot")) {
                if (teXObject == null) {
                    this.includefoot = false;
                    continue;
                }
                this.includefoot = !Boolean.parseBoolean(teXObject.toString(teXParser));
                continue;
            }
            if (((String)object).equals("ignoreheadfoot")) {
                this.includehead = teXObject == null ? false : !Boolean.parseBoolean(teXObject.toString(teXParser));
                this.includefoot = this.includehead;
                continue;
            }
            if (((String)object).equals("ignoremp")) {
                if (teXObject == null) {
                    this.includemp = false;
                    continue;
                }
                this.includemp = !Boolean.parseBoolean(teXObject.toString(teXParser));
                continue;
            }
            if (((String)object).equals("ignoreall")) {
                this.includehead = teXObject == null ? false : !Boolean.parseBoolean(teXObject.toString(teXParser));
                this.includefoot = this.includehead;
                this.includemp = this.includehead;
                continue;
            }
            if (((String)object).equals("heightrounded") || ((String)object).equals("hdivide") || ((String)object).equals("vdivide") || ((String)object).equals("divide") || ((String)object).equals("driver") || ((String)object).equals("dvips") || ((String)object).equals("dvipdfm") || ((String)object).equals("pdftex") || ((String)object).equals("luatex") || ((String)object).equals("xetex") || ((String)object).equals("vtex") || ((String)object).equals("verbose") || ((String)object).equals("mag") || ((String)object).equals("truedim") || ((String)object).equals("pass") || ((String)object).equals("showframe") || ((String)object).equals("showcrop") || teXObject != null) continue;
            this.setPaperSize(teXParser.expandToString(teXObject, teXObjectList));
            teXDimension2 = this.getPaperWidth();
            teXDimension3 = this.getPaperHeight();
        }
        if (teXDimension2 == null && (teXDimension2 = this.getPaperWidth()) == null) {
            teXDimension2 = new UserDimension(210.0f, (TeXUnit)TeXUnit.MM);
        }
        if (teXDimension3 == null && (teXDimension3 = this.getPaperHeight()) == null) {
            teXDimension3 = new UserDimension(297.0f, (TeXUnit)TeXUnit.MM);
        }
        if (bl != null) {
            if (bl.booleanValue()) {
                if (!this.isPortrait()) {
                    this.swapOrientation();
                }
            } else if (!this.isLandscape()) {
                this.swapOrientation();
            }
        }
        if (teXDimension6 != null && teXDimension8 == null) {
            if (this.includemp) {
                object2 = teXDimension6.getUnit();
                object = this.getDimension("marginparwidth");
                teXObject = this.getDimension("marginparsep");
                teXDimension8 = new UserDimension(teXDimension6.getValue() + ((TeXUnit)object2).fromUnit(teXParser, object.getValue(), object.getUnit()) + ((TeXUnit)object2).fromUnit(teXParser, teXObject.getValue(), teXObject.getUnit()), (TeXUnit)object2);
            } else {
                teXDimension8 = teXDimension6;
            }
            teXDimension4 = teXDimension6;
        } else if (teXDimension8 != null) {
            if (this.includemp) {
                object2 = teXDimension8.getUnit();
                object = this.getDimension("marginparwidth");
                teXObject = this.getDimension("marginparsep");
                teXDimension4 = new UserDimension(teXDimension8.getValue() - ((TeXUnit)object2).fromUnit(teXParser, object.getValue(), object.getUnit()) - ((TeXUnit)object2).fromUnit(teXParser, teXObject.getValue(), teXObject.getUnit()), (TeXUnit)object2);
            } else {
                teXDimension4 = teXDimension8;
            }
        }
        if (teXDimension4 == null && teXDimension10 != null && teXDimension11 != null) {
            object2 = teXDimension2.getUnit();
            teXDimension4 = new UserDimension(teXDimension2.getValue() - teXDimension10.getUnit().toUnit(teXParser, teXDimension10.getValue(), (TeXUnit)object2) - teXDimension11.getUnit().toUnit(teXParser, teXDimension11.getValue(), (TeXUnit)object2), (TeXUnit)object2);
        }
        if (teXDimension4 != null) {
            this.setDimension("textwidth", teXDimension4);
        } else {
            teXDimension4 = this.getTextWidth();
        }
        if (teXDimension7 != null && teXDimension9 == null) {
            if (this.includehead && this.includefoot) {
                object2 = teXDimension7.getUnit();
                object = this.getDimension("headheight");
                teXObject = this.getDimension("headsep");
                teXDimension = this.getDimension("footskip");
                teXDimension9 = new UserDimension(teXDimension7.getValue() + ((TeXUnit)object2).fromUnit(teXParser, object.getValue(), object.getUnit()) + ((TeXUnit)object2).fromUnit(teXParser, teXObject.getValue(), teXObject.getUnit()) + ((TeXUnit)object2).fromUnit(teXParser, teXDimension.getValue(), teXDimension.getUnit()), (TeXUnit)object2);
            } else if (this.includehead) {
                object2 = teXDimension7.getUnit();
                object = this.getDimension("headheight");
                teXObject = this.getDimension("headsep");
                teXDimension9 = new UserDimension(teXDimension7.getValue() + ((TeXUnit)object2).fromUnit(teXParser, object.getValue(), object.getUnit()) + ((TeXUnit)object2).fromUnit(teXParser, teXObject.getValue(), teXObject.getUnit()), (TeXUnit)object2);
            } else if (this.includefoot) {
                object2 = teXDimension7.getUnit();
                object = this.getDimension("footskip");
                teXDimension9 = new UserDimension(teXDimension7.getValue() + ((TeXUnit)object2).fromUnit(teXParser, object.getValue(), object.getUnit()), (TeXUnit)object2);
            } else {
                teXDimension9 = teXDimension7;
            }
            teXDimension5 = teXDimension7;
        } else if (teXDimension9 != null) {
            if (this.includehead && this.includefoot) {
                object2 = teXDimension9.getUnit();
                object = this.getDimension("headheight");
                teXObject = this.getDimension("headsep");
                teXDimension = this.getDimension("footskip");
                teXDimension5 = new UserDimension(teXDimension9.getValue() - ((TeXUnit)object2).fromUnit(teXParser, object.getValue(), object.getUnit()) - ((TeXUnit)object2).fromUnit(teXParser, teXObject.getValue(), teXObject.getUnit()) - ((TeXUnit)object2).fromUnit(teXParser, teXDimension.getValue(), teXDimension.getUnit()), (TeXUnit)object2);
            } else if (this.includehead) {
                object2 = teXDimension9.getUnit();
                object = this.getDimension("headheight");
                teXObject = this.getDimension("headsep");
                teXDimension5 = new UserDimension(teXDimension9.getValue() - ((TeXUnit)object2).fromUnit(teXParser, object.getValue(), object.getUnit()) - ((TeXUnit)object2).fromUnit(teXParser, teXObject.getValue(), teXObject.getUnit()), (TeXUnit)object2);
            } else if (this.includefoot) {
                object2 = teXDimension9.getUnit();
                object = this.getDimension("footskip");
                teXDimension5 = new UserDimension(teXDimension9.getValue() - ((TeXUnit)object2).fromUnit(teXParser, object.getValue(), object.getUnit()), (TeXUnit)object2);
            } else {
                teXDimension5 = teXDimension9;
            }
        }
        if (teXDimension5 == null && teXDimension12 != null && teXDimension13 != null) {
            object2 = teXDimension3.getUnit();
            teXDimension5 = new UserDimension(teXDimension3.getValue() - teXDimension12.getUnit().toUnit(teXParser, teXDimension12.getValue(), (TeXUnit)object2) - teXDimension13.getUnit().toUnit(teXParser, teXDimension13.getValue(), (TeXUnit)object2), (TeXUnit)object2);
        }
        if (teXDimension5 != null) {
            this.setDimension("textheight", teXDimension5);
        } else {
            teXDimension5 = this.getTextHeight();
        }
        if (teXDimension10 != null) {
            object2 = teXDimension2.getUnit();
            this.setDimension("oddsidemargin", teXDimension10.getUnit().toUnit(teXParser, teXDimension10.getValue(), (TeXUnit)object2) - TeXUnit.IN.toUnit(teXParser, 1.0f, (TeXUnit)object2), (TeXUnit)object2);
            this.setDimension("evensidemargin", teXDimension2.getValue() - teXDimension8.getUnit().toUnit(teXParser, teXDimension8.getValue(), (TeXUnit)object2) - teXDimension10.getUnit().toUnit(teXParser, teXDimension10.getValue(), (TeXUnit)object2) - TeXUnit.IN.toUnit(teXParser, 1.0f, (TeXUnit)object2), (TeXUnit)object2);
        } else if (teXDimension11 != null) {
            object2 = teXDimension2.getUnit();
            this.setDimension("evensidemargin", teXDimension11.getUnit().toUnit(teXParser, teXDimension11.getValue(), (TeXUnit)object2) - TeXUnit.IN.toUnit(teXParser, 1.0f, (TeXUnit)object2), (TeXUnit)object2);
            this.setDimension("oddsidemargin", teXDimension2.getValue() - teXDimension8.getUnit().toUnit(teXParser, teXDimension8.getValue(), (TeXUnit)object2) - teXDimension11.getUnit().toUnit(teXParser, teXDimension11.getValue(), (TeXUnit)object2) - TeXUnit.IN.toUnit(teXParser, 1.0f, (TeXUnit)object2), (TeXUnit)object2);
        }
        if (teXDimension12 != null) {
            object2 = teXDimension3.getUnit();
            this.setDimension("topmargin", teXDimension12.getUnit().toUnit(teXParser, teXDimension12.getValue(), (TeXUnit)object2) - TeXUnit.IN.toUnit(teXParser, 1.0f, (TeXUnit)object2), (TeXUnit)object2);
        } else if (teXDimension13 != null) {
            object2 = teXDimension3.getUnit();
            this.setDimension("topmargin", teXDimension3.getValue() - teXDimension9.getUnit().toUnit(teXParser, teXDimension9.getValue(), (TeXUnit)object2) - teXDimension13.getUnit().toUnit(teXParser, teXDimension13.getValue(), (TeXUnit)object2) - TeXUnit.IN.toUnit(teXParser, 1.0f, (TeXUnit)object2), (TeXUnit)object2);
        }
    }

    public boolean isLandscape() throws IOException {
        TeXDimension teXDimension = this.getPaperWidth();
        TeXDimension teXDimension2 = this.getPaperHeight();
        if (teXDimension != null && teXDimension2 != null) {
            TeXUnit teXUnit;
            TeXUnit teXUnit2 = teXDimension.getUnit();
            if (teXUnit2 == (teXUnit = teXDimension2.getUnit())) {
                return teXDimension.getValue() > teXDimension2.getValue();
            }
            return teXUnit2.toPt(this.getParser(), teXDimension.getValue()) > teXUnit.toPt(this.getParser(), teXDimension2.getValue());
        }
        return false;
    }

    public boolean isPortrait() throws IOException {
        TeXDimension teXDimension = this.getPaperWidth();
        TeXDimension teXDimension2 = this.getPaperHeight();
        if (teXDimension != null && teXDimension2 != null) {
            TeXUnit teXUnit;
            TeXUnit teXUnit2 = teXDimension.getUnit();
            if (teXUnit2 == (teXUnit = teXDimension2.getUnit())) {
                return teXDimension.getValue() < teXDimension2.getValue();
            }
            return teXUnit2.toPt(this.getParser(), teXDimension.getValue()) < teXUnit.toPt(this.getParser(), teXDimension2.getValue());
        }
        return true;
    }

    protected void swapOrientation() throws IOException {
        TeXDimension teXDimension;
        TeXDimension teXDimension2 = this.getPaperWidth();
        TeXDimension teXDimension3 = teXDimension = this.getPaperHeight();
        teXDimension = teXDimension2;
        teXDimension2 = teXDimension3;
        if (teXDimension != null) {
            this.setDimension("paperheight", teXDimension.getValue(), teXDimension.getUnit());
        }
        if (teXDimension2 != null) {
            this.setDimension("paperwidth", teXDimension2.getValue(), teXDimension2.getUnit());
        }
        teXDimension2 = this.getTextWidth();
        teXDimension3 = teXDimension = this.getTextHeight();
        teXDimension = teXDimension2;
        teXDimension2 = teXDimension3;
        if (teXDimension != null) {
            this.setDimension("textheight", teXDimension.getValue(), teXDimension.getUnit());
        }
        if (teXDimension2 != null) {
            this.setDimension("textwidth", teXDimension2.getValue(), teXDimension2.getUnit());
        }
    }

    public void setPaperSize(String string) throws IOException {
        if (string.equals("a0paper")) {
            this.setPaperSize(841.0, 1189.0, TeXUnit.MM);
        } else if (string.equals("a1paper")) {
            this.setPaperSize(594.0, 841.0, TeXUnit.MM);
        } else if (string.equals("a2paper")) {
            this.setPaperSize(420.0, 594.0, TeXUnit.MM);
        } else if (string.equals("a3paper")) {
            this.setPaperSize(297.0, 420.0, TeXUnit.MM);
        } else if (string.equals("a4paper")) {
            this.setPaperSize(210.0, 297.0, TeXUnit.MM);
        } else if (string.equals("a5paper")) {
            this.setPaperSize(148.0, 210.0, TeXUnit.MM);
        } else if (string.equals("a6paper")) {
            this.setPaperSize(105.0, 148.0, TeXUnit.MM);
        } else if (string.equals("b0paper")) {
            this.setPaperSize(1000.0, 1414.0, TeXUnit.MM);
        } else if (string.equals("b1paper")) {
            this.setPaperSize(707.0, 1000.0, TeXUnit.MM);
        } else if (string.equals("b2paper")) {
            this.setPaperSize(500.0, 707.0, TeXUnit.MM);
        } else if (string.equals("b3paper")) {
            this.setPaperSize(353.0, 500.0, TeXUnit.MM);
        } else if (string.equals("b4paper")) {
            this.setPaperSize(250.0, 353.0, TeXUnit.MM);
        } else if (string.equals("b5paper")) {
            this.setPaperSize(176.0, 250.0, TeXUnit.MM);
        } else if (string.equals("b6paper")) {
            this.setPaperSize(125.0, 176.0, TeXUnit.MM);
        } else if (string.equals("c0paper")) {
            this.setPaperSize(917.0, 1297.0, TeXUnit.MM);
        } else if (string.equals("c1paper")) {
            this.setPaperSize(648.0, 917.0, TeXUnit.MM);
        } else if (string.equals("c2paper")) {
            this.setPaperSize(458.0, 648.0, TeXUnit.MM);
        } else if (string.equals("c3paper")) {
            this.setPaperSize(324.0, 458.0, TeXUnit.MM);
        } else if (string.equals("c4paper")) {
            this.setPaperSize(229.0, 324.0, TeXUnit.MM);
        } else if (string.equals("c5paper")) {
            this.setPaperSize(162.0, 229.0, TeXUnit.MM);
        } else if (string.equals("c6paper")) {
            this.setPaperSize(114.0, 162.0, TeXUnit.MM);
        } else if (string.equals("b0j")) {
            this.setPaperSize(1030.0, 1456.0, TeXUnit.MM);
        } else if (string.equals("b1j")) {
            this.setPaperSize(728.0, 1030.0, TeXUnit.MM);
        } else if (string.equals("b2j")) {
            this.setPaperSize(515.0, 728.0, TeXUnit.MM);
        } else if (string.equals("b3j")) {
            this.setPaperSize(364.0, 515.0, TeXUnit.MM);
        } else if (string.equals("b4j")) {
            this.setPaperSize(257.0, 364.0, TeXUnit.MM);
        } else if (string.equals("b5j")) {
            this.setPaperSize(182.0, 257.0, TeXUnit.MM);
        } else if (string.equals("b6j")) {
            this.setPaperSize(128.0, 182.0, TeXUnit.MM);
        } else if (string.equals("ansiapaper")) {
            this.setPaperSize(8.5, 11.0, TeXUnit.IN);
        } else if (string.equals("ansibpaper")) {
            this.setPaperSize(11.0, 17.0, TeXUnit.IN);
        } else if (string.equals("ansicpaper")) {
            this.setPaperSize(17.0, 22.0, TeXUnit.IN);
        } else if (string.equals("ansidpaper")) {
            this.setPaperSize(22.0, 34.0, TeXUnit.IN);
        } else if (string.equals("ansiepaper")) {
            this.setPaperSize(34.0, 44.0, TeXUnit.IN);
        } else if (string.equals("letterpaper")) {
            this.setPaperSize(8.5, 11.0, TeXUnit.IN);
        } else if (string.equals("legalpaper")) {
            this.setPaperSize(8.5, 14.0, TeXUnit.IN);
        } else if (string.equals("executivepaper")) {
            this.setPaperSize(7.25, 10.5, TeXUnit.IN);
        } else if (string.equals("screen")) {
            this.setPaperSize(225.0, 180.0, TeXUnit.MM);
        } else {
            throw new LaTeXSyntaxException(this.getParser(), "latex.invalid.option.value", string);
        }
    }

    public void setPaperSize(double d, double d2, TeXUnit teXUnit) throws IOException {
        this.setDimension("paperwidth", new UserDimension(d, teXUnit));
        this.setDimension("paperheight", new UserDimension(d2, teXUnit));
    }

    public void setDimension(String string, double d, TeXUnit teXUnit) throws IOException {
        this.setDimension(string, new UserDimension(d, teXUnit));
        this.updatePageDimension(string, teXUnit.toUnit(this.getParser(), (float)d, FixedUnit.BP));
    }

    public void setDimension(String string, TeXDimension teXDimension) throws IOException {
        TeXDimension teXDimension2 = this.getDimension(string);
        if (teXDimension2 == null) {
            teXDimension2 = this.getParser().getSettings().newdimen(string);
        }
        teXDimension2.setDimension(this.getParser(), teXDimension);
        TeXUnit teXUnit = teXDimension.getUnit();
        float f = teXDimension.getValue();
        this.updatePageDimension(string, teXUnit.toUnit(this.getParser(), f, FixedUnit.BP));
    }

    protected void updatePageDimension(String string, float f) {
        if (string.equals("paperwidth")) {
            this.listener.setPageDimension(7, f);
        } else if (string.equals("paperheight")) {
            this.listener.setPageDimension(8, f);
        } else if (string.equals("hsize")) {
            this.listener.setPageDimension(5, f);
        } else if (string.equals("vsize")) {
            this.listener.setPageDimension(6, f);
        } else if (string.equals("textwidth")) {
            this.listener.setPageDimension(2, f);
        } else if (string.equals("textheight")) {
            this.listener.setPageDimension(4, f);
        } else if (string.equals("marginparwidth")) {
            this.listener.setPageDimension(9, f);
        } else if (string.equals("columnwidth")) {
            this.listener.setPageDimension(1, f);
        } else if (string.equals("columnheight")) {
            this.listener.setPageDimension(3, f);
        }
    }

    public TeXDimension getDimension(String string) throws IOException {
        ControlSequence controlSequence = this.getParser().getControlSequence(string);
        if (controlSequence == null) {
            return null;
        }
        return TeXParserUtils.toTeXDimension(controlSequence, this.getParser(), null);
    }

    public TeXDimension getPaperWidth() throws IOException {
        return this.getDimension("paperwidth");
    }

    public TeXDimension getPaperHeight() throws IOException {
        return this.getDimension("paperheight");
    }

    public TeXDimension getTextWidth() throws IOException {
        return this.getDimension("textwidth");
    }

    public TeXDimension getTextHeight() throws IOException {
        return this.getDimension("textheight");
    }

    public TeXDimension getMarginParWidth() throws IOException {
        return this.getDimension("marginparwidth");
    }

    public TeXDimension getMarginParSep() throws IOException {
        return this.getDimension("marginparsep");
    }

    public TeXDimension getHeadHeight() throws IOException {
        return this.getDimension("headheight");
    }

    public TeXDimension getHeadSep() throws IOException {
        return this.getDimension("headsep");
    }

    public TeXDimension getFootSkip() throws IOException {
        return this.getDimension("footskip");
    }

    public TeXDimension getTopMargin() throws IOException {
        return this.getDimension("topmargin");
    }

    public TeXDimension getOddSideMargin() throws IOException {
        return this.getDimension("oddsidemargin");
    }

    public TeXDimension getEvenSideMargin() throws IOException {
        return this.getDimension("evensidemargin");
    }

    public Rectangle2D getTypeblock(boolean bl) throws IOException {
        float f;
        TeXUnit teXUnit;
        TeXDimension teXDimension;
        TeXDimension teXDimension2;
        TeXObject teXObject;
        TeXDimension teXDimension3;
        double d = 72.0;
        double d2 = 72.0;
        double d3 = 0.0;
        double d4 = 0.0;
        if (bl) {
            teXDimension3 = this.getEvenSideMargin();
            if (teXDimension3 == null) {
                teXDimension3 = this.getOddSideMargin();
            }
        } else {
            teXDimension3 = this.getOddSideMargin();
        }
        if (teXDimension3 != null) {
            teXObject = teXDimension3.getUnit();
            float f2 = teXDimension3.getValue();
            d += (double)((TeXUnit)teXObject).toUnit(this.getParser(), f2, FixedUnit.BP);
        }
        if ((teXObject = this.getTopMargin()) != null) {
            TeXUnit teXUnit2 = teXObject.getUnit();
            float f3 = teXObject.getValue();
            d2 += (double)teXUnit2.toUnit(this.getParser(), f3, FixedUnit.BP);
        }
        if ((teXDimension2 = this.getHeadHeight()) != null) {
            TeXUnit teXUnit3 = teXDimension2.getUnit();
            float f4 = teXDimension2.getValue();
            d2 += (double)teXUnit3.toUnit(this.getParser(), f4, FixedUnit.BP);
        }
        if ((teXDimension = this.getHeadSep()) != null) {
            TeXUnit teXUnit4 = teXDimension.getUnit();
            float f5 = teXDimension.getValue();
            d2 += (double)teXUnit4.toUnit(this.getParser(), f5, FixedUnit.BP);
        }
        TeXDimension teXDimension4 = this.getTextWidth();
        TeXDimension teXDimension5 = this.getTextHeight();
        if (teXDimension4 != null) {
            teXUnit = teXDimension4.getUnit();
            f = teXDimension4.getValue();
            d3 = teXUnit.toUnit(this.getParser(), f, FixedUnit.BP);
        }
        if (teXDimension5 != null) {
            teXUnit = teXDimension5.getUnit();
            f = teXDimension5.getValue();
            d4 = teXUnit.toUnit(this.getParser(), f, FixedUnit.BP);
        }
        return new Rectangle2D.Double(d, d2, d3, d4);
    }
}

