---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, travail, commerce, 
              nombres en lettres, chiffre en lettre, écrire un chèque, 
              écrire la date en toutes lettres, documents administratifs
---

# Comment écrire des nombres en toutes lettres ?

Malgré la moindre lisibilité, les documents administratifs demandent 
fréquemment que les nombres soient systématiquement écrits en toutes lettres :
chèques, contrats, actes notariés...

Pour le français, il y a de nombreuses règles à respecter pour cette écriture,
souvent peu intuitives, mais applicables de façon automatique. Il existe 
(au moins) deux extensions capables de vous aider.


## Avec l'extension <ctanpkg:numspell>

:::{todo} À rédiger.
:::


## Avec l'extension <ctanpkg:fmtcount>

L'extension <ctanpkg:fmtcount>, de Nicola Talbot & Vincent Belaïche, faisait 
initialement partie de <ctanpkg:datetime>, mais elle est maintenant distribuée
indépendamment. Elle fournit des commandes pour afficher la valeur 
d'un compteur LaTeX dans divers formats (ordinal, texte, hexadécimal, décimal,
octal, binaire, etc). Elle offre un certain support multilingue, 
avec la possibilité d'écire en anglais (britannique ou américain), français 
(y compris les variantes belge et suisse), allemand, italien, portugais 
et espagnol. Voici quelques unes des fonctions mises à disposition :

- pour écrire un nombre en toutes lettres, utilisez la commande 
  `\numberstringnum`, qui prend directement un nombre en argument ;
- pour écrire la valeur d'un compteur en toutes lettres, utilisez 
  `\numberstring`, et le nom du compteur ;
- pour faire les mêmes choses sous forme ordinale (*premier*, *deuxième*...), 
  vous avez `\ordinalstringnum` or `\ordinalstring`, respectivement.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{fmtcount}

\begin{document}
\section{Comptons les moutons}
Alors que vous lisez la page \numberstring{page}, voici qu'arrive 
le \ordinalstringnum{1} mouton ! Suivi du \ordinalstringnum{2}\dots{} 
suivi, lui-même, des \numberstringnum{257}~autres. C'est incroyable !
\end{document}
```

Pour avoir une majuscule en début de nombre, il suffit d'utiliser les variantes
`\Numberstringnum`, `\Ordinalstringnum` (avec la première lettre en majuscule)
et ainsi de suite :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{fmtcount}

\begin{document}
\Numberstringnum{1978} est une bonne année.
\end{document}
```

Pour avoir les formes féminines des nombres, vous pouvez ajouter 
un argument optionnel indiquant le genre : `[f]`, `[m]` ou `[n]` pour, 
respectivement, féminin, masculin ou neutre.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{fmtcount}

\begin{document}
\Numberstringnum{1}[f] hirondelle ne fait pas le printemps,
mais la \ordinalstringnum{2}[f] est un bon indice.
\end{document}
```


### Cas de "septante" et "nonante"

Pour avoir les variantes suisses ou belges des nombres, il est possible
d'utiliser des options de l'extension, passées 
avec la commande `\fmtcountsetoptions` :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{fmtcount}

  \fmtcountsetoptions{french=belgian}

\begin{document}
Baudouin a régné jusqu'en \numberstringnum{1993}.
\end{document}
```

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{fmtcount}

  \fmtcountsetoptions{french=swiss}

\begin{document}
En Suisse, on mange \numberstringnum{88}~kilos
de chocolat pour 10~personnes, en moyenne.
\end{document}
```

Voici les termes utilisés dans les différentes variantes :

| Option    | 70           | 80            | 90               |
| --------- | ------------ | ------------- | ---------------- |
| `france`  | soixante-dix | quatre-vingts | quatre-vingt-dix |
| `belgian` | septante     | quatre-vingts | nonante          |
| `swiss`   | septante     | huitante      | nonante          |

Notez qu'à décembre 2021, ces variantes locales ont encore 
quelques petits bugs qui sont en cours de correction par les auteurs 
de l'extension.


:::{sources}
- [Chapter numbers as words in LaTeX](https://texblog.org/2017/04/11/chapter-numbers-as-words-in-latex/), 
  sur le [texblog](https://texblog.org)
- [Soixante, septante, huitante, nonante… logique !](https://www.swissinfo.ch/fre/soixante--septante--huitante--nonante--logique-/25525018),
  sur [swissinfo](https://www.swissinfo.ch/fre/)
:::