/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.web;

import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.installer.web.DownloadPanel;
import com.izforge.izpack.installer.web.WebAccessor;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;

public class LoggedInputStream
extends InputStream {
    private long bytesRead = 0L;
    private InputStream is;
    private DownloadPanel downloader;
    private volatile boolean cancelled = false;
    private long lastTime = -1L;
    private long lastBytes = -1L;

    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    public LoggedInputStream(InputStream is, WebAccessor webAccessor) {
        if (is == null) {
            throw new RuntimeException("Unable to connect");
        }
        this.is = is;
        String sizeStr = webAccessor.getContentLength() > 0 ? "(" + Pack.toByteUnitsString(webAccessor.getContentLength()) + ")" : "";
        this.downloader = new DownloadPanel(this);
        this.downloader.setTitle("Downloading");
        this.downloader.setFileLabel(webAccessor.getUrl() + " " + sizeStr);
        this.downloader.setLocationRelativeTo(null);
        this.downloader.setVisible(true);
        if (webAccessor.getContentLength() > 0) {
            this.downloader.setProgressMax(webAccessor.getContentLength());
            this.downloader.setProgressCurrent(0);
        }
    }

    @Override
    public int available() throws IOException {
        return this.is.available();
    }

    @Override
    public void close() throws IOException {
        this.downloader.setVisible(false);
        this.downloader.dispose();
        this.is.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.is.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.is.markSupported();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.is.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.is.skip(n);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int bytes = this.is.read(b, off, len);
        if (bytes > 0) {
            this.bytesRead += (long)bytes;
        }
        this.update();
        return bytes;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int bytes = this.is.read(b);
        if (bytes > 0) {
            this.bytesRead += (long)bytes;
        }
        this.update();
        return bytes;
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    @Override
    public int read() throws IOException {
        int bytes = this.is.read();
        if (bytes > 0) {
            ++this.bytesRead;
        }
        this.update();
        return bytes;
    }

    private void update() throws IOException {
        if (this.lastTime > 0L) {
            long currTime = System.currentTimeMillis();
            long diff = currTime - this.lastTime;
            if (diff > 800L) {
                double bps = (double)(this.bytesRead - this.lastBytes) / ((double)diff / 1000.0);
                this.downloader.setStatusLabel(Pack.toByteUnitsString(Math.round(bps)) + "/s");
                this.lastTime = currTime;
                this.lastBytes = this.bytesRead;
            }
        } else {
            this.lastTime = System.currentTimeMillis();
            this.lastBytes = this.bytesRead;
        }
        this.downloader.setProgressCurrent((int)this.bytesRead);
        if (this.cancelled) {
            throw new InterruptedIOException("Cancelled");
        }
    }
}

