/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.math;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Objects;
import org.apache.commons.lang3.CharUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class NumberUtils {
    public static final Long LONG_ZERO = 0L;
    public static final Long LONG_ONE = 1L;
    public static final Long LONG_MINUS_ONE = -1L;
    public static final Integer INTEGER_ZERO = 0;
    public static final Integer INTEGER_ONE = 1;
    public static final Integer INTEGER_TWO = 2;
    public static final Integer INTEGER_MINUS_ONE = -1;
    public static final Short SHORT_ZERO = 0;
    public static final Short SHORT_ONE = 1;
    public static final Short SHORT_MINUS_ONE = -1;
    public static final Byte BYTE_ZERO = 0;
    public static final Byte BYTE_ONE = 1;
    public static final Byte BYTE_MINUS_ONE = -1;
    public static final Double DOUBLE_ZERO = 0.0;
    public static final Double DOUBLE_ONE = 1.0;
    public static final Double DOUBLE_MINUS_ONE = -1.0;
    public static final Float FLOAT_ZERO = Float.valueOf(0.0f);
    public static final Float FLOAT_ONE = Float.valueOf(1.0f);
    public static final Float FLOAT_MINUS_ONE = Float.valueOf(-1.0f);
    public static final Long LONG_INT_MAX_VALUE = Integer.MAX_VALUE;
    public static final Long LONG_INT_MIN_VALUE = Integer.MIN_VALUE;

    @Deprecated
    public static int compare(byte x15, byte y15) {
        return Byte.compare(x15, y15);
    }

    @Deprecated
    public static int compare(int x15, int y15) {
        return Integer.compare(x15, y15);
    }

    @Deprecated
    public static int compare(long x15, long y15) {
        return Long.compare(x15, y15);
    }

    @Deprecated
    public static int compare(short x15, short y15) {
        return Short.compare(x15, y15);
    }

    public static BigDecimal createBigDecimal(String str) {
        if (str == null) {
            return null;
        }
        if (StringUtils.isBlank(str)) {
            throw new NumberFormatException("A blank string is not a valid number");
        }
        return new BigDecimal(str);
    }

    public static BigInteger createBigInteger(String str) {
        if (str == null) {
            return null;
        }
        if (str.isEmpty()) {
            throw new NumberFormatException("An empty string is not a valid number");
        }
        int pos = 0;
        int radix = 10;
        boolean negate = false;
        char char0 = str.charAt(0);
        if (char0 == '-') {
            negate = true;
            pos = 1;
        } else if (char0 == '+') {
            pos = 1;
        }
        if (str.startsWith("0x", pos) || str.startsWith("0X", pos)) {
            radix = 16;
            pos += 2;
        } else if (str.startsWith("#", pos)) {
            radix = 16;
            ++pos;
        } else if (str.startsWith("0", pos) && str.length() > pos + 1) {
            radix = 8;
            ++pos;
        }
        BigInteger value = new BigInteger(str.substring(pos), radix);
        return negate ? value.negate() : value;
    }

    public static Double createDouble(String str) {
        if (str == null) {
            return null;
        }
        return Double.valueOf(str);
    }

    public static Float createFloat(String str) {
        if (str == null) {
            return null;
        }
        return Float.valueOf(str);
    }

    public static Integer createInteger(String str) {
        if (str == null) {
            return null;
        }
        return Integer.decode(str);
    }

    public static Long createLong(String str) {
        if (str == null) {
            return null;
        }
        return Long.decode(str);
    }

    public static Number createNumber(String str) {
        String exp;
        String mant;
        String dec;
        boolean requestType;
        if (str == null) {
            return null;
        }
        if (StringUtils.isBlank(str)) {
            throw new NumberFormatException("A blank string is not a valid number");
        }
        String[] hexPrefixes = new String[]{"0x", "0X", "#"};
        int length = str.length();
        int offset = NumberUtils.isSign(str.charAt(0)) ? 1 : 0;
        int pfxLen = 0;
        for (String pfx : hexPrefixes) {
            if (!str.startsWith(pfx, offset)) continue;
            pfxLen += pfx.length() + offset;
            break;
        }
        if (pfxLen > 0) {
            char firstSigDigit = '\u0000';
            for (int i15 = pfxLen; i15 < length && (firstSigDigit = str.charAt(i15)) == '0'; ++i15) {
                ++pfxLen;
            }
            int hexDigits = length - pfxLen;
            if (hexDigits > 16 || hexDigits == 16 && firstSigDigit > '7') {
                return NumberUtils.createBigInteger(str);
            }
            if (hexDigits > 8 || hexDigits == 8 && firstSigDigit > '7') {
                return NumberUtils.createLong(str);
            }
            return NumberUtils.createInteger(str);
        }
        char lastChar = str.charAt(length - 1);
        int decPos = str.indexOf(46);
        int expPos = str.indexOf(101) + str.indexOf(69) + 1;
        boolean bl4 = requestType = !Character.isDigit(lastChar) && lastChar != '.';
        if (decPos > -1) {
            if (expPos > -1) {
                if (expPos <= decPos || expPos > length) {
                    throw new NumberFormatException(str + " is not a valid number.");
                }
                dec = str.substring(decPos + 1, expPos);
            } else {
                dec = str.substring(decPos + 1, requestType ? length - 1 : length);
            }
            mant = NumberUtils.getMantissa(str, decPos);
        } else {
            if (expPos > -1) {
                if (expPos > length) {
                    throw new NumberFormatException(str + " is not a valid number.");
                }
                mant = NumberUtils.getMantissa(str, expPos);
            } else {
                mant = NumberUtils.getMantissa(str, requestType ? length - 1 : length);
            }
            dec = null;
        }
        if (requestType) {
            exp = expPos > -1 && expPos < length - 1 ? str.substring(expPos + 1, length - 1) : null;
            String numeric2 = str.substring(0, length - 1);
            switch (lastChar) {
                case 'L': 
                case 'l': {
                    if (dec == null && exp == null && (!numeric2.isEmpty() && numeric2.charAt(0) == '-' && NumberUtils.isDigits(numeric2.substring(1)) || NumberUtils.isDigits(numeric2))) {
                        try {
                            return NumberUtils.createLong(numeric2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            return NumberUtils.createBigInteger(numeric2);
                        }
                    }
                    throw new NumberFormatException(str + " is not a valid number.");
                }
                case 'F': 
                case 'f': {
                    try {
                        Float f15 = NumberUtils.createFloat(str);
                        if (!f15.isInfinite() && (f15.floatValue() != 0.0f || NumberUtils.isZero(mant, dec))) {
                            return f15;
                        }
                    }
                    catch (NumberFormatException f15) {
                        // empty catch block
                    }
                }
                case 'D': 
                case 'd': {
                    try {
                        Double d15 = NumberUtils.createDouble(str);
                        if (!d15.isInfinite() && (d15 != 0.0 || NumberUtils.isZero(mant, dec))) {
                            return d15;
                        }
                    }
                    catch (NumberFormatException d15) {
                        // empty catch block
                    }
                    try {
                        return NumberUtils.createBigDecimal(numeric2);
                    }
                    catch (NumberFormatException d15) {
                        // empty catch block
                    }
                }
            }
            throw new NumberFormatException(str + " is not a valid number.");
        }
        exp = expPos > -1 && expPos < length - 1 ? str.substring(expPos + 1) : null;
        if (dec == null && exp == null) {
            try {
                return NumberUtils.createInteger(str);
            }
            catch (NumberFormatException numeric2) {
                try {
                    return NumberUtils.createLong(str);
                }
                catch (NumberFormatException numeric2) {
                    return NumberUtils.createBigInteger(str);
                }
            }
        }
        try {
            Float f16 = NumberUtils.createFloat(str);
            Double d16 = NumberUtils.createDouble(str);
            if (!f16.isInfinite() && (f16.floatValue() != 0.0f || NumberUtils.isZero(mant, dec)) && f16.toString().equals(d16.toString())) {
                return f16;
            }
            if (!d16.isInfinite() && (d16 != 0.0 || NumberUtils.isZero(mant, dec))) {
                BigDecimal b15 = NumberUtils.createBigDecimal(str);
                if (b15.compareTo(BigDecimal.valueOf(d16)) == 0) {
                    return d16;
                }
                return b15;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return NumberUtils.createBigDecimal(str);
    }

    private static String getMantissa(String str, int stopPos) {
        char firstChar = str.charAt(0);
        boolean hasSign = NumberUtils.isSign(firstChar);
        int length = str.length();
        if (length <= (hasSign ? 1 : 0) || length < stopPos) {
            throw new NumberFormatException(str + " is not a valid number.");
        }
        return hasSign ? str.substring(1, stopPos) : str.substring(0, stopPos);
    }

    private static boolean isAllZeros(String str) {
        if (str == null) {
            return true;
        }
        for (int i15 = str.length() - 1; i15 >= 0; --i15) {
            if (str.charAt(i15) == '0') continue;
            return false;
        }
        return true;
    }

    public static boolean isCreatable(String str) {
        int i15;
        int start;
        if (StringUtils.isEmpty(str)) {
            return false;
        }
        char[] chars = str.toCharArray();
        int sz4 = chars.length;
        boolean hasExp = false;
        boolean hasDecPoint = false;
        boolean allowSigns = false;
        boolean foundDigit = false;
        int n15 = start = NumberUtils.isSign(chars[0]) ? 1 : 0;
        if (sz4 > start + 1 && chars[start] == '0' && !StringUtils.contains((CharSequence)str, 46)) {
            if (chars[start + 1] == 'x' || chars[start + 1] == 'X') {
                int i16 = start + 2;
                if (i16 == sz4) {
                    return false;
                }
                while (i16 < chars.length) {
                    if (!CharUtils.isHex(chars[i16])) {
                        return false;
                    }
                    ++i16;
                }
                return true;
            }
            if (Character.isDigit(chars[start + 1])) {
                for (int i17 = start + 1; i17 < chars.length; ++i17) {
                    if (CharUtils.isOctal(chars[i17])) continue;
                    return false;
                }
                return true;
            }
        }
        --sz4;
        for (i15 = start; i15 < sz4 || i15 < sz4 + 1 && allowSigns && !foundDigit; ++i15) {
            if (CharUtils.isAsciiNumeric(chars[i15])) {
                foundDigit = true;
                allowSigns = false;
                continue;
            }
            if (chars[i15] == '.') {
                if (hasDecPoint || hasExp) {
                    return false;
                }
                hasDecPoint = true;
                continue;
            }
            if (chars[i15] == 'e' || chars[i15] == 'E') {
                if (hasExp) {
                    return false;
                }
                if (!foundDigit) {
                    return false;
                }
                hasExp = true;
                allowSigns = true;
                continue;
            }
            if (NumberUtils.isSign(chars[i15])) {
                if (!allowSigns) {
                    return false;
                }
                allowSigns = false;
                foundDigit = false;
                continue;
            }
            return false;
        }
        if (i15 < chars.length) {
            if (CharUtils.isAsciiNumeric(chars[i15])) {
                return true;
            }
            if (chars[i15] == 'e' || chars[i15] == 'E') {
                return false;
            }
            if (chars[i15] == '.') {
                if (hasDecPoint || hasExp) {
                    return false;
                }
                return foundDigit;
            }
            if (!(allowSigns || chars[i15] != 'd' && chars[i15] != 'D' && chars[i15] != 'f' && chars[i15] != 'F')) {
                return foundDigit;
            }
            if (chars[i15] == 'l' || chars[i15] == 'L') {
                return foundDigit && !hasExp && !hasDecPoint;
            }
            return false;
        }
        return !allowSigns && foundDigit;
    }

    public static boolean isDigits(String str) {
        return StringUtils.isNumeric(str);
    }

    @Deprecated
    public static boolean isNumber(String str) {
        return NumberUtils.isCreatable(str);
    }

    public static boolean isParsable(String str) {
        if (StringUtils.isEmpty(str)) {
            return false;
        }
        if (str.charAt(str.length() - 1) == '.') {
            return false;
        }
        if (str.charAt(0) == '-') {
            if (str.length() == 1) {
                return false;
            }
            return NumberUtils.withDecimalsParsing(str, 1);
        }
        return NumberUtils.withDecimalsParsing(str, 0);
    }

    private static boolean isSign(char ch4) {
        return ch4 == '-' || ch4 == '+';
    }

    private static boolean isZero(String mant, String dec) {
        return NumberUtils.isAllZeros(mant) && NumberUtils.isAllZeros(dec);
    }

    public static byte max(byte ... array) {
        NumberUtils.validateArray(array);
        byte max = array[0];
        for (int i15 = 1; i15 < array.length; ++i15) {
            if (array[i15] <= max) continue;
            max = array[i15];
        }
        return max;
    }

    public static byte max(byte a15, byte b15, byte c15) {
        if (b15 > a15) {
            a15 = b15;
        }
        if (c15 > a15) {
            a15 = c15;
        }
        return a15;
    }

    public static double max(double ... array) {
        NumberUtils.validateArray(array);
        double max = array[0];
        for (int j15 = 1; j15 < array.length; ++j15) {
            if (Double.isNaN(array[j15])) {
                return Double.NaN;
            }
            if (!(array[j15] > max)) continue;
            max = array[j15];
        }
        return max;
    }

    public static double max(double a15, double b15, double c15) {
        return Math.max(Math.max(a15, b15), c15);
    }

    public static float max(float ... array) {
        NumberUtils.validateArray(array);
        float max = array[0];
        for (int j15 = 1; j15 < array.length; ++j15) {
            if (Float.isNaN(array[j15])) {
                return Float.NaN;
            }
            if (!(array[j15] > max)) continue;
            max = array[j15];
        }
        return max;
    }

    public static float max(float a15, float b15, float c15) {
        return Math.max(Math.max(a15, b15), c15);
    }

    public static int max(int ... array) {
        NumberUtils.validateArray(array);
        int max = array[0];
        for (int j15 = 1; j15 < array.length; ++j15) {
            if (array[j15] <= max) continue;
            max = array[j15];
        }
        return max;
    }

    public static int max(int a15, int b15, int c15) {
        if (b15 > a15) {
            a15 = b15;
        }
        if (c15 > a15) {
            a15 = c15;
        }
        return a15;
    }

    public static long max(long ... array) {
        NumberUtils.validateArray(array);
        long max = array[0];
        for (int j15 = 1; j15 < array.length; ++j15) {
            if (array[j15] <= max) continue;
            max = array[j15];
        }
        return max;
    }

    public static long max(long a15, long b15, long c15) {
        if (b15 > a15) {
            a15 = b15;
        }
        if (c15 > a15) {
            a15 = c15;
        }
        return a15;
    }

    public static short max(short ... array) {
        NumberUtils.validateArray(array);
        short max = array[0];
        for (int i15 = 1; i15 < array.length; ++i15) {
            if (array[i15] <= max) continue;
            max = array[i15];
        }
        return max;
    }

    public static short max(short a15, short b15, short c15) {
        if (b15 > a15) {
            a15 = b15;
        }
        if (c15 > a15) {
            a15 = c15;
        }
        return a15;
    }

    public static byte min(byte ... array) {
        NumberUtils.validateArray(array);
        byte min = array[0];
        for (int i15 = 1; i15 < array.length; ++i15) {
            if (array[i15] >= min) continue;
            min = array[i15];
        }
        return min;
    }

    public static byte min(byte a15, byte b15, byte c15) {
        if (b15 < a15) {
            a15 = b15;
        }
        if (c15 < a15) {
            a15 = c15;
        }
        return a15;
    }

    public static double min(double ... array) {
        NumberUtils.validateArray(array);
        double min = array[0];
        for (int i15 = 1; i15 < array.length; ++i15) {
            if (Double.isNaN(array[i15])) {
                return Double.NaN;
            }
            if (!(array[i15] < min)) continue;
            min = array[i15];
        }
        return min;
    }

    public static double min(double a15, double b15, double c15) {
        return Math.min(Math.min(a15, b15), c15);
    }

    public static float min(float ... array) {
        NumberUtils.validateArray(array);
        float min = array[0];
        for (int i15 = 1; i15 < array.length; ++i15) {
            if (Float.isNaN(array[i15])) {
                return Float.NaN;
            }
            if (!(array[i15] < min)) continue;
            min = array[i15];
        }
        return min;
    }

    public static float min(float a15, float b15, float c15) {
        return Math.min(Math.min(a15, b15), c15);
    }

    public static int min(int ... array) {
        NumberUtils.validateArray(array);
        int min = array[0];
        for (int j15 = 1; j15 < array.length; ++j15) {
            if (array[j15] >= min) continue;
            min = array[j15];
        }
        return min;
    }

    public static int min(int a15, int b15, int c15) {
        if (b15 < a15) {
            a15 = b15;
        }
        if (c15 < a15) {
            a15 = c15;
        }
        return a15;
    }

    public static long min(long ... array) {
        NumberUtils.validateArray(array);
        long min = array[0];
        for (int i15 = 1; i15 < array.length; ++i15) {
            if (array[i15] >= min) continue;
            min = array[i15];
        }
        return min;
    }

    public static long min(long a15, long b15, long c15) {
        if (b15 < a15) {
            a15 = b15;
        }
        if (c15 < a15) {
            a15 = c15;
        }
        return a15;
    }

    public static short min(short ... array) {
        NumberUtils.validateArray(array);
        short min = array[0];
        for (int i15 = 1; i15 < array.length; ++i15) {
            if (array[i15] >= min) continue;
            min = array[i15];
        }
        return min;
    }

    public static short min(short a15, short b15, short c15) {
        if (b15 < a15) {
            a15 = b15;
        }
        if (c15 < a15) {
            a15 = c15;
        }
        return a15;
    }

    public static byte toByte(String str) {
        return NumberUtils.toByte(str, (byte)0);
    }

    public static byte toByte(String str, byte defaultValue) {
        try {
            return Byte.parseByte(str);
        }
        catch (RuntimeException e15) {
            return defaultValue;
        }
    }

    public static double toDouble(BigDecimal value) {
        return NumberUtils.toDouble(value, 0.0);
    }

    public static double toDouble(BigDecimal value, double defaultValue) {
        return value == null ? defaultValue : value.doubleValue();
    }

    public static double toDouble(String str) {
        return NumberUtils.toDouble(str, 0.0);
    }

    public static double toDouble(String str, double defaultValue) {
        try {
            return Double.parseDouble(str);
        }
        catch (RuntimeException e15) {
            return defaultValue;
        }
    }

    public static float toFloat(String str) {
        return NumberUtils.toFloat(str, 0.0f);
    }

    public static float toFloat(String str, float defaultValue) {
        try {
            return Float.parseFloat(str);
        }
        catch (RuntimeException e15) {
            return defaultValue;
        }
    }

    public static int toInt(String str) {
        return NumberUtils.toInt(str, 0);
    }

    public static int toInt(String str, int defaultValue) {
        try {
            return Integer.parseInt(str);
        }
        catch (RuntimeException e15) {
            return defaultValue;
        }
    }

    public static long toLong(String str) {
        return NumberUtils.toLong(str, 0L);
    }

    public static long toLong(String str, long defaultValue) {
        try {
            return Long.parseLong(str);
        }
        catch (RuntimeException e15) {
            return defaultValue;
        }
    }

    public static BigDecimal toScaledBigDecimal(BigDecimal value) {
        return NumberUtils.toScaledBigDecimal(value, (int)INTEGER_TWO, RoundingMode.HALF_EVEN);
    }

    public static BigDecimal toScaledBigDecimal(BigDecimal value, int scale, RoundingMode roundingMode) {
        if (value == null) {
            return BigDecimal.ZERO;
        }
        return value.setScale(scale, roundingMode == null ? RoundingMode.HALF_EVEN : roundingMode);
    }

    public static BigDecimal toScaledBigDecimal(Double value) {
        return NumberUtils.toScaledBigDecimal(value, (int)INTEGER_TWO, RoundingMode.HALF_EVEN);
    }

    public static BigDecimal toScaledBigDecimal(Double value, int scale, RoundingMode roundingMode) {
        if (value == null) {
            return BigDecimal.ZERO;
        }
        return NumberUtils.toScaledBigDecimal(BigDecimal.valueOf(value), scale, roundingMode);
    }

    public static BigDecimal toScaledBigDecimal(Float value) {
        return NumberUtils.toScaledBigDecimal(value, (int)INTEGER_TWO, RoundingMode.HALF_EVEN);
    }

    public static BigDecimal toScaledBigDecimal(Float value, int scale, RoundingMode roundingMode) {
        if (value == null) {
            return BigDecimal.ZERO;
        }
        return NumberUtils.toScaledBigDecimal(BigDecimal.valueOf(value.floatValue()), scale, roundingMode);
    }

    public static BigDecimal toScaledBigDecimal(String value) {
        return NumberUtils.toScaledBigDecimal(value, (int)INTEGER_TWO, RoundingMode.HALF_EVEN);
    }

    public static BigDecimal toScaledBigDecimal(String value, int scale, RoundingMode roundingMode) {
        if (value == null) {
            return BigDecimal.ZERO;
        }
        return NumberUtils.toScaledBigDecimal(NumberUtils.createBigDecimal(value), scale, roundingMode);
    }

    public static short toShort(String str) {
        return NumberUtils.toShort(str, (short)0);
    }

    public static short toShort(String str, short defaultValue) {
        try {
            return Short.parseShort(str);
        }
        catch (RuntimeException e15) {
            return defaultValue;
        }
    }

    private static void validateArray(Object array) {
        Objects.requireNonNull(array, "array");
        Validate.isTrue(Array.getLength(array) != 0, "Array cannot be empty.", new Object[0]);
    }

    private static boolean withDecimalsParsing(String str, int beginIdx) {
        int decimalPoints = 0;
        for (int i15 = beginIdx; i15 < str.length(); ++i15) {
            boolean isDecimalPoint;
            char ch4 = str.charAt(i15);
            boolean bl4 = isDecimalPoint = ch4 == '.';
            if (isDecimalPoint) {
                ++decimalPoints;
            }
            if (decimalPoints > 1) {
                return false;
            }
            if (isDecimalPoint || Character.isDigit(ch4)) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public NumberUtils() {
    }
}

