/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.tool;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.analysis.DFAState;
import org.antlr.analysis.RuleClosureTransition;
import org.antlr.analysis.SemanticContext;
import org.antlr.analysis.State;
import org.antlr.analysis.Transition;
import org.antlr.misc.Utils;
import org.antlr.tool.ErrorManager;
import org.antlr.tool.Grammar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FASerializer {
    protected Set<State> markedStates;
    protected int stateCounter = 0;
    protected Map<State, Integer> stateNumberTranslator;
    protected Grammar grammar;

    public FASerializer(Grammar grammar) {
        this.grammar = grammar;
    }

    public String serialize(State s15) {
        if (s15 == null) {
            return "<no automaton>";
        }
        return this.serialize(s15, true);
    }

    public String serialize(State s15, boolean renumber) {
        this.markedStates = new HashSet<State>();
        this.stateCounter = 0;
        if (renumber) {
            this.stateNumberTranslator = new HashMap<State, Integer>();
            this.walkFANormalizingStateNumbers(s15);
        }
        ArrayList<String> lines = new ArrayList<String>();
        if (s15.getNumberOfTransitions() > 0) {
            this.walkSerializingFA(lines, s15);
        } else {
            String s05 = this.getStateString(0, s15);
            lines.add(s05 + "\n");
        }
        StringBuilder buf = new StringBuilder(0);
        Collections.sort(lines);
        for (int i15 = 0; i15 < lines.size(); ++i15) {
            String line = (String)lines.get(i15);
            buf.append(line);
        }
        return buf.toString();
    }

    protected void walkFANormalizingStateNumbers(State s15) {
        if (s15 == null) {
            ErrorManager.internalError("null state s");
            return;
        }
        if (this.stateNumberTranslator.get(s15) != null) {
            return;
        }
        this.stateNumberTranslator.put(s15, Utils.integer(this.stateCounter));
        ++this.stateCounter;
        for (int i15 = 0; i15 < s15.getNumberOfTransitions(); ++i15) {
            Transition edge = s15.transition(i15);
            this.walkFANormalizingStateNumbers(edge.target);
            if (!(edge instanceof RuleClosureTransition)) continue;
            this.walkFANormalizingStateNumbers(((RuleClosureTransition)edge).followState);
        }
    }

    protected void walkSerializingFA(List<String> lines, State s15) {
        if (this.markedStates.contains(s15)) {
            return;
        }
        this.markedStates.add(s15);
        int normalizedStateNumber = s15.stateNumber;
        if (this.stateNumberTranslator != null) {
            Integer normalizedStateNumberI = this.stateNumberTranslator.get(s15);
            normalizedStateNumber = normalizedStateNumberI;
        }
        String stateStr = this.getStateString(normalizedStateNumber, s15);
        for (int i15 = 0; i15 < s15.getNumberOfTransitions(); ++i15) {
            Transition edge = s15.transition(i15);
            StringBuilder buf = new StringBuilder();
            buf.append(stateStr);
            if (edge.isAction()) {
                buf.append("-{}->");
            } else if (edge.isEpsilon()) {
                buf.append("->");
            } else if (edge.isSemanticPredicate()) {
                buf.append("-{").append(edge.label.getSemanticContext()).append("}?->");
            } else {
                SemanticContext preds;
                String predsStr = "";
                if (edge.target instanceof DFAState && (preds = ((DFAState)edge.target).getGatedPredicatesInNFAConfigurations()) != null) {
                    predsStr = "&&{" + preds.genExpr(this.grammar.generator, this.grammar.generator.getTemplates(), null).render() + "}?";
                }
                buf.append("-").append(edge.label.toString(this.grammar)).append(predsStr).append("->");
            }
            int normalizedTargetStateNumber = edge.target.stateNumber;
            if (this.stateNumberTranslator != null) {
                Integer normalizedTargetStateNumberI = this.stateNumberTranslator.get(edge.target);
                normalizedTargetStateNumber = normalizedTargetStateNumberI;
            }
            buf.append(this.getStateString(normalizedTargetStateNumber, edge.target));
            buf.append("\n");
            lines.add(buf.toString());
            this.walkSerializingFA(lines, edge.target);
            if (!(edge instanceof RuleClosureTransition)) continue;
            this.walkSerializingFA(lines, ((RuleClosureTransition)edge).followState);
        }
    }

    private String getStateString(int n15, State s15) {
        String stateStr = ".s" + n15;
        if (s15.isAcceptState()) {
            stateStr = s15 instanceof DFAState ? ":s" + n15 + "=>" + ((DFAState)s15).getUniquelyPredictedAlt() : ":s" + n15;
        }
        return stateStr;
    }
}

