/*
 * Decompiled with CFR 0.152.
 */
package jadx.zip;

import jadx.zip.IZipEntry;
import jadx.zip.IZipParser;
import jadx.zip.ZipContent;
import jadx.zip.ZipReaderFlags;
import jadx.zip.ZipReaderOptions;
import jadx.zip.fallback.FallbackZipParser;
import jadx.zip.parser.JadxZipParser;
import jadx.zip.security.IJadxZipSecurity;
import jadx.zip.security.JadxZipSecurity;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public class ZipReader {
    private final ZipReaderOptions options;

    public ZipReader() {
        this(ZipReaderOptions.getDefault());
    }

    public ZipReader(Set<ZipReaderFlags> flags) {
        this(new ZipReaderOptions(new JadxZipSecurity(), flags));
    }

    public ZipReader(IJadxZipSecurity security) {
        this(new ZipReaderOptions(security, ZipReaderFlags.none()));
    }

    public ZipReader(ZipReaderOptions options) {
        this.options = options;
    }

    public ZipContent open(File zipFile) throws IOException {
        try {
            JadxZipParser jadxParser = new JadxZipParser(zipFile, this.options);
            IZipParser detectedParser = this.detectParser(zipFile, jadxParser);
            if (detectedParser != jadxParser) {
                jadxParser.close();
            }
            return detectedParser.open();
        }
        catch (Exception e15) {
            if (this.options.getFlags().contains((Object)ZipReaderFlags.DONT_USE_FALLBACK)) {
                throw new IOException("Failed to open zip: " + String.valueOf(zipFile), e15);
            }
            return this.buildFallbackParser(zipFile).open();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public <R> R visitEntries(File file2, Function<IZipEntry, R> visitor2) {
        try (ZipContent content = this.open(file2);){
            IZipEntry entry;
            R result;
            Iterator<IZipEntry> iterator2 = content.getEntries().iterator();
            do {
                if (!iterator2.hasNext()) return null;
            } while ((result = visitor2.apply(entry = iterator2.next())) == null);
            R r15 = result;
            return r15;
        }
        catch (Exception e15) {
            throw new RuntimeException("Failed to process zip file: " + file2.getAbsolutePath(), e15);
        }
    }

    public void readEntries(File file2, BiConsumer<IZipEntry, InputStream> visitor2) {
        this.visitEntries(file2, entry -> {
            if (!entry.isDirectory()) {
                try (InputStream in4 = entry.getInputStream();){
                    visitor2.accept((IZipEntry)entry, in4);
                }
                catch (Exception e15) {
                    throw new RuntimeException("Failed to process zip entry: " + String.valueOf(entry), e15);
                }
            }
            return null;
        });
    }

    public ZipReaderOptions getOptions() {
        return this.options;
    }

    private IZipParser detectParser(File zipFile, JadxZipParser jadxParser) {
        if (zipFile.getName().endsWith(".apk") || this.options.getFlags().contains((Object)ZipReaderFlags.DONT_USE_FALLBACK)) {
            return jadxParser;
        }
        if (!jadxParser.canOpen()) {
            return this.buildFallbackParser(zipFile);
        }
        if (this.options.getFlags().contains((Object)ZipReaderFlags.FALLBACK_AS_DEFAULT)) {
            return this.buildFallbackParser(zipFile);
        }
        return jadxParser;
    }

    private FallbackZipParser buildFallbackParser(File zipFile) {
        return new FallbackZipParser(zipFile, this.options);
    }
}

