/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.java.data.attributes.stack;

import jadx.plugins.input.java.data.DataReader;
import jadx.plugins.input.java.data.attributes.stack.StackValueType;

public class TypeInfoReader {
    private static final int ITEM_TOP = 0;
    private static final int ITEM_INT = 1;
    private static final int ITEM_FLOAT = 2;
    private static final int ITEM_DOUBLE = 3;
    private static final int ITEM_LONG = 4;
    private static final int ITEM_NULL = 5;
    private static final int ITEM_UNINITIALIZED_THIS = 6;
    private static final int ITEM_OBJECT = 7;
    private static final int ITEM_UNINITIALIZED = 8;

    static StackValueType[] readTypeInfoList(DataReader reader, int count) {
        StackValueType[] types = new StackValueType[count];
        for (int i15 = 0; i15 < count; ++i15) {
            StackValueType type;
            int tag = reader.readU1();
            switch (tag) {
                case 3: 
                case 4: {
                    type = StackValueType.WIDE;
                    break;
                }
                case 7: 
                case 8: {
                    reader.readU2();
                    type = StackValueType.NARROW;
                    break;
                }
                default: {
                    type = StackValueType.NARROW;
                }
            }
            types[i15] = type;
        }
        return types;
    }

    static void skipTypeInfoList(DataReader reader, int count) {
        for (int i15 = 0; i15 < count; ++i15) {
            int tag = reader.readU1();
            if (tag != 7 && tag != 8) continue;
            reader.readU2();
        }
    }
}

