/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.aab.parsers;

import com.android.aapt.Resources;
import jadx.api.ICodeInfo;
import jadx.api.ICodeWriter;
import jadx.core.dex.nodes.RootNode;
import jadx.core.utils.StringUtils;
import jadx.core.utils.android.AndroidResourcesMap;
import jadx.core.xmlgen.XMLChar;
import jadx.core.xmlgen.XmlDeobf;
import jadx.core.xmlgen.XmlGenUtils;
import jadx.plugins.input.aab.parsers.CommonProtoParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class ResXmlProtoParser
extends CommonProtoParser {
    private Map<String, String> nsMap;
    private final Map<String, String> tagAttrDeobfNames = new HashMap<String, String>();
    private ICodeWriter writer;
    private final RootNode rootNode;
    private String currentTag;
    private String appPackageName;
    private final boolean isPrettyPrint;

    public ResXmlProtoParser(RootNode rootNode) {
        this.rootNode = rootNode;
        this.isPrettyPrint = !rootNode.getArgs().isSkipXmlPrettyPrint();
    }

    public synchronized ICodeInfo parse(InputStream inputStream) throws IOException {
        this.nsMap = new HashMap<String, String>();
        this.writer = this.rootNode.makeCodeWriter();
        this.writer.add("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        this.decode(this.decodeProto(inputStream));
        this.nsMap = null;
        return this.writer.finish();
    }

    private void decode(Resources.XmlNode n15) throws IOException {
        if (n15.hasSource()) {
            this.writer.attachSourceLine(n15.getSource().getLineNumber());
        }
        this.writer.add(StringUtils.escapeXML(n15.getText().trim()));
        if (n15.hasElement()) {
            this.decode(n15.getElement());
        }
    }

    private void decode(Resources.XmlElement e15) throws IOException {
        String tag = this.deobfClassName(e15.getName());
        this.currentTag = tag = this.getValidTagAttributeName(tag);
        this.writer.startLine('<').add(tag);
        this.decodeNamespaces(e15);
        this.decodeAttributes(e15);
        if (e15.getChildCount() > 0) {
            this.writer.add('>');
            this.writer.incIndent();
            for (int i15 = 0; i15 < e15.getChildCount(); ++i15) {
                HashMap<String, String> oldNsMap = new HashMap<String, String>(this.nsMap);
                this.decode(e15.getChild(i15));
                this.nsMap = oldNsMap;
            }
            this.writer.decIndent();
            this.writer.startLine("</").add(tag).add('>');
        } else {
            this.writer.add(" />");
        }
    }

    private void decodeNamespaces(Resources.XmlElement e15) {
        boolean newLine;
        int nsCount = e15.getNamespaceDeclarationCount();
        boolean bl4 = newLine = nsCount != 1 && this.isPrettyPrint;
        if (nsCount > 0) {
            this.writer.add(' ');
        }
        for (int i15 = 0; i15 < nsCount; ++i15) {
            this.decodeNamespace(e15.getNamespaceDeclaration(i15), newLine, i15 == nsCount - 1);
        }
    }

    private void decodeNamespace(Resources.XmlNamespace n15, boolean newLine, boolean isLastElement) {
        String prefix = n15.getPrefix();
        String uri = n15.getUri();
        this.nsMap.put(uri, prefix);
        this.writer.add("xmlns:").add(prefix).add("=\"").add(uri).add('\"');
        if (isLastElement) {
            return;
        }
        if (newLine) {
            this.writer.startLine().addIndent();
        } else {
            this.writer.add(' ');
        }
    }

    private void decodeAttributes(Resources.XmlElement e15) {
        boolean newLine;
        int attrsCount = e15.getAttributeCount();
        boolean bl4 = newLine = attrsCount != 1 && this.isPrettyPrint;
        if (attrsCount > 0) {
            this.writer.add(' ');
            if (this.isPrettyPrint) {
                this.writer.startLine().addIndent();
            }
        }
        HashSet<String> attrCache = new HashSet<String>();
        for (int i15 = 0; i15 < attrsCount; ++i15) {
            this.decodeAttribute(e15.getAttribute(i15), attrCache, newLine, i15 == attrsCount - 1);
        }
    }

    private void decodeAttribute(Resources.XmlAttribute a15, Set<String> attrCache, boolean newLine, boolean isLastElement) {
        String name = this.getAttributeFullName(a15);
        if (XmlDeobf.isDuplicatedAttr(name, attrCache)) {
            return;
        }
        String value = this.deobfClassName(this.getAttributeValue(a15));
        this.writer.add(name).add("=\"").add(StringUtils.escapeXML(value)).add('\"');
        this.memorizePackageName(name, value);
        if (isLastElement) {
            return;
        }
        if (newLine) {
            this.writer.startLine().addIndent();
        } else {
            this.writer.add(' ');
        }
    }

    private String getAttributeFullName(Resources.XmlAttribute a15) {
        String attrName;
        String namespaceUri = a15.getNamespaceUri();
        String namespace = null;
        if (!namespaceUri.isEmpty()) {
            namespace = this.nsMap.get(namespaceUri);
        }
        if ((attrName = a15.getName()).isEmpty()) {
            int resId = a15.getResourceId();
            String str = AndroidResourcesMap.getResName(resId);
            if (str != null) {
                namespace = this.nsMap.get("http://schemas.android.com/apk/res/android");
                int typeEnd = str.indexOf(47);
                attrName = typeEnd != -1 ? str.substring(typeEnd + 1) : str;
            } else {
                attrName = "_unknown_";
            }
        }
        return namespace != null ? namespace + ":" + attrName : attrName;
    }

    private String getAttributeValue(Resources.XmlAttribute a15) {
        if (!a15.getValue().isEmpty()) {
            return a15.getValue();
        }
        return this.parse(a15.getCompiledItem());
    }

    private void memorizePackageName(String attrName, String attrValue) {
        if ("manifest".equals(this.currentTag) && "package".equals(attrName)) {
            this.appPackageName = attrValue;
        }
    }

    private String deobfClassName(String className) {
        String newName = XmlDeobf.deobfClassName(this.rootNode, className, this.appPackageName);
        if (newName != null) {
            return newName;
        }
        return className;
    }

    private String getValidTagAttributeName(String originalName) {
        String generated;
        if (XMLChar.isValidName(originalName)) {
            return originalName;
        }
        if (this.tagAttrDeobfNames.containsKey(originalName)) {
            return this.tagAttrDeobfNames.get(originalName);
        }
        while (this.tagAttrDeobfNames.containsValue(generated = ResXmlProtoParser.generateTagAttrName())) {
        }
        this.tagAttrDeobfNames.put(originalName, generated);
        return generated;
    }

    private static String generateTagAttrName() {
        int length = 6;
        Random r15 = new Random();
        StringBuilder sb5 = new StringBuilder();
        for (int i15 = 1; i15 <= 6; ++i15) {
            sb5.append((char)(r15.nextInt(26) + 97));
        }
        return sb5.toString();
    }

    private Resources.XmlNode decodeProto(InputStream inputStream) throws IOException {
        return Resources.XmlNode.parseFrom(XmlGenUtils.readData(inputStream));
    }
}

